/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.criteria;

import java.util.List;
import org.cpsolver.coursett.Constants;
import org.cpsolver.coursett.constraint.RoomConstraint;
import org.cpsolver.coursett.criteria.BrokenTimePatterns;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.ifs.util.DataProperties;

public class UselessHalfHours
extends BrokenTimePatterns {
    @Override
    public double getWeightDefault(DataProperties config) {
        return (double)Constants.sPreferenceLevelStronglyDiscouraged * config.getPropertyDouble("Comparator.UselessSlotWeight", 0.1);
    }

    @Override
    public String getPlacementSelectionWeightName() {
        return "Placement.UselessSlotsWeight";
    }

    @Override
    protected double penalty(RoomConstraint.RoomConstraintContext rc) {
        return UselessHalfHours.countUselessSlotsHalfHours(rc);
    }

    @Override
    protected double penalty(RoomConstraint.RoomConstraintContext rc, Placement value) {
        return UselessHalfHours.countUselessSlotsHalfHours(rc, value);
    }

    private static boolean isEmpty(RoomConstraint.RoomConstraintContext rc, int slot, Placement placement) {
        List<Placement> assigned = rc.getPlacements(slot);
        return assigned.isEmpty() || placement != null && assigned.size() == 1 && ((Lecture)assigned.get(0).variable()).equals(placement.variable());
    }

    private static boolean isUselessBefore(RoomConstraint.RoomConstraintContext rc, int slot, Placement placement) {
        int s = slot % 288;
        if (s - 1 < 0 || s + 6 >= 288) {
            return false;
        }
        return !UselessHalfHours.isEmpty(rc, slot - 1, placement) && UselessHalfHours.isEmpty(rc, slot + 0, placement) && UselessHalfHours.isEmpty(rc, slot + 1, placement) && UselessHalfHours.isEmpty(rc, slot + 2, placement) && UselessHalfHours.isEmpty(rc, slot + 3, placement) && UselessHalfHours.isEmpty(rc, slot + 4, placement) && UselessHalfHours.isEmpty(rc, slot + 5, placement) && UselessHalfHours.isEmpty(rc, slot + 6, placement);
    }

    private static boolean isUselessAfter(RoomConstraint.RoomConstraintContext rc, int slot, Placement placement) {
        int s = slot % 288;
        if (s - 1 < 0 || s + 6 >= 288) {
            return false;
        }
        return UselessHalfHours.isEmpty(rc, slot - 1, placement) && UselessHalfHours.isEmpty(rc, slot + 0, placement) && UselessHalfHours.isEmpty(rc, slot + 1, placement) && UselessHalfHours.isEmpty(rc, slot + 2, placement) && UselessHalfHours.isEmpty(rc, slot + 3, placement) && UselessHalfHours.isEmpty(rc, slot + 4, placement) && UselessHalfHours.isEmpty(rc, slot + 5, placement) && !UselessHalfHours.isEmpty(rc, slot + 6, placement);
    }

    private static boolean isUseless(RoomConstraint.RoomConstraintContext rc, int slot, Placement placement) {
        int s = slot % 288;
        if (s - 1 < 0 || s + 6 >= 288) {
            return false;
        }
        return !UselessHalfHours.isEmpty(rc, slot - 1, placement) && UselessHalfHours.isEmpty(rc, slot + 0, placement) && UselessHalfHours.isEmpty(rc, slot + 1, placement) && UselessHalfHours.isEmpty(rc, slot + 2, placement) && UselessHalfHours.isEmpty(rc, slot + 3, placement) && UselessHalfHours.isEmpty(rc, slot + 4, placement) && UselessHalfHours.isEmpty(rc, slot + 5, placement) && !UselessHalfHours.isEmpty(rc, slot + 6, placement);
    }

    protected static int countUselessSlotsHalfHours(RoomConstraint.RoomConstraintContext rc, Placement placement) {
        int ret = 0;
        TimeLocation time = placement.getTimeLocation();
        int slot = time.getStartSlot() % 288;
        int days = time.getDayCode();
        for (int d = 0; d < Constants.NR_DAYS; ++d) {
            if ((Constants.DAY_CODES[d] & days) == 0) continue;
            if (UselessHalfHours.isUselessBefore(rc, d * 288 + slot - 6, placement)) {
                ++ret;
            }
            if (UselessHalfHours.isUselessAfter(rc, d * 288 + slot + time.getNrSlotsPerMeeting(), placement)) {
                ++ret;
            }
            if (time.getNrSlotsPerMeeting() != 6 || !UselessHalfHours.isUseless(rc, d * 288 + slot, placement)) continue;
            --ret;
        }
        return ret;
    }

    private static boolean isUseless(RoomConstraint.RoomConstraintContext rc, int slot) {
        int s = slot % 288;
        if (s - 1 < 0 || s + 6 >= 288) {
            return false;
        }
        return !rc.getPlacements(slot - 1).isEmpty() && rc.getPlacements(slot + 0).isEmpty() && rc.getPlacements(slot + 1).isEmpty() && rc.getPlacements(slot + 2).isEmpty() && rc.getPlacements(slot + 3).isEmpty() && rc.getPlacements(slot + 4).isEmpty() && rc.getPlacements(slot + 5).isEmpty() && !rc.getPlacements(slot + 6).isEmpty();
    }

    public static int countUselessSlotsHalfHours(RoomConstraint.RoomConstraintContext rc) {
        int ret = 0;
        for (int d = 0; d < Constants.NR_DAYS; ++d) {
            for (int s = 0; s < 288; ++s) {
                int slot = d * 288 + s;
                if (!UselessHalfHours.isUseless(rc, slot)) continue;
                ++ret;
            }
        }
        return ret;
    }
}

