/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.constraint;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Constraint;

public class ClassLimitConstraint
extends Constraint<Lecture, Placement> {
    private int iClassLimit = 0;
    private Lecture iParent = null;
    private String iName = null;
    boolean iEnabled = true;
    private int iClassLimitDelta = 0;

    public ClassLimitConstraint(int classLimit, String name) {
        this.iClassLimit = classLimit;
        this.iName = name;
    }

    public ClassLimitConstraint(Lecture parent, String name) {
        this.iParent = parent;
        this.iName = name;
    }

    public int getClassLimitDelta() {
        return this.iClassLimitDelta;
    }

    public void setClassLimitDelta(int classLimitDelta) {
        this.iClassLimitDelta = classLimitDelta;
    }

    public int classLimit() {
        return this.iParent == null ? this.iClassLimit + this.iClassLimitDelta : this.iParent.minClassLimit() + this.iClassLimitDelta;
    }

    public Lecture getParentLecture() {
        return this.iParent;
    }

    public int currentClassLimit(Assignment<Lecture, Placement> assignment, Placement value, Set<Placement> conflicts) {
        int limit = 0;
        for (Lecture lecture : this.variables()) {
            limit += lecture.classLimit(assignment, value, conflicts);
        }
        return limit;
    }

    @Override
    public void computeConflicts(Assignment<Lecture, Placement> assignment, Placement value, Set<Placement> conflicts) {
        int classLimit;
        if (!this.iEnabled) {
            return;
        }
        int currentLimit = this.currentClassLimit(assignment, value, conflicts);
        if (currentLimit < (classLimit = this.classLimit())) {
            TreeSet<Placement> adepts = new TreeSet<Placement>(new ClassLimitComparator());
            this.computeAdepts(assignment, adepts, this.variables(), value, conflicts);
            this.addParentAdepts(assignment, adepts, this.iParent, value, conflicts);
            for (Placement adept : adepts) {
                conflicts.add(adept);
                currentLimit = this.currentClassLimit(assignment, value, conflicts);
                if (currentLimit < classLimit) continue;
                break;
            }
        }
        if (currentLimit < classLimit) {
            conflicts.add(value);
        }
        if (this.iParent != null && this.iParent.getClassLimitConstraint() != null) {
            this.iParent.getClassLimitConstraint().computeConflicts(assignment, value, conflicts);
        }
    }

    public void computeAdepts(Assignment<Lecture, Placement> assignment, Collection<Placement> adepts, List<Lecture> variables, Placement value, Set<Placement> conflicts) {
        for (Lecture lecture : variables) {
            if (lecture.isCommitted()) continue;
            Placement placement = assignment.getValue(lecture);
            if (placement != null && !placement.equals(value) && !conflicts.contains(placement)) {
                adepts.add(placement);
            }
            if (!lecture.hasAnyChildren()) continue;
            for (Long subpartId : lecture.getChildrenSubpartIds()) {
                this.computeAdepts(assignment, adepts, lecture.getChildren(subpartId), value, conflicts);
            }
        }
    }

    public void addParentAdepts(Assignment<Lecture, Placement> assignment, Collection<Placement> adepts, Lecture parent, Placement value, Set<Placement> conflicts) {
        if (parent == null || parent.isCommitted() || parent.minClassLimit() == parent.maxClassLimit()) {
            return;
        }
        Placement placement = assignment.getValue(parent);
        if (placement != null && !placement.equals(value) && !conflicts.contains(placement)) {
            adepts.add(placement);
        }
        this.addParentAdepts(assignment, adepts, parent.getParent(), value, conflicts);
    }

    @Override
    public boolean inConflict(Assignment<Lecture, Placement> assignment, Placement value) {
        int classLimit;
        if (!this.iEnabled) {
            return false;
        }
        int currentLimit = this.currentClassLimit(assignment, value, null);
        if (currentLimit < (classLimit = this.classLimit())) {
            return true;
        }
        if (this.iParent != null && this.iParent.getClassLimitConstraint() != null) {
            return this.iParent.getClassLimitConstraint().inConflict(assignment, value);
        }
        return false;
    }

    @Override
    public String getName() {
        return this.iName;
    }

    public void setEnabled(boolean enabled) {
        this.iEnabled = enabled;
    }

    public boolean isEnabled() {
        return this.iEnabled;
    }

    public String toString() {
        return "Class-limit " + this.getName();
    }

    private static class ClassLimitComparator
    implements Comparator<Placement> {
        private ClassLimitComparator() {
        }

        @Override
        public int compare(Placement p1, Placement p2) {
            Lecture l1 = (Lecture)p1.variable();
            Lecture l2 = (Lecture)p2.variable();
            int cl1 = Math.min(l1.maxClassLimit(), (int)Math.floor((double)p1.getRoomSize() / l1.roomToLimitRatio()));
            int cl2 = Math.min(l2.maxClassLimit(), (int)Math.floor((double)p2.getRoomSize() / l2.roomToLimitRatio()));
            int cmp = -Double.compare(l1.maxAchievableClassLimit() - cl1, l2.maxAchievableClassLimit() - cl2);
            if (cmp != 0) {
                return cmp;
            }
            return l1.getClassId().compareTo(l2.getClassId());
        }
    }
}

