/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.server.rpc.jakarta;

import com.google.gwt.user.client.rpc.RpcToken;
import com.google.gwt.user.client.rpc.RpcTokenException;
import com.google.gwt.user.client.rpc.XsrfToken;
import com.google.gwt.user.server.jakarta.Util;
import com.google.gwt.user.server.rpc.jakarta.AbstractXsrfProtectedServiceServlet;
import com.google.gwt.util.tools.shared.Md5Utils;
import com.google.gwt.util.tools.shared.StringUtils;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.Cookie;
import java.lang.reflect.Method;

public class XsrfProtectedServiceServlet
extends AbstractXsrfProtectedServiceServlet {
    String sessionCookieName = null;

    public XsrfProtectedServiceServlet() {
        this(null);
    }

    public XsrfProtectedServiceServlet(String sessionCookieName) {
        this.sessionCookieName = sessionCookieName;
    }

    public XsrfProtectedServiceServlet(Object delegate) {
        this(delegate, null);
    }

    public XsrfProtectedServiceServlet(Object delegate, String sessionCookieName) {
        super(delegate);
        this.sessionCookieName = sessionCookieName;
    }

    public void init() throws ServletException {
        super.init();
        if (this.sessionCookieName == null) {
            this.sessionCookieName = this.getServletConfig().getInitParameter("gwt.xsrf.session_cookie_name");
            if (this.sessionCookieName == null) {
                this.sessionCookieName = this.getServletContext().getInitParameter("gwt.xsrf.session_cookie_name");
            }
            if (this.sessionCookieName == null) {
                throw new IllegalStateException("Session cookie name not set! Use 'gwt.xsrf.session_cookie_name' context-param to specify session cookie name");
            }
        }
    }

    @Override
    protected void validateXsrfToken(RpcToken token, Method method) throws RpcTokenException {
        XsrfToken xsrfToken;
        if (token == null) {
            throw new RpcTokenException("XSRF token missing");
        }
        Cookie sessionCookie = Util.getCookie(this.getThreadLocalRequest(), this.sessionCookieName, false);
        if (sessionCookie == null || sessionCookie.getValue() == null || sessionCookie.getValue().length() == 0) {
            throw new RpcTokenException("Session cookie is missing or empty! Unable to verify XSRF cookie");
        }
        String expectedToken = StringUtils.toHexString(Md5Utils.getMd5Digest(sessionCookie.getValue().getBytes()));
        if (!expectedToken.equals((xsrfToken = (XsrfToken)token).getToken())) {
            throw new RpcTokenException("Invalid XSRF token");
        }
    }
}

