/*
 * Decompiled with CFR 0.152.
 */
package biweekly.util;

import biweekly.Messages;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class UtcOffset {
    private final long millis;

    public UtcOffset(boolean positive, int hour, int minute) {
        int sign = positive ? 1 : -1;
        hour = Math.abs(hour);
        minute = Math.abs(minute);
        this.millis = (long)sign * (UtcOffset.hoursToMillis(hour) + UtcOffset.minutesToMillis(minute));
    }

    public UtcOffset(long millis) {
        this.millis = millis;
    }

    public static UtcOffset parse(String text) {
        Pattern timeZoneRegex = Pattern.compile("^([-\\+])?(\\d{1,2})(:?(\\d{2}))?(:?(\\d{2}))?$");
        Matcher m = timeZoneRegex.matcher(text);
        if (!m.find()) {
            throw Messages.INSTANCE.getIllegalArgumentException(21, text);
        }
        String signStr = m.group(1);
        boolean positive = !"-".equals(signStr);
        String hourStr = m.group(2);
        int hourOffset = Integer.parseInt(hourStr);
        String minuteStr = m.group(4);
        int minuteOffset = minuteStr == null ? 0 : Integer.parseInt(minuteStr);
        return new UtcOffset(positive, hourOffset, minuteOffset);
    }

    public static UtcOffset parse(TimeZone timezone) {
        long offset = timezone.getOffset(System.currentTimeMillis());
        return new UtcOffset(offset);
    }

    public long getMillis() {
        return this.millis;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean extended) {
        StringBuilder sb = new StringBuilder();
        boolean positive = this.millis >= 0L;
        long hour = Math.abs(UtcOffset.millisToHours(this.millis));
        long minute = Math.abs(UtcOffset.millisToMinutes(this.millis));
        sb.append(positive ? (char)'+' : '-');
        if (hour < 10L) {
            sb.append('0');
        }
        sb.append(hour);
        if (extended) {
            sb.append(':');
        }
        if (minute < 10L) {
            sb.append('0');
        }
        sb.append(minute);
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.millis ^ this.millis >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UtcOffset other = (UtcOffset)obj;
        return this.millis == other.millis;
    }

    private static long hoursToMillis(long hours) {
        return hours * 60L * 60L * 1000L;
    }

    private static long minutesToMillis(long minutes) {
        return minutes * 60L * 1000L;
    }

    private static long millisToHours(long millis) {
        return millis / 1000L / 60L / 60L;
    }

    private static long millisToMinutes(long millis) {
        return millis / 1000L / 60L % 60L;
    }
}

