/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.report;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.GlobalConstraint;
import org.cpsolver.ifs.util.CSVFile;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.constraint.ConfigLimit;
import org.cpsolver.studentsct.constraint.CourseLimit;
import org.cpsolver.studentsct.constraint.SectionLimit;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.report.AbstractStudentSectioningReport;

public class CourseConflictTable
extends AbstractStudentSectioningReport {
    private static Logger sLog = LogManager.getLogger(CourseConflictTable.class);
    private static DecimalFormat sDF = new DecimalFormat("0.000");

    public CourseConflictTable(StudentSectioningModel model) {
        super(model);
    }

    private boolean areInHardConfict(Assignment<Request, Enrollment> assignment, Request r1, Request r2) {
        for (Enrollment e1 : r1.values(assignment)) {
            for (Enrollment e2 : r2.values(assignment)) {
                if (e1.isOverlapping(e2)) continue;
                return false;
            }
        }
        return true;
    }

    private Set<String> explanations(Assignment<Request, Enrollment> assignment, Enrollment enrl, Enrollment conflict, boolean useAmPm) {
        HashSet<String> expl = new HashSet<String>();
        for (Section s1 : enrl.getSections()) {
            for (Section s2 : conflict.getSections()) {
                if (!s1.isOverlapping(s2)) continue;
                expl.add(s1.getSubpart().getName() + " " + s1.getTime().getLongName(useAmPm) + " vs " + s2.getSubpart().getName() + " " + s2.getTime().getLongName(useAmPm));
            }
        }
        for (Section s1 : enrl.getSections()) {
            if (!conflict.getAssignments().contains(s1) || !(SectionLimit.getEnrollmentWeight(assignment, s1, enrl.getRequest()) > (double)s1.getLimit())) continue;
            expl.add(s1.getSubpart().getName() + " n/a");
        }
        if (enrl.getConfig() != null && enrl.getConfig().equals(conflict.getConfig()) && ConfigLimit.getEnrollmentWeight(assignment, enrl.getConfig(), enrl.getRequest()) > (double)enrl.getConfig().getLimit()) {
            expl.add(enrl.getConfig().getName() + " n/a");
        }
        if (enrl.getCourse() != null && enrl.getCourse().equals(conflict.getCourse()) && CourseLimit.getEnrollmentWeight(assignment, enrl.getCourse(), enrl.getRequest()) > (double)enrl.getCourse().getLimit()) {
            expl.add(enrl.getCourse().getName() + " n/a");
        }
        return expl;
    }

    @Override
    public CSVFile createTable(Assignment<Request, Enrollment> assignment, DataProperties properties) {
        CSVFile csv = new CSVFile();
        csv.setHeader(new CSVFile.CSVField[]{new CSVFile.CSVField("UnasgnCrs"), new CSVFile.CSVField("ConflCrs"), new CSVFile.CSVField("NrStud"), new CSVFile.CSVField("StudWeight"), new CSVFile.CSVField("NoAlt"), new CSVFile.CSVField("Reason")});
        HashMap unassignedCourseTable = new HashMap();
        block0: for (Request request : new ArrayList<Request>(this.getModel().unassignedVariables(assignment))) {
            GlobalConstraint c22;
            CourseRequest courseRequest;
            if (!this.matches(request) || !(request instanceof CourseRequest) || (courseRequest = (CourseRequest)request).getStudent().isComplete(assignment)) continue;
            List<Enrollment> values = courseRequest.values(assignment);
            SectionLimit limitConstraint = null;
            for (GlobalConstraint c22 : this.getModel().globalConstraints()) {
                if (!(c22 instanceof SectionLimit)) continue;
                limitConstraint = (SectionLimit)c22;
                break;
            }
            if (limitConstraint == null) {
                limitConstraint = new SectionLimit(new DataProperties());
                limitConstraint.setModel(this.getModel());
            }
            ArrayList<Enrollment> availableValues = new ArrayList<Enrollment>(values.size());
            c22 = values.iterator();
            while (c22.hasNext()) {
                Enrollment enrollment = (Enrollment)c22.next();
                if (limitConstraint.inConflict(assignment, enrollment)) continue;
                availableValues.add(enrollment);
            }
            if (availableValues.isEmpty()) {
                Object[] weight;
                Course course = courseRequest.getCourses().get(0);
                HashMap<Object, Object[]> conflictCourseTable = (HashMap<Object, Object[]>)unassignedCourseTable.get(course);
                if (conflictCourseTable == null) {
                    conflictCourseTable = new HashMap<Object, Object[]>();
                    unassignedCourseTable.put(course, conflictCourseTable);
                }
                double nrStud = ((weight = (Object[])conflictCourseTable.get(course)) == null ? 0.0 : (Double)weight[0]) + 1.0;
                double nrStudW = (weight == null ? 0.0 : (Double)weight[1]) + request.getWeight();
                boolean noAlt = weight == null ? true : (Boolean)weight[2];
                HashSet expl = weight == null ? new HashSet() : (HashSet)weight[3];
                expl.add(course.getName() + " n/a");
                conflictCourseTable.put(course, new Object[]{nrStud, nrStudW, noAlt, expl});
            }
            for (Enrollment enrollment : availableValues) {
                Set<Enrollment> conflicts = this.getModel().conflictValues(assignment, enrollment);
                if (conflicts.isEmpty()) {
                    sLog.warn("Request " + courseRequest + " of student " + courseRequest.getStudent() + " not assigned, however, no conflicts were returned.");
                    assignment.assign(0L, enrollment);
                    continue block0;
                }
                Course course = null;
                for (Course c3 : courseRequest.getCourses()) {
                    if (!c3.getOffering().equals(enrollment.getConfig().getOffering())) continue;
                    course = c3;
                    break;
                }
                if (course == null) {
                    sLog.warn("Course not found for request " + courseRequest + " of student " + courseRequest.getStudent() + ".");
                    continue;
                }
                HashMap<Course, Object[]> conflictCourseTable = (HashMap<Course, Object[]>)unassignedCourseTable.get(course);
                if (conflictCourseTable == null) {
                    conflictCourseTable = new HashMap<Course, Object[]>();
                    unassignedCourseTable.put(course, conflictCourseTable);
                }
                for (Enrollment conflict : conflicts) {
                    if (!(conflict.variable() instanceof CourseRequest)) continue;
                    CourseRequest conflictCourseRequest = (CourseRequest)conflict.variable();
                    Course conflictCourse = null;
                    for (Course c4 : conflictCourseRequest.getCourses()) {
                        if (!c4.getOffering().equals(conflict.getConfig().getOffering())) continue;
                        conflictCourse = c4;
                        break;
                    }
                    if (conflictCourse == null) {
                        sLog.warn("Course not found for request " + conflictCourseRequest + " of student " + conflictCourseRequest.getStudent() + ".");
                        continue;
                    }
                    double weightThisConflict = request.getWeight() / (double)availableValues.size() / (double)conflicts.size();
                    double partThisConflict = 1.0 / (double)availableValues.size() / (double)conflicts.size();
                    Object[] weight = (Object[])conflictCourseTable.get(conflictCourse);
                    double nrStud = (weight == null ? 0.0 : (Double)weight[0]) + partThisConflict;
                    double nrStudW = (weight == null ? 0.0 : (Double)weight[1]) + weightThisConflict;
                    boolean noAlt = weight == null ? this.areInHardConfict(assignment, request, conflict.getRequest()) : ((Boolean)weight[2]).booleanValue();
                    HashSet expl = weight == null ? new HashSet() : (HashSet)weight[3];
                    expl.addAll(this.explanations(assignment, enrollment, conflict, this.isUseAmPm()));
                    conflictCourseTable.put(conflictCourse, new Object[]{nrStud, nrStudW, noAlt, expl});
                }
            }
        }
        for (Map.Entry entry : unassignedCourseTable.entrySet()) {
            Course unassignedCourse = (Course)entry.getKey();
            HashMap conflictCourseTable = (HashMap)entry.getValue();
            for (Map.Entry entry2 : conflictCourseTable.entrySet()) {
                Course conflictCourse = (Course)entry2.getKey();
                Object[] weight = (Object[])entry2.getValue();
                HashSet expl = (HashSet)weight[3];
                String explStr = "";
                Iterator k = new TreeSet(expl).iterator();
                while (k.hasNext()) {
                    explStr = explStr + (String)k.next() + (k.hasNext() ? "\n" : "");
                }
                csv.addLine(new CSVFile.CSVField[]{new CSVFile.CSVField(unassignedCourse.getName()), new CSVFile.CSVField(conflictCourse.getName()), new CSVFile.CSVField(sDF.format(weight[0])), new CSVFile.CSVField(sDF.format(weight[1])), new CSVFile.CSVField((Boolean)weight[2] != false ? "Y" : "N"), new CSVFile.CSVField(explStr)});
            }
        }
        if (csv.getLines() != null) {
            Collections.sort(csv.getLines(), new Comparator<CSVFile.CSVLine>(){

                @Override
                public int compare(CSVFile.CSVLine l1, CSVFile.CSVLine l2) {
                    int cmp = Double.compare(l2.getField(2).toDouble(), l1.getField(2).toDouble());
                    if (cmp != 0) {
                        return cmp;
                    }
                    cmp = l1.getField(0).toString().compareTo(l2.getField(0).toString());
                    if (cmp != 0) {
                        return cmp;
                    }
                    return l1.getField(1).toString().compareTo(l2.getField(1).toString());
                }
            });
        }
        return csv;
    }
}

