/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.heuristics.selection;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cpsolver.ifs.model.Neighbour;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.Progress;
import org.cpsolver.studentsct.heuristics.selection.BranchBoundSelection;
import org.cpsolver.studentsct.heuristics.studentord.StudentOrder;
import org.cpsolver.studentsct.heuristics.studentord.StudentRandomOrder;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Student;

public class ResectionUnassignedStudentsSelection
extends BranchBoundSelection {
    private static Logger sLog = LogManager.getLogger(ResectionUnassignedStudentsSelection.class);

    public ResectionUnassignedStudentsSelection(DataProperties properties) {
        super(properties);
        this.iOrder = new StudentRandomOrder(properties);
        if (properties.getProperty("Neighbour.ResectionUnassignedStudentsOrder") != null) {
            try {
                this.iOrder = (StudentOrder)Class.forName(properties.getProperty("Neighbour.ResectionUnassignedStudentsOrder")).getConstructor(DataProperties.class).newInstance(properties);
            }
            catch (Exception e) {
                sLog.error("Unable to set student order, reason:" + e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void init(Solver<Request, Enrollment> solver) {
        this.init(solver, "Resection unassigned students...");
    }

    @Override
    public Neighbour<Request, Enrollment> selectNeighbour(Solution<Request, Enrollment> solution) {
        Student student = null;
        while ((student = this.nextStudent()) != null) {
            BranchBoundSelection.BranchBoundNeighbour neighbour;
            Progress.getInstance(solution.getModel()).incProgress();
            if (student.nrAssignedRequests(solution.getAssignment()) != 0 || student.getRequests().isEmpty() || (neighbour = this.getSelection(solution.getAssignment(), student).select()) == null) continue;
            return neighbour;
        }
        return null;
    }
}

