/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.heuristics.selection;

import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.studentsct.StudentPreferencePenalties;
import org.cpsolver.studentsct.heuristics.selection.BranchBoundSelection;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.model.Subpart;

public class OnlineSelection
extends BranchBoundSelection {
    private static Logger sLog = LogManager.getLogger(OnlineSelection.class);
    private int iDistributionType = -1;
    private double iEpsilon = 0.05;
    private boolean iUsePenalties = true;
    private boolean iUseStudentPrefPenalties = false;
    private BranchBoundSelection iBranchBound = null;

    public OnlineSelection(DataProperties properties) {
        super(properties);
        this.iUseStudentPrefPenalties = properties.getPropertyBoolean("Sectioning.UseStudentPreferencePenalties", this.iUseStudentPrefPenalties);
        this.iDistributionType = properties.getPropertyInt("Sectioning.Distribution", StudentPreferencePenalties.sDistTypePreference);
        this.iEpsilon = properties.getPropertyDouble("Sectioning.Epsilon", this.iEpsilon);
        this.iUsePenalties = properties.getPropertyBoolean("Sectioning.UseOnlinePenalties", this.iUsePenalties);
        if (this.iUseStudentPrefPenalties && !properties.containsPropery("Sectioning.UseOnlinePenalties")) {
            this.iUsePenalties = false;
        }
        if (this.iUsePenalties || !this.iUseStudentPrefPenalties) {
            this.iBranchBound = new BranchBoundSelection(properties);
        }
        this.iMinimizePenalty = true;
    }

    @Override
    public void init(Solver<Request, Enrollment> solver) {
        this.init(solver, "Online...");
        if (this.iBranchBound != null) {
            this.iBranchBound.init(solver, "Online...");
        }
    }

    public boolean isUseStudentPrefPenalties() {
        return this.iUseStudentPrefPenalties;
    }

    public boolean isUsePenalties() {
        return this.iUsePenalties;
    }

    private static void setPenalties(Assignment<Request, Enrollment> assignment, Student student) {
        for (Request request : student.getRequests()) {
            if (!(request instanceof CourseRequest)) continue;
            CourseRequest courseRequest = (CourseRequest)request;
            for (Course course : courseRequest.getCourses()) {
                for (Config config : course.getOffering().getConfigs()) {
                    for (Subpart subpart : config.getSubparts()) {
                        for (Section section : subpart.getSections()) {
                            section.setPenalty(section.getOnlineSectioningPenalty(assignment));
                        }
                    }
                }
            }
            courseRequest.clearCache();
        }
    }

    public void updateSpace(Assignment<Request, Enrollment> assignment, Student student) {
        for (Request request : student.getRequests()) {
            if (!(request instanceof CourseRequest)) continue;
            CourseRequest courseRequest = (CourseRequest)request;
            Enrollment enrollment = assignment.getValue(courseRequest);
            if (enrollment == null) {
                return;
            }
            for (Section section : enrollment.getSections()) {
                section.setSpaceHeld(section.getSpaceHeld() - courseRequest.getWeight());
            }
            ArrayList<Enrollment> feasibleEnrollments = new ArrayList<Enrollment>();
            for (Enrollment enrl : courseRequest.values(assignment)) {
                boolean overlaps = false;
                for (Request otherRequest : courseRequest.getStudent().getRequests()) {
                    Enrollment otherErollment;
                    if (otherRequest.equals(courseRequest) || !(otherRequest instanceof CourseRequest) || (otherErollment = assignment.getValue(otherRequest)) == null || !enrl.isOverlapping(otherErollment)) continue;
                    overlaps = true;
                    break;
                }
                if (overlaps) continue;
                feasibleEnrollments.add(enrl);
            }
            double d = courseRequest.getWeight() / (double)feasibleEnrollments.size();
            for (Enrollment feasibleEnrollment : feasibleEnrollments) {
                for (Section section3 : feasibleEnrollment.getSections()) {
                    section3.setSpaceExpected(section3.getSpaceExpected() - d);
                }
            }
        }
    }

    @Override
    public BranchBoundSelection.Selection getSelection(Assignment<Request, Enrollment> assignment, Student student) {
        if (this.iUsePenalties) {
            OnlineSelection.setPenalties(assignment, student);
        }
        BranchBoundSelection.Selection selection = null;
        if (this.iBranchBound != null) {
            selection = this.iBranchBound.getSelection(assignment, student);
        }
        if (this.iUseStudentPrefPenalties) {
            selection = new EpsilonSelection(student, assignment, selection);
        }
        return selection;
    }

    public class EpsilonSelection
    extends BranchBoundSelection.Selection {
        private StudentPreferencePenalties iPenalties;
        private BranchBoundSelection.Selection iSelection;

        public EpsilonSelection(Student student, Assignment<Request, Enrollment> assignment, BranchBoundSelection.Selection selection) {
            super(student, assignment);
            this.iPenalties = null;
            this.iSelection = null;
            this.iPenalties = new StudentPreferencePenalties(OnlineSelection.this.iDistributionType);
            this.iSelection = selection;
        }

        @Override
        public BranchBoundSelection.BranchBoundNeighbour select() {
            BranchBoundSelection.BranchBoundNeighbour neighbour;
            BranchBoundSelection.BranchBoundNeighbour onlineSelection = null;
            if (this.iSelection != null) {
                onlineSelection = this.iSelection.select();
                if (BranchBoundSelection.sDebug) {
                    sLog.debug("Online: " + onlineSelection);
                }
            }
            if ((neighbour = super.select()) != null) {
                return neighbour;
            }
            if (onlineSelection != null) {
                return onlineSelection;
            }
            return null;
        }

        @Override
        protected double getAssignmentPenalty(int i) {
            return this.iPenalties.getPenalty(this.iAssignment[i]) + OnlineSelection.this.iDistConfWeight * (double)this.getDistanceConflicts(i).size();
        }

        public boolean isAllowed(int idx, Enrollment enrollment) {
            double limit;
            if (this.iSelection == null || this.iSelection.getBestAssignment() == null || this.iSelection.getBestAssignment()[idx] == null) {
                return true;
            }
            double bestPenalty = this.iSelection.getBestAssignment()[idx].getPenalty();
            double d = OnlineSelection.this.iEpsilon < 0.0 ? Math.max(0.0, bestPenalty) : (limit = (bestPenalty < 0.0 ? 1.0 - OnlineSelection.this.iEpsilon : 1.0 + OnlineSelection.this.iEpsilon) * bestPenalty);
            if (enrollment.getPenalty() > limit) {
                if (BranchBoundSelection.sDebug) {
                    sLog.debug("  -- enrollment " + enrollment + " was filtered out (penalty=" + enrollment.getPenalty() + ", best=" + bestPenalty + ", limit=" + limit + ")");
                }
                return false;
            }
            return true;
        }

        @Override
        public Enrollment firstConflict(int idx, Enrollment enrollment) {
            Enrollment conflict = super.firstConflict(idx, enrollment);
            if (conflict != null) {
                return conflict;
            }
            return this.isAllowed(idx, enrollment) ? null : enrollment;
        }

        public StudentPreferencePenalties getPenalties() {
            return this.iPenalties;
        }
    }
}

