/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.heuristics.selection;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.heuristics.BacktrackNeighbourSelection;
import org.cpsolver.ifs.heuristics.NeighbourSelection;
import org.cpsolver.ifs.model.InfoProvider;
import org.cpsolver.ifs.model.Neighbour;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.solver.SolverListener;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.Progress;
import org.cpsolver.studentsct.filter.StudentFilter;
import org.cpsolver.studentsct.heuristics.RandomizedBacktrackNeighbourSelection;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.FreeTimeRequest;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Student;

public class BacktrackSelection
implements NeighbourSelection<Request, Enrollment>,
InfoProvider<Request, Enrollment>,
SolverListener<Request, Enrollment> {
    private static DecimalFormat sDF = new DecimalFormat("0.00");
    protected RandomizedBacktrackNeighbourSelection iRBtNSel = null;
    protected LinkedList<Request> iRequests = null;
    protected boolean iIncludeAssignedRequests = false;
    protected long iNbrIterations = 0L;
    protected long iMaxIterations = 0L;
    protected long iTotalTime = 0L;
    protected long iNbrTimeoutReached = 0L;
    protected long iNbrNoSolution = 0L;
    protected StudentFilter iFilter = null;
    protected RequestComparator iRequestComparator = null;
    protected Map<Request, Integer> iFailedCounter = new HashMap<Request, Integer>();
    protected long iNbrRequests = 0L;

    public BacktrackSelection(DataProperties properties) {
        this.iIncludeAssignedRequests = properties.getPropertyBoolean("Neighbour.IncludeAssignedRequests", this.iIncludeAssignedRequests);
        this.iRequestComparator = new RequestComparator(properties);
    }

    public void init(Solver<Request, Enrollment> solver, String name) {
        ArrayList<Request> variables = new ArrayList<Request>(this.iIncludeAssignedRequests ? solver.currentSolution().getModel().variables() : solver.currentSolution().getModel().unassignedVariables(solver.currentSolution().getAssignment()));
        Collections.shuffle(variables);
        Collections.sort(variables, this.iRequestComparator);
        this.iRequests = new LinkedList<Request>(variables);
        this.iFailedCounter.clear();
        if (this.iRBtNSel == null) {
            try {
                this.iRBtNSel = new RandomizedBacktrackNeighbourSelection(solver.getProperties());
                this.iRBtNSel.init(solver);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        Progress.getInstance(solver.currentSolution().getModel()).setPhase(name, variables.size());
    }

    @Override
    public void init(Solver<Request, Enrollment> solver) {
        this.init(solver, "Backtracking" + (this.iFilter == null ? "" : " (" + this.iFilter.getName().toLowerCase() + " students)") + "...");
        this.iNbrIterations = 0L;
        this.iNbrTimeoutReached = 0L;
        this.iNbrNoSolution = 0L;
        this.iTotalTime = 0L;
        this.iMaxIterations = Math.max(10, 2 * this.iRequests.size());
        this.iNbrRequests = this.iRequests.size();
    }

    protected synchronized Request nextRequest() {
        Request request;
        do {
            if ((request = this.iRequests.poll()) != null) continue;
            return null;
        } while (this.iFilter != null && !this.iFilter.accept(request.getStudent()));
        return request;
    }

    public synchronized void addRequest(Request request) {
        if (this.iRequests != null && request != null && !request.getStudent().isDummy()) {
            Integer failed = this.iFailedCounter.getOrDefault(request, 0);
            this.iFailedCounter.put(request, 1 + failed);
            if (failed >= 5) {
                return;
            }
            if (request.getStudent().getPriority().ordinal() < Student.StudentPriority.Normal.ordinal() || request.getRequestPriority().ordinal() < Request.RequestPriority.Normal.ordinal()) {
                ListIterator<Request> i = this.iRequests.listIterator();
                while (i.hasNext()) {
                    Request r = (Request)i.next();
                    if (this.iRequestComparator.compare(r, request) <= 0) continue;
                    i.previous();
                    i.add(request);
                    return;
                }
            }
            this.iRequests.add(request);
        }
    }

    @Override
    public Neighbour<Request, Enrollment> selectNeighbour(Solution<Request, Enrollment> solution) {
        Request request = null;
        if (this.iNbrIterations > this.iMaxIterations) {
            return null;
        }
        block2: while ((request = this.nextRequest()) != null) {
            Progress.getInstance(solution.getModel()).setProgress(this.iNbrRequests - (long)this.iRequests.size());
            Enrollment e = request.getAssignment(solution.getAssignment());
            if (e != null && request instanceof FreeTimeRequest || e != null && e.getPriority() == 0 && ((CourseRequest)request).getSelectedChoices().isEmpty()) continue;
            for (int i = 0; i < 5; ++i) {
                try {
                    Neighbour<Request, Enrollment> n = this.iRBtNSel.selectNeighbour(solution, request);
                    if (this.iRBtNSel.getContext() != null) {
                        ++this.iNbrIterations;
                        this.iTotalTime += this.iRBtNSel.getContext().getTime();
                        if (this.iRBtNSel.getContext().isTimeoutReached()) {
                            ++this.iNbrTimeoutReached;
                        }
                        if (n == null) {
                            ++this.iNbrNoSolution;
                        }
                    }
                    if (n == null || !(n.value(solution.getAssignment()) <= 0.0)) continue block2;
                    return n;
                }
                catch (ConcurrentModificationException concurrentModificationException) {
                    continue;
                }
            }
        }
        return null;
    }

    @Override
    public void getInfo(Assignment<Request, Enrollment> assignment, Map<String, String> info) {
        if (this.iNbrIterations > 0L) {
            info.put("Timing of " + this.getClass().getSimpleName(), sDF.format((double)this.iTotalTime / (double)this.iNbrIterations) + " ms/it (" + this.iNbrIterations + " iterations, " + (this.iNbrNoSolution == 0L ? "" : sDF.format(100.0 * (double)this.iNbrNoSolution / (double)this.iNbrIterations) + "% no solution, ") + sDF.format(100.0 * (double)this.iNbrTimeoutReached / (double)this.iNbrIterations) + "% time limit of " + sDF.format((double)this.iRBtNSel.getTimeout() / 1000.0) + " seconds reached" + (this.iNbrIterations > this.iMaxIterations ? ", stopped after " + this.iNbrIterations + " iterations" : "") + ")");
        }
    }

    @Override
    public void getInfo(Assignment<Request, Enrollment> assignment, Map<String, String> info, Collection<Request> variables) {
    }

    public StudentFilter getFilter() {
        return this.iFilter;
    }

    public BacktrackSelection withFilter(StudentFilter filter) {
        this.iFilter = filter;
        return this;
    }

    @Override
    public boolean variableSelected(Assignment<Request, Enrollment> assignment, long iteration, Request variable) {
        return false;
    }

    @Override
    public boolean valueSelected(Assignment<Request, Enrollment> assignment, long iteration, Request variable, Enrollment value) {
        return false;
    }

    @Override
    public boolean neighbourSelected(Assignment<Request, Enrollment> assignment, long iteration, Neighbour<Request, Enrollment> neighbour) {
        return false;
    }

    @Override
    public void neighbourFailed(Assignment<Request, Enrollment> assignment, long iteration, Neighbour<Request, Enrollment> neighbour) {
        if (neighbour instanceof BacktrackNeighbourSelection.BackTrackNeighbour) {
            this.addRequest(((Enrollment)((BacktrackNeighbourSelection.BackTrackNeighbour)neighbour).getAssignments().get(0)).getRequest());
        }
    }

    public static class RequestComparator
    implements Comparator<Request> {
        protected boolean iPreferPriorityStudents = true;

        protected RequestComparator(DataProperties properties) {
            this.iPreferPriorityStudents = properties.getPropertyBoolean("Sectioning.PriorityStudentsFirstSelection.AllIn", true);
        }

        @Override
        public int compare(Request r1, Request r2) {
            if (this.iPreferPriorityStudents) {
                if (r1.getStudent().getPriority() != r2.getStudent().getPriority()) {
                    return r1.getStudent().getPriority().compareTo(r2.getStudent().getPriority());
                }
                if (r1.getRequestPriority() != r2.getRequestPriority()) {
                    return r1.getRequestPriority().compareTo(r2.getRequestPriority());
                }
            } else {
                if (r1.getRequestPriority() != r2.getRequestPriority()) {
                    return r1.getRequestPriority().compareTo(r2.getRequestPriority());
                }
                if (r1.getRequestPriority() != r2.getRequestPriority()) {
                    return r1.getStudent().getPriority().compareTo(r2.getStudent().getPriority());
                }
            }
            if (r1.isAlternative() != r2.isAlternative()) {
                return r2.isAlternative() ? -1 : 1;
            }
            if (r1.getPriority() != r2.getPriority()) {
                return r1.getPriority() < r2.getPriority() ? -1 : 1;
            }
            return 0;
        }
    }
}

