/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.extension;

import org.cpsolver.ifs.extension.ConflictStatistics;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;

public class StudentConflictStatistics
extends ConflictStatistics<Request, Enrollment> {
    public double iRealStudentWeight = 2.0;
    public double iDummyStudentWeight = 0.5;

    public StudentConflictStatistics(Solver<Request, Enrollment> solver, DataProperties properties) {
        super(solver, properties);
        this.iRealStudentWeight = properties.getPropertyDouble("StudentConflictStatistics.RealStudentWeight", this.iRealStudentWeight);
        this.iDummyStudentWeight = properties.getPropertyDouble("StudentConflictStatistics.DummyStudentWeight", this.iDummyStudentWeight);
    }

    @Override
    public double countRemovals(long iteration, Enrollment conflictValue, Enrollment value) {
        double ret = super.countRemovals(iteration, conflictValue, value);
        if (ret == 0.0) {
            return ret;
        }
        Enrollment conflict = conflictValue;
        return ret * (conflict.getRequest().getStudent().isDummy() ? this.iDummyStudentWeight : this.iRealStudentWeight);
    }
}

