/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct;

import java.io.File;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.RoomLocation;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Constraint;
import org.cpsolver.ifs.util.DistanceMetric;
import org.cpsolver.ifs.util.Progress;
import org.cpsolver.studentsct.StudentSectioningLoader;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.constraint.DependentCourses;
import org.cpsolver.studentsct.constraint.FixedAssignments;
import org.cpsolver.studentsct.filter.StudentFilter;
import org.cpsolver.studentsct.model.AreaClassificationMajor;
import org.cpsolver.studentsct.model.Choice;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.FreeTimeRequest;
import org.cpsolver.studentsct.model.Instructor;
import org.cpsolver.studentsct.model.Offering;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.RequestGroup;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.model.StudentGroup;
import org.cpsolver.studentsct.model.Subpart;
import org.cpsolver.studentsct.model.Unavailability;
import org.cpsolver.studentsct.reservation.CourseReservation;
import org.cpsolver.studentsct.reservation.CourseRestriction;
import org.cpsolver.studentsct.reservation.CurriculumOverride;
import org.cpsolver.studentsct.reservation.CurriculumReservation;
import org.cpsolver.studentsct.reservation.CurriculumRestriction;
import org.cpsolver.studentsct.reservation.DummyReservation;
import org.cpsolver.studentsct.reservation.GroupReservation;
import org.cpsolver.studentsct.reservation.IndividualReservation;
import org.cpsolver.studentsct.reservation.IndividualRestriction;
import org.cpsolver.studentsct.reservation.LearningCommunityReservation;
import org.cpsolver.studentsct.reservation.Reservation;
import org.cpsolver.studentsct.reservation.ReservationOverride;
import org.cpsolver.studentsct.reservation.Restriction;
import org.cpsolver.studentsct.reservation.UniversalOverride;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class StudentSectioningXMLLoader
extends StudentSectioningLoader {
    private static Logger sLogger = LogManager.getLogger(StudentSectioningXMLLoader.class);
    private File iInputFile = new File(((StudentSectioningModel)this.getModel()).getProperties().getProperty("General.Input", "." + File.separator + "solution.xml"));
    private File iTimetableFile = null;
    private boolean iLoadBest = false;
    private boolean iLoadInitial = false;
    private boolean iLoadCurrent = false;
    private boolean iLoadOfferings = true;
    private boolean iLoadStudents = true;
    private StudentFilter iStudentFilter = null;
    private boolean iWaitlistCritical = false;
    private boolean iMoveCriticalUp = false;

    public StudentSectioningXMLLoader(StudentSectioningModel model, Assignment<Request, Enrollment> assignment) {
        super(model, assignment);
        if (((StudentSectioningModel)this.getModel()).getProperties().getProperty("General.InputTimetable") != null) {
            this.iTimetableFile = new File(((StudentSectioningModel)this.getModel()).getProperties().getProperty("General.InputTimetable"));
        }
        this.iLoadBest = ((StudentSectioningModel)this.getModel()).getProperties().getPropertyBoolean("Xml.LoadBest", true);
        this.iLoadInitial = ((StudentSectioningModel)this.getModel()).getProperties().getPropertyBoolean("Xml.LoadInitial", true);
        this.iLoadCurrent = ((StudentSectioningModel)this.getModel()).getProperties().getPropertyBoolean("Xml.LoadCurrent", true);
        this.iLoadOfferings = ((StudentSectioningModel)this.getModel()).getProperties().getPropertyBoolean("Xml.LoadOfferings", true);
        this.iLoadStudents = ((StudentSectioningModel)this.getModel()).getProperties().getPropertyBoolean("Xml.LoadStudents", true);
        this.iWaitlistCritical = ((StudentSectioningModel)this.getModel()).getProperties().getPropertyBoolean("Xml.WaitlistCritical", false);
        this.iMoveCriticalUp = ((StudentSectioningModel)this.getModel()).getProperties().getPropertyBoolean("Xml.MoveCriticalUp", false);
        if (((StudentSectioningModel)this.getModel()).getProperties().getProperty("Xml.StudentFilter") != null) {
            try {
                this.iStudentFilter = (StudentFilter)Class.forName(((StudentSectioningModel)this.getModel()).getProperties().getProperty("Xml.StudentFilter")).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                sLogger.error("Unable to create student filter, reason: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public void setInputFile(File inputFile) {
        this.iInputFile = inputFile;
    }

    public void setStudentFilter(StudentFilter filter) {
        this.iStudentFilter = filter;
    }

    public void setLoadStudents(boolean loadStudents) {
        this.iLoadStudents = loadStudents;
    }

    public void setLoadOfferings(boolean loadOfferings) {
        this.iLoadOfferings = loadOfferings;
    }

    private static BitSet createBitSet(String bitString) {
        BitSet ret = new BitSet(bitString.length());
        for (int i = 0; i < bitString.length(); ++i) {
            if (bitString.charAt(i) != '1') continue;
            ret.set(i);
        }
        return ret;
    }

    @Override
    public void load() throws Exception {
        sLogger.debug("Reading XML data from " + this.iInputFile);
        Document document = new SAXReader().read(this.iInputFile);
        Element root = document.getRootElement();
        this.load(root);
    }

    public void load(Document document) {
        Element root = document.getRootElement();
        if (this.getModel() != null && root.element("travel-times") != null) {
            this.loadTravelTimes(root.element("travel-times"), ((StudentSectioningModel)this.getModel()).getDistanceMetric());
        }
        Progress.getInstance(this.getModel()).load(root, true);
        Progress.getInstance(this.getModel()).message(4, "Restoring from backup ...");
        HashMap<Long, Offering> offeringTable = new HashMap<Long, Offering>();
        HashMap<Long, Course> courseTable = new HashMap<Long, Course>();
        if (root.element("offerings") != null) {
            this.loadOfferings(root.element("offerings"), offeringTable, courseTable, null);
        }
        ArrayList<Enrollment> bestEnrollments = new ArrayList<Enrollment>();
        ArrayList<Enrollment> currentEnrollments = new ArrayList<Enrollment>();
        if (root.element("students") != null) {
            this.loadStudents(root.element("students"), offeringTable, courseTable, bestEnrollments, currentEnrollments);
        }
        if (root.element("constraints") != null) {
            this.loadLinkedSections(root.element("constraints"), offeringTable);
        }
        if (!bestEnrollments.isEmpty()) {
            this.assignBest(bestEnrollments);
        }
        if (!currentEnrollments.isEmpty()) {
            this.assignCurrent(currentEnrollments);
        }
        if (this.iMoveCriticalUp) {
            this.moveCriticalRequestsUp();
        }
        boolean hasFixed = false;
        for (Request r : ((StudentSectioningModel)this.getModel()).variables()) {
            if (!(r instanceof CourseRequest) || !((CourseRequest)r).isFixed()) continue;
            hasFixed = true;
            break;
        }
        if (hasFixed) {
            ((StudentSectioningModel)this.getModel()).addGlobalConstraint(new FixedAssignments());
        }
    }

    protected void load(Element root) throws DocumentException {
        sLogger.debug("Root element: " + root.getName());
        if (!"sectioning".equals(root.getName())) {
            sLogger.error("Given XML file is not student sectioning problem.");
            return;
        }
        if (this.iLoadOfferings && ((StudentSectioningModel)this.getModel()).getDistanceConflict() != null && root.element("travel-times") != null) {
            this.loadTravelTimes(root.element("travel-times"), ((StudentSectioningModel)this.getModel()).getDistanceConflict().getDistanceMetric());
        }
        Map<Long, Placement> timetable = null;
        if (this.iTimetableFile != null) {
            sLogger.info("Reading timetable from " + this.iTimetableFile + " ...");
            Document timetableDocument = new SAXReader().read(this.iTimetableFile);
            Element timetableRoot = timetableDocument.getRootElement();
            if (!"timetable".equals(timetableRoot.getName())) {
                sLogger.error("Given XML file is not course timetabling problem.");
                return;
            }
            timetable = this.loadTimetable(timetableRoot);
        }
        Progress.getInstance(this.getModel()).load(root, true);
        Progress.getInstance(this.getModel()).message(4, "Restoring from backup ...");
        if (root.attributeValue("term") != null) {
            ((StudentSectioningModel)this.getModel()).getProperties().setProperty("Data.Term", root.attributeValue("term"));
        }
        if (root.attributeValue("year") != null) {
            ((StudentSectioningModel)this.getModel()).getProperties().setProperty("Data.Year", root.attributeValue("year"));
        }
        if (root.attributeValue("initiative") != null) {
            ((StudentSectioningModel)this.getModel()).getProperties().setProperty("Data.Initiative", root.attributeValue("initiative"));
        }
        HashMap<Long, Offering> offeringTable = new HashMap<Long, Offering>();
        HashMap<Long, Course> courseTable = new HashMap<Long, Course>();
        if (this.iLoadOfferings && root.element("offerings") != null) {
            this.loadOfferings(root.element("offerings"), offeringTable, courseTable, timetable);
        } else {
            for (Offering offering : ((StudentSectioningModel)this.getModel()).getOfferings()) {
                offeringTable.put(offering.getId(), offering);
                for (Course course : offering.getCourses()) {
                    courseTable.put(course.getId(), course);
                }
            }
        }
        ArrayList<Enrollment> bestEnrollments = new ArrayList<Enrollment>();
        ArrayList<Enrollment> currentEnrollments = new ArrayList<Enrollment>();
        if (this.iLoadStudents && root.element("students") != null) {
            this.loadStudents(root.element("students"), offeringTable, courseTable, bestEnrollments, currentEnrollments);
        }
        if (this.iLoadOfferings && root.element("constraints") != null) {
            this.loadLinkedSections(root.element("constraints"), offeringTable);
        }
        if (!bestEnrollments.isEmpty()) {
            this.assignBest(bestEnrollments);
        }
        if (!currentEnrollments.isEmpty()) {
            this.assignCurrent(currentEnrollments);
        }
        if (this.iMoveCriticalUp) {
            this.moveCriticalRequestsUp();
        }
        sLogger.debug("Model successfully loaded.");
    }

    protected void loadOfferings(Element offeringsEl, Map<Long, Offering> offeringTable, Map<Long, Course> courseTable, Map<Long, Placement> timetable) {
        Element courseEl;
        Iterator j;
        HashMap<Long, Config> configTable = new HashMap<Long, Config>();
        HashMap<Long, Subpart> subpartTable = new HashMap<Long, Subpart>();
        HashMap<Long, Section> sectionTable = new HashMap<Long, Section>();
        Iterator i = offeringsEl.elementIterator("offering");
        while (i.hasNext()) {
            Element offeringEl = (Element)i.next();
            Offering offering = new Offering(Long.parseLong(offeringEl.attributeValue("id")), offeringEl.attributeValue("name", "O" + offeringEl.attributeValue("id")));
            offering.setDummy("true".equals(offeringEl.attributeValue("dummy", "false")));
            offeringTable.put(offering.getId(), offering);
            ((StudentSectioningModel)this.getModel()).addOffering(offering);
            j = offeringEl.elementIterator("course");
            while (j.hasNext()) {
                courseEl = (Element)j.next();
                Course course = this.loadCourse(courseEl, offering);
                courseTable.put(course.getId(), course);
            }
            j = offeringEl.elementIterator("config");
            while (j.hasNext()) {
                Element configEl = (Element)j.next();
                Config config = this.loadConfig(configEl, offering, subpartTable, sectionTable, timetable);
                configTable.put(config.getId(), config);
            }
            j = offeringEl.elementIterator("reservation");
            while (j.hasNext()) {
                Element reservationEl = (Element)j.next();
                this.loadReservation(reservationEl, offering, configTable, sectionTable);
            }
            j = offeringEl.elementIterator("restriction");
            while (j.hasNext()) {
                Element restrictionEl = (Element)j.next();
                this.loadRestriction(restrictionEl, offering, configTable, sectionTable);
            }
        }
        boolean hasParent = false;
        Iterator i2 = offeringsEl.elementIterator("offering");
        while (i2.hasNext()) {
            Element offeringEl = (Element)i2.next();
            j = offeringEl.elementIterator("course");
            while (j.hasNext()) {
                courseEl = (Element)j.next();
                if (courseEl.attributeValue("parent") == null) continue;
                Course parent = courseTable.get(Long.valueOf(courseEl.attributeValue("parent")));
                Course course = courseTable.get(Long.valueOf(courseEl.attributeValue("id")));
                course.setParent(parent);
                hasParent = true;
            }
        }
        if (hasParent && ((StudentSectioningModel)this.getModel()).getProperties().getPropertyBoolean("Sectioning.DependentCourses", true)) {
            ((StudentSectioningModel)this.getModel()).addGlobalConstraint(new DependentCourses());
        }
    }

    protected Course loadCourse(Element courseEl, Offering offering) {
        Course course = new Course(Long.parseLong(courseEl.attributeValue("id")), courseEl.attributeValue("subjectArea", ""), courseEl.attributeValue("courseNbr", "C" + courseEl.attributeValue("id")), offering, Integer.parseInt(courseEl.attributeValue("limit", "-1")), Integer.parseInt(courseEl.attributeValue("projected", "0")));
        course.setCredit(courseEl.attributeValue("credit"));
        String credits = courseEl.attributeValue("credits");
        if (credits != null) {
            course.setCreditValue(Float.valueOf(credits));
        }
        course.setNote(courseEl.attributeValue("note"));
        course.setType(courseEl.attributeValue("type"));
        course.setTitle(courseEl.attributeValue("title"));
        return course;
    }

    protected Config loadConfig(Element configEl, Offering offering, Map<Long, Subpart> subpartTable, Map<Long, Section> sectionTable, Map<Long, Placement> timetable) {
        Config config = new Config(Long.parseLong(configEl.attributeValue("id")), Integer.parseInt(configEl.attributeValue("limit", "-1")), configEl.attributeValue("name", "G" + configEl.attributeValue("id")), offering);
        Element imEl = configEl.element("instructional-method");
        if (imEl != null) {
            config.setInstructionalMethodId(Long.parseLong(imEl.attributeValue("id")));
            config.setInstructionalMethodName(imEl.attributeValue("name", "M" + imEl.attributeValue("id")));
            config.setInstructionalMethodReference(imEl.attributeValue("reference", config.getInstructionalMethodName()));
        }
        Iterator k = configEl.elementIterator("subpart");
        while (k.hasNext()) {
            Element subpartEl = (Element)k.next();
            Subpart subpart = this.loadSubpart(subpartEl, config, subpartTable, sectionTable, timetable);
            subpartTable.put(subpart.getId(), subpart);
        }
        return config;
    }

    protected Subpart loadSubpart(Element subpartEl, Config config, Map<Long, Subpart> subpartTable, Map<Long, Section> sectionTable, Map<Long, Placement> timetable) {
        Subpart parentSubpart = null;
        if (subpartEl.attributeValue("parent") != null) {
            parentSubpart = subpartTable.get(Long.valueOf(subpartEl.attributeValue("parent")));
        }
        Subpart subpart = new Subpart(Long.parseLong(subpartEl.attributeValue("id")), subpartEl.attributeValue("itype"), subpartEl.attributeValue("name", "P" + subpartEl.attributeValue("id")), config, parentSubpart);
        subpart.setAllowOverlap("true".equals(subpartEl.attributeValue("allowOverlap", "false")));
        subpart.setCredit(subpartEl.attributeValue("credit"));
        String credits = subpartEl.attributeValue("credits");
        if (credits != null) {
            subpart.setCreditValue(Float.valueOf(credits));
        }
        Iterator l = subpartEl.elementIterator("section");
        while (l.hasNext()) {
            Element sectionEl = (Element)l.next();
            Section section = this.loadSection(sectionEl, subpart, sectionTable, timetable);
            sectionTable.put(section.getId(), section);
        }
        return subpart;
    }

    protected Section loadSection(Element sectionEl, Subpart subpart, Map<Long, Section> sectionTable, Map<Long, Placement> timetable) {
        Iterator m;
        Section parentSection = null;
        if (sectionEl.attributeValue("parent") != null) {
            parentSection = sectionTable.get(Long.valueOf(sectionEl.attributeValue("parent")));
        }
        Placement placement = null;
        if (timetable != null) {
            placement = timetable.get(Long.parseLong(sectionEl.attributeValue("id")));
        } else {
            TimeLocation time = null;
            Element timeEl = sectionEl.element("time");
            if (timeEl != null) {
                time = new TimeLocation(Integer.parseInt(timeEl.attributeValue("days"), 2), Integer.parseInt(timeEl.attributeValue("start")), Integer.parseInt(timeEl.attributeValue("length")), 0, 0.0, timeEl.attributeValue("datePattern") == null ? null : Long.valueOf(timeEl.attributeValue("datePattern")), timeEl.attributeValue("datePatternName", ""), StudentSectioningXMLLoader.createBitSet(timeEl.attributeValue("dates")), Integer.parseInt(timeEl.attributeValue("breakTime", "0")));
                if (timeEl.attributeValue("pattern") != null) {
                    time.setTimePatternId(Long.valueOf(timeEl.attributeValue("pattern")));
                }
            }
            ArrayList<RoomLocation> rooms = new ArrayList<RoomLocation>();
            m = sectionEl.elementIterator("room");
            while (m.hasNext()) {
                Element roomEl = (Element)m.next();
                Double posX = null;
                Double posY = null;
                if (roomEl.attributeValue("location") != null) {
                    String loc = roomEl.attributeValue("location");
                    posX = Double.valueOf(loc.substring(0, loc.indexOf(44)));
                    posY = Double.valueOf(loc.substring(loc.indexOf(44) + 1));
                }
                RoomLocation room = new RoomLocation(Long.valueOf(roomEl.attributeValue("id")), roomEl.attributeValue("name", "R" + roomEl.attributeValue("id")), roomEl.attributeValue("building") == null ? null : Long.valueOf(roomEl.attributeValue("building")), 0, Integer.parseInt(roomEl.attributeValue("capacity")), posX, posY, "true".equals(roomEl.attributeValue("ignoreTooFar")), null);
                rooms.add(room);
            }
            placement = time == null ? null : new Placement(null, time, rooms);
        }
        ArrayList<Instructor> instructors = new ArrayList<Instructor>();
        Iterator m2 = sectionEl.elementIterator("instructor");
        while (m2.hasNext()) {
            Element instructorEl = (Element)m2.next();
            instructors.add(new Instructor(Long.parseLong(instructorEl.attributeValue("id")), instructorEl.attributeValue("externalId"), instructorEl.attributeValue("name"), instructorEl.attributeValue("email")));
        }
        if (instructors.isEmpty() && sectionEl.attributeValue("instructorIds") != null) {
            instructors = Instructor.toInstructors(sectionEl.attributeValue("instructorIds"), sectionEl.attributeValue("instructorNames"));
        }
        Section section = new Section(Long.parseLong(sectionEl.attributeValue("id")), Integer.parseInt(sectionEl.attributeValue("limit")), sectionEl.attributeValue("name", "S" + sectionEl.attributeValue("id")), subpart, placement, instructors, parentSection);
        section.setSpaceHeld(Double.parseDouble(sectionEl.attributeValue("hold", "0.0")));
        section.setSpaceExpected(Double.parseDouble(sectionEl.attributeValue("expect", "0.0")));
        section.setCancelled("true".equalsIgnoreCase(sectionEl.attributeValue("cancelled", "false")));
        section.setEnabled("true".equalsIgnoreCase(sectionEl.attributeValue("enabled", "true")));
        section.setOnline("true".equalsIgnoreCase(sectionEl.attributeValue("online", "false")));
        section.setPast("true".equalsIgnoreCase(sectionEl.attributeValue("past", "false")));
        Iterator m3 = sectionEl.elementIterator("cname");
        while (m3.hasNext()) {
            Element cNameEl = (Element)m3.next();
            section.setName(Long.parseLong(cNameEl.attributeValue("id")), cNameEl.getText());
        }
        Element ignoreEl = sectionEl.element("no-conflicts");
        if (ignoreEl != null) {
            m = ignoreEl.elementIterator("section");
            while (m.hasNext()) {
                section.addIgnoreConflictWith(Long.parseLong(((Element)m.next()).attributeValue("id")));
            }
        }
        return section;
    }

    protected Reservation loadReservation(Element reservationEl, Offering offering, HashMap<Long, Config> configTable, HashMap<Long, Section> sectionTable) {
        Element studentEl;
        Reservation r = null;
        if ("individual".equals(reservationEl.attributeValue("type"))) {
            HashSet<Long> studentIds = new HashSet<Long>();
            Iterator k = reservationEl.elementIterator("student");
            while (k.hasNext()) {
                studentEl = (Element)k.next();
                studentIds.add(Long.parseLong(studentEl.attributeValue("id")));
            }
            r = new IndividualReservation((long)Long.valueOf(reservationEl.attributeValue("id")), offering, studentIds);
        } else if ("group".equals(reservationEl.attributeValue("type"))) {
            HashSet<Long> studentIds = new HashSet<Long>();
            Iterator k = reservationEl.elementIterator("student");
            while (k.hasNext()) {
                studentEl = (Element)k.next();
                studentIds.add(Long.parseLong(studentEl.attributeValue("id")));
            }
            r = new GroupReservation((long)Long.valueOf(reservationEl.attributeValue("id")), Double.parseDouble(reservationEl.attributeValue("limit", "-1")), offering, studentIds);
        } else if ("lc".equals(reservationEl.attributeValue("type"))) {
            HashSet<Long> studentIds = new HashSet<Long>();
            Iterator k = reservationEl.elementIterator("student");
            while (k.hasNext()) {
                studentEl = (Element)k.next();
                studentIds.add(Long.parseLong(studentEl.attributeValue("id")));
            }
            long courseId = Long.parseLong(reservationEl.attributeValue("course"));
            for (Course course : offering.getCourses()) {
                if (course.getId() != courseId) continue;
                r = new LearningCommunityReservation((long)Long.valueOf(reservationEl.attributeValue("id")), Double.parseDouble(reservationEl.attributeValue("limit", "-1")), course, studentIds);
            }
        } else if ("curriculum".equals(reservationEl.attributeValue("type")) || "curriculum-override".equals(reservationEl.attributeValue("type"))) {
            ArrayList<String> acadAreas = new ArrayList<String>();
            Iterator k = reservationEl.elementIterator("area");
            while (k.hasNext()) {
                Element areaEl = (Element)k.next();
                acadAreas.add(areaEl.attributeValue("code"));
            }
            if (acadAreas.isEmpty() && reservationEl.attributeValue("area") != null) {
                acadAreas.add(reservationEl.attributeValue("area"));
            }
            ArrayList<String> classifications = new ArrayList<String>();
            Iterator k2 = reservationEl.elementIterator("classification");
            while (k2.hasNext()) {
                Element clasfEl = (Element)k2.next();
                classifications.add(clasfEl.attributeValue("code"));
            }
            ArrayList majors = new ArrayList();
            Iterator k3 = reservationEl.elementIterator("major");
            while (k3.hasNext()) {
                Element majorEl = (Element)k3.next();
                majors.add(majorEl.attributeValue("code"));
            }
            ArrayList<String> minors = new ArrayList<String>();
            Iterator k4 = reservationEl.elementIterator("minor");
            while (k4.hasNext()) {
                Element minorEl = (Element)k4.next();
                minors.add(minorEl.attributeValue("code"));
            }
            r = "curriculum".equals(reservationEl.attributeValue("type")) ? new CurriculumReservation(Long.valueOf(reservationEl.attributeValue("id")), Double.parseDouble(reservationEl.attributeValue("limit", "-1")), offering, acadAreas, classifications, majors, minors) : new CurriculumOverride(Long.valueOf(reservationEl.attributeValue("id")), Double.parseDouble(reservationEl.attributeValue("limit", "-1")), offering, acadAreas, classifications, majors, minors);
            k4 = reservationEl.elementIterator("major");
            while (k4.hasNext()) {
                Element majorEl = (Element)k4.next();
                Iterator l = majorEl.elementIterator("concentration");
                while (l.hasNext()) {
                    Element concentrationEl = (Element)l.next();
                    ((CurriculumReservation)r).addConcentration(majorEl.attributeValue("code"), concentrationEl.attributeValue("code"));
                }
            }
        } else if ("course".equals(reservationEl.attributeValue("type"))) {
            long courseId = Long.parseLong(reservationEl.attributeValue("course"));
            for (Course course : offering.getCourses()) {
                if (course.getId() != courseId) continue;
                r = new CourseReservation(Long.valueOf(reservationEl.attributeValue("id")), course);
            }
        } else if ("dummy".equals(reservationEl.attributeValue("type"))) {
            r = new DummyReservation(offering);
        } else if ("universal".equals(reservationEl.attributeValue("type"))) {
            r = new UniversalOverride(Long.valueOf(reservationEl.attributeValue("id")), "true".equals(reservationEl.attributeValue("override", "false")), Double.parseDouble(reservationEl.attributeValue("limit", "-1")), offering, reservationEl.attributeValue("filter"));
        } else if ("override".equals(reservationEl.attributeValue("type"))) {
            HashSet<Long> studentIds = new HashSet<Long>();
            Iterator k = reservationEl.elementIterator("student");
            while (k.hasNext()) {
                studentEl = (Element)k.next();
                studentIds.add(Long.parseLong(studentEl.attributeValue("id")));
            }
            r = new ReservationOverride((long)Long.valueOf(reservationEl.attributeValue("id")), offering, studentIds);
        }
        if (r == null) {
            sLogger.error("Unknown reservation type " + reservationEl.attributeValue("type"));
            return null;
        }
        r.setExpired("true".equals(reservationEl.attributeValue("expired", "false")));
        Iterator k = reservationEl.elementIterator("config");
        while (k.hasNext()) {
            Element configEl = (Element)k.next();
            r.addConfig(configTable.get(Long.parseLong(configEl.attributeValue("id"))));
        }
        k = reservationEl.elementIterator("section");
        while (k.hasNext()) {
            Element sectionEl = (Element)k.next();
            r.addSection(sectionTable.get(Long.parseLong(sectionEl.attributeValue("id"))), false);
        }
        r.setPriority(Integer.parseInt(reservationEl.attributeValue("priority", String.valueOf(r.getPriority()))));
        r.setMustBeUsed("true".equals(reservationEl.attributeValue("mustBeUsed", r.mustBeUsed() ? "true" : "false")));
        r.setAllowOverlap("true".equals(reservationEl.attributeValue("allowOverlap", r.isAllowOverlap() ? "true" : "false")));
        r.setCanAssignOverLimit("true".equals(reservationEl.attributeValue("canAssignOverLimit", r.canAssignOverLimit() ? "true" : "false")));
        r.setAllowDisabled("true".equals(reservationEl.attributeValue("allowDisabled", r.isAllowDisabled() ? "true" : "false")));
        r.setNeverIncluded("true".equals(reservationEl.attributeValue("neverIncluded", "false")));
        r.setBreakLinkedSections("true".equals(reservationEl.attributeValue("breakLinkedSections", "false")));
        return r;
    }

    protected Restriction loadRestriction(Element restrictionEl, Offering offering, HashMap<Long, Config> configTable, HashMap<Long, Section> sectionTable) {
        Iterator k;
        Restriction r = null;
        if ("individual".equals(restrictionEl.attributeValue("type"))) {
            HashSet<Long> studentIds = new HashSet<Long>();
            k = restrictionEl.elementIterator("student");
            while (k.hasNext()) {
                Element studentEl = (Element)k.next();
                studentIds.add(Long.parseLong(studentEl.attributeValue("id")));
            }
            r = new IndividualRestriction((long)Long.valueOf(restrictionEl.attributeValue("id")), offering, studentIds);
        } else if ("curriculum".equals(restrictionEl.attributeValue("type"))) {
            ArrayList<String> acadAreas = new ArrayList<String>();
            k = restrictionEl.elementIterator("area");
            while (k.hasNext()) {
                Element areaEl = (Element)k.next();
                acadAreas.add(areaEl.attributeValue("code"));
            }
            if (acadAreas.isEmpty() && restrictionEl.attributeValue("area") != null) {
                acadAreas.add(restrictionEl.attributeValue("area"));
            }
            ArrayList<String> classifications = new ArrayList<String>();
            Iterator k2 = restrictionEl.elementIterator("classification");
            while (k2.hasNext()) {
                Element clasfEl = (Element)k2.next();
                classifications.add(clasfEl.attributeValue("code"));
            }
            ArrayList<String> majors = new ArrayList<String>();
            Iterator k3 = restrictionEl.elementIterator("major");
            while (k3.hasNext()) {
                Element majorEl = (Element)k3.next();
                majors.add(majorEl.attributeValue("code"));
            }
            ArrayList<String> minors = new ArrayList<String>();
            Iterator k4 = restrictionEl.elementIterator("minor");
            while (k4.hasNext()) {
                Element minorEl = (Element)k4.next();
                minors.add(minorEl.attributeValue("code"));
            }
            r = new CurriculumRestriction(Long.valueOf(restrictionEl.attributeValue("id")), offering, acadAreas, classifications, majors, minors);
            k4 = restrictionEl.elementIterator("major");
            while (k4.hasNext()) {
                Element majorEl = (Element)k4.next();
                Iterator l = majorEl.elementIterator("concentration");
                while (l.hasNext()) {
                    Element concentrationEl = (Element)l.next();
                    ((CurriculumRestriction)r).addConcentration(majorEl.attributeValue("code"), concentrationEl.attributeValue("code"));
                }
            }
        } else if ("course".equals(restrictionEl.attributeValue("type"))) {
            long courseId = Long.parseLong(restrictionEl.attributeValue("course"));
            for (Course course : offering.getCourses()) {
                if (course.getId() != courseId) continue;
                r = new CourseRestriction((long)Long.valueOf(restrictionEl.attributeValue("id")), course);
            }
        }
        if (r == null) {
            sLogger.error("Unknown reservation type " + restrictionEl.attributeValue("type"));
            return null;
        }
        Iterator k5 = restrictionEl.elementIterator("config");
        while (k5.hasNext()) {
            Element configEl = (Element)k5.next();
            r.addConfig(configTable.get(Long.parseLong(configEl.attributeValue("id"))));
        }
        k5 = restrictionEl.elementIterator("section");
        while (k5.hasNext()) {
            Element sectionEl = (Element)k5.next();
            r.addSection(sectionTable.get(Long.parseLong(sectionEl.attributeValue("id"))));
        }
        return r;
    }

    protected Map<Long, Placement> loadTimetable(Element timetableRoot) {
        Object room;
        HashMap<Long, Placement> timetable = new HashMap<Long, Placement>();
        HashMap<Long, Object> rooms = new HashMap<Long, Object>();
        Iterator i = timetableRoot.element("rooms").elementIterator("room");
        while (i.hasNext()) {
            Element roomEl = (Element)i.next();
            Long roomId = Long.valueOf(roomEl.attributeValue("id"));
            Double posX = null;
            Double posY = null;
            if (roomEl.attributeValue("location") != null) {
                String loc = roomEl.attributeValue("location");
                posX = Double.valueOf(loc.substring(0, loc.indexOf(44)));
                posY = Double.valueOf(loc.substring(loc.indexOf(44) + 1));
            }
            room = new RoomLocation(Long.valueOf(roomEl.attributeValue("id")), roomEl.attributeValue("name", "R" + roomEl.attributeValue("id")), roomEl.attributeValue("building") == null ? null : Long.valueOf(roomEl.attributeValue("building")), 0, Integer.parseInt(roomEl.attributeValue("capacity")), posX, posY, "true".equals(roomEl.attributeValue("ignoreTooFar")), null);
            rooms.put(roomId, room);
        }
        i = timetableRoot.element("classes").elementIterator("class");
        while (i.hasNext()) {
            Element classEl = (Element)i.next();
            Long classId = Long.valueOf(classEl.attributeValue("id"));
            TimeLocation time = null;
            Element timeEl = null;
            Iterator j = classEl.elementIterator("time");
            while (j.hasNext()) {
                Element e = (Element)j.next();
                if (!"true".equals(e.attributeValue("solution", "false"))) continue;
                timeEl = e;
                break;
            }
            if (timeEl != null) {
                time = new TimeLocation(Integer.parseInt(timeEl.attributeValue("days"), 2), Integer.parseInt(timeEl.attributeValue("start")), Integer.parseInt(timeEl.attributeValue("length")), 0, 0.0, classEl.attributeValue("datePattern") == null ? null : Long.valueOf(classEl.attributeValue("datePattern")), classEl.attributeValue("datePatternName", ""), StudentSectioningXMLLoader.createBitSet(classEl.attributeValue("dates")), Integer.parseInt(timeEl.attributeValue("breakTime", "0")));
                if (timeEl.attributeValue("pattern") != null) {
                    time.setTimePatternId(Long.valueOf(timeEl.attributeValue("pattern")));
                }
            }
            room = new ArrayList<RoomLocation>();
            Iterator j2 = classEl.elementIterator("room");
            while (j2.hasNext()) {
                Element roomEl = (Element)j2.next();
                if (!"true".equals(roomEl.attributeValue("solution", "false"))) continue;
                room.add(rooms.get(Long.valueOf(roomEl.attributeValue("id"))));
            }
            Placement placement = time == null ? null : new Placement(null, time, (List<RoomLocation>)room);
            if (placement == null) continue;
            timetable.put(classId, placement);
        }
        return timetable;
    }

    protected void loadTravelTimes(Element travelTimesEl, DistanceMetric metric) {
        Iterator i = travelTimesEl.elementIterator("travel-time");
        while (i.hasNext()) {
            Element travelTimeEl = (Element)i.next();
            metric.addTravelTime(Long.valueOf(travelTimeEl.attributeValue("id1")), Long.valueOf(travelTimeEl.attributeValue("id2")), Integer.valueOf(travelTimeEl.attributeValue("minutes")));
        }
    }

    protected void loadLinkedSections(Element constraintsEl, Map<Long, Offering> offeringTable) {
        Iterator i = constraintsEl.elementIterator("linked-sections");
        while (i.hasNext()) {
            Element linkedEl = (Element)i.next();
            ArrayList<Section> sections = new ArrayList<Section>();
            Iterator j = linkedEl.elementIterator("section");
            while (j.hasNext()) {
                Element sectionEl = (Element)j.next();
                Offering offering = offeringTable.get(Long.valueOf(sectionEl.attributeValue("offering")));
                sections.add(offering.getSection(Long.valueOf(sectionEl.attributeValue("id"))));
            }
            ((StudentSectioningModel)this.getModel()).addLinkedSections("true".equals(linkedEl.attributeValue("mustBeUsed", "false")), sections);
        }
    }

    protected void loadStudents(Element studentsEl, Map<Long, Offering> offeringTable, Map<Long, Course> courseTable, List<Enrollment> bestEnrollments, List<Enrollment> currentEnrollments) {
        Iterator i = studentsEl.elementIterator("student");
        while (i.hasNext()) {
            Element studentEl = (Element)i.next();
            Student student = this.loadStudent(studentEl, offeringTable);
            if (this.iStudentFilter != null && !this.iStudentFilter.accept(student)) continue;
            Iterator j = studentEl.elementIterator();
            while (j.hasNext()) {
                Element fixedEl;
                Enrollment enrollment;
                Enrollment enrollment2;
                Enrollment enrollment3;
                Element requestEl = (Element)j.next();
                Request request = this.loadRequest(requestEl, student, offeringTable, courseTable);
                if (request == null) continue;
                Element initialEl = requestEl.element("initial");
                if (this.iLoadInitial && initialEl != null && (enrollment3 = this.loadEnrollment(initialEl, request)) != null) {
                    request.setInitialAssignment(enrollment3);
                }
                Element currentEl = requestEl.element("current");
                if (this.iLoadCurrent && currentEl != null && (enrollment2 = this.loadEnrollment(currentEl, request)) != null) {
                    currentEnrollments.add(enrollment2);
                }
                Element bestEl = requestEl.element("best");
                if (this.iLoadBest && bestEl != null && (enrollment = this.loadEnrollment(bestEl, request)) != null) {
                    bestEnrollments.add(enrollment);
                }
                if ((fixedEl = requestEl.element("fixed")) == null || !(request instanceof CourseRequest)) continue;
                ((CourseRequest)request).setFixedValue(this.loadEnrollment(fixedEl, request));
            }
            ((StudentSectioningModel)this.getModel()).addStudent(student);
        }
    }

    protected void assignBest(List<Enrollment> bestEnrollments) {
        Map<Constraint<Object, Enrollment>, Set<Enrollment>> conflicts;
        for (Enrollment enrollment : bestEnrollments) {
            if (enrollment.getReservation() == null || enrollment.getReservation().isExpired()) continue;
            if (!enrollment.getStudent().isAvailable(enrollment)) {
                sLogger.warn("[" + enrollment.getStudent().getExternalId() + "] Enrollment " + enrollment + " is conflicting: student not available.");
                continue;
            }
            conflicts = ((StudentSectioningModel)this.getModel()).conflictConstraints(this.getAssignment(), enrollment);
            if (conflicts.isEmpty()) {
                this.getAssignment().assign(0L, enrollment);
                continue;
            }
            sLogger.warn("[" + enrollment.getStudent().getExternalId() + "] Enrollment " + enrollment + " conflicts with " + conflicts);
        }
        for (Enrollment enrollment : bestEnrollments) {
            if (enrollment.getReservation() != null) continue;
            if (!enrollment.getStudent().isAvailable(enrollment)) {
                sLogger.warn("[" + enrollment.getStudent().getExternalId() + "] Enrollment " + enrollment + " is conflicting: student not available.");
                continue;
            }
            conflicts = ((StudentSectioningModel)this.getModel()).conflictConstraints(this.getAssignment(), enrollment);
            if (conflicts.isEmpty()) {
                this.getAssignment().assign(0L, enrollment);
                continue;
            }
            sLogger.warn("[" + enrollment.getStudent().getExternalId() + "] Enrollment " + enrollment + " conflicts with " + conflicts);
        }
        for (Enrollment enrollment : bestEnrollments) {
            if (enrollment.getReservation() == null || !enrollment.getReservation().isExpired()) continue;
            if (!enrollment.getStudent().isAvailable(enrollment)) {
                sLogger.warn("[" + enrollment.getStudent().getExternalId() + "] Enrollment " + enrollment + " is conflicting: student not available.");
                continue;
            }
            conflicts = ((StudentSectioningModel)this.getModel()).conflictConstraints(this.getAssignment(), enrollment);
            if (conflicts.isEmpty()) {
                this.getAssignment().assign(0L, enrollment);
                continue;
            }
            sLogger.warn("[" + enrollment.getStudent().getExternalId() + "] Enrollment " + enrollment + " conflicts with " + conflicts);
        }
        ((StudentSectioningModel)this.getModel()).saveBest(this.getAssignment());
    }

    protected void assignCurrent(List<Enrollment> currentEnrollments) {
        Map<Constraint<Object, Enrollment>, Set<Enrollment>> conflicts;
        for (Request request : ((StudentSectioningModel)this.getModel()).variables()) {
            this.getAssignment().unassign(0L, request);
        }
        for (Enrollment enrollment : currentEnrollments) {
            if (enrollment.getReservation() == null || enrollment.getReservation().isExpired()) continue;
            if (!enrollment.getStudent().isAvailable(enrollment)) {
                sLogger.warn("[" + enrollment.getStudent().getExternalId() + "] Enrollment " + enrollment + " is conflicting: student not available.");
                continue;
            }
            conflicts = ((StudentSectioningModel)this.getModel()).conflictConstraints(this.getAssignment(), enrollment);
            if (conflicts.isEmpty()) {
                this.getAssignment().assign(0L, enrollment);
                continue;
            }
            sLogger.warn("[" + enrollment.getStudent().getExternalId() + "] Enrollment " + enrollment + " conflicts with " + conflicts);
        }
        for (Enrollment enrollment : currentEnrollments) {
            if (enrollment.getReservation() != null) continue;
            if (!enrollment.getStudent().isAvailable(enrollment)) {
                sLogger.warn("[" + enrollment.getStudent().getExternalId() + "] Enrollment " + enrollment + " is conflicting: student not available.");
                continue;
            }
            conflicts = ((StudentSectioningModel)this.getModel()).conflictConstraints(this.getAssignment(), enrollment);
            if (conflicts.isEmpty()) {
                this.getAssignment().assign(0L, enrollment);
                continue;
            }
            sLogger.warn("[" + enrollment.getStudent().getExternalId() + "] Enrollment " + enrollment + " conflicts with " + conflicts);
        }
        for (Enrollment enrollment : currentEnrollments) {
            if (enrollment.getReservation() == null || !enrollment.getReservation().isExpired()) continue;
            if (!enrollment.getStudent().isAvailable(enrollment)) {
                sLogger.warn("[" + enrollment.getStudent().getExternalId() + "] Enrollment " + enrollment + " is conflicting: student not available.");
                continue;
            }
            conflicts = ((StudentSectioningModel)this.getModel()).conflictConstraints(this.getAssignment(), enrollment);
            if (conflicts.isEmpty()) {
                this.getAssignment().assign(0L, enrollment);
                continue;
            }
            sLogger.warn("[" + enrollment.getStudent().getExternalId() + "] Enrollment " + enrollment + " conflicts with " + conflicts);
        }
    }

    protected Student loadStudent(Element studentEl, Map<Long, Offering> offeringTable) {
        String btb;
        String modality;
        String classLastDate;
        String classFirstDate;
        String maxCredit;
        Student student = new Student(Long.parseLong(studentEl.attributeValue("id")), "true".equals(studentEl.attributeValue("dummy")));
        if (studentEl.attributeValue("priority") != null) {
            student.setPriority(Student.StudentPriority.getPriority(studentEl.attributeValue("priority")));
        }
        if ("true".equals(studentEl.attributeValue("shortDistances"))) {
            student.setNeedShortDistances(true);
        }
        if ("true".equals(studentEl.attributeValue("allowDisabled"))) {
            student.setAllowDisabled(true);
        }
        student.setExternalId(studentEl.attributeValue("externalId"));
        student.setName(studentEl.attributeValue("name"));
        student.setStatus(studentEl.attributeValue("status"));
        String minCredit = studentEl.attributeValue("minCredit");
        if (minCredit != null) {
            student.setMinCredit(Float.valueOf(Float.parseFloat(minCredit)));
        }
        if ((maxCredit = studentEl.attributeValue("maxCredit")) != null) {
            student.setMaxCredit(Float.valueOf(Float.parseFloat(maxCredit)));
        }
        if ((classFirstDate = studentEl.attributeValue("classFirstDate")) != null) {
            student.setClassFirstDate(Integer.parseInt(classFirstDate));
        }
        if ((classLastDate = studentEl.attributeValue("classLastDate")) != null) {
            student.setClassLastDate(Integer.parseInt(classLastDate));
        }
        if ((modality = studentEl.attributeValue("modality")) != null) {
            student.setModalityPreference(Student.ModalityPreference.valueOf(modality));
        }
        if ((btb = studentEl.attributeValue("btb")) != null) {
            student.setBackToBackPreference(Student.BackToBackPreference.valueOf(btb));
        }
        ArrayList<String[]> clasf = new ArrayList<String[]>();
        ArrayList<String[]> major = new ArrayList<String[]>();
        Iterator j = studentEl.elementIterator();
        while (j.hasNext()) {
            Element requestEl = (Element)j.next();
            if ("classification".equals(requestEl.getName())) {
                clasf.add(new String[]{requestEl.attributeValue("area"), requestEl.attributeValue("code"), requestEl.attributeValue("label")});
                continue;
            }
            if ("major".equals(requestEl.getName())) {
                major.add(new String[]{requestEl.attributeValue("area"), requestEl.attributeValue("code"), requestEl.attributeValue("label")});
                continue;
            }
            if ("minor".equals(requestEl.getName())) {
                if ("A".equals(requestEl.attributeValue("area"))) {
                    student.getAccommodations().add(requestEl.attributeValue("code"));
                    continue;
                }
                student.getGroups().add(new StudentGroup(requestEl.attributeValue("area"), requestEl.attributeValue("code"), requestEl.attributeValue("label")));
                continue;
            }
            if ("unavailability".equals(requestEl.getName())) {
                Offering offering = offeringTable.get(Long.parseLong(requestEl.attributeValue("offering")));
                Section section = offering == null ? null : offering.getSection(Long.parseLong(requestEl.attributeValue("section")));
                if (section == null) continue;
                Unavailability ua = new Unavailability(student, section, "true".equals(requestEl.attributeValue("allowOverlap")));
                ua.setTeachingAssignment("true".equals(requestEl.attributeValue("ta", "false")));
                if (requestEl.attributeValue("course") == null) continue;
                ua.setCourseId(Long.valueOf(requestEl.attributeValue("course")));
                continue;
            }
            if ("acm".equals(requestEl.getName())) {
                if (requestEl.attributeValue("minor") != null) {
                    student.getAreaClassificationMinors().add(new AreaClassificationMajor(requestEl.attributeValue("area"), requestEl.attributeValue("areaName"), requestEl.attributeValue("classification"), requestEl.attributeValue("classificationName"), requestEl.attributeValue("minor"), requestEl.attributeValue("minorName"), requestEl.attributeValue("concentration"), requestEl.attributeValue("concentrationName"), requestEl.attributeValue("degree"), requestEl.attributeValue("degreeName"), requestEl.attributeValue("program"), requestEl.attributeValue("programName"), requestEl.attributeValue("campus"), requestEl.attributeValue("campusName"), requestEl.attributeValue("weight") == null ? null : Double.valueOf(requestEl.attributeValue("weight"))));
                    continue;
                }
                student.getAreaClassificationMajors().add(new AreaClassificationMajor(requestEl.attributeValue("area"), requestEl.attributeValue("areaName"), requestEl.attributeValue("classification"), requestEl.attributeValue("classificationName"), requestEl.attributeValue("major"), requestEl.attributeValue("majorName"), requestEl.attributeValue("concentration"), requestEl.attributeValue("concentrationName"), requestEl.attributeValue("degree"), requestEl.attributeValue("degreeName"), requestEl.attributeValue("program"), requestEl.attributeValue("programName"), requestEl.attributeValue("campus"), requestEl.attributeValue("campusName"), requestEl.attributeValue("weight") == null ? null : Double.valueOf(requestEl.attributeValue("weight"))));
                continue;
            }
            if ("group".equals(requestEl.getName())) {
                student.getGroups().add(new StudentGroup(requestEl.attributeValue("type"), requestEl.attributeValue("reference"), requestEl.attributeValue("name")));
                continue;
            }
            if ("accommodation".equals(requestEl.getName())) {
                student.getAccommodations().add(requestEl.attributeValue("reference"));
                continue;
            }
            if (!"advisor".equals(requestEl.getName())) continue;
            student.getAdvisors().add(new Instructor(0L, requestEl.attributeValue("externalId"), requestEl.attributeValue("name"), requestEl.attributeValue("email")));
        }
        for (int i = 0; i < Math.min(clasf.size(), major.size()); ++i) {
            student.getAreaClassificationMajors().add(new AreaClassificationMajor(((String[])clasf.get(i))[0], ((String[])clasf.get(i))[1], ((String[])major.get(i))[1]));
        }
        return student;
    }

    protected Request loadRequest(Element requestEl, Student student, Map<Long, Offering> offeringTable, Map<Long, Course> courseTable) {
        if ("freeTime".equals(requestEl.getName())) {
            return this.loadFreeTime(requestEl, student);
        }
        if ("course".equals(requestEl.getName())) {
            return this.loadCourseRequest(requestEl, student, offeringTable, courseTable);
        }
        return null;
    }

    public FreeTimeRequest loadFreeTime(Element requestEl, Student student) {
        TimeLocation time = new TimeLocation(Integer.parseInt(requestEl.attributeValue("days"), 2), Integer.parseInt(requestEl.attributeValue("start")), Integer.parseInt(requestEl.attributeValue("length")), 0, 0.0, requestEl.attributeValue("datePattern") == null ? null : Long.valueOf(requestEl.attributeValue("datePattern")), "", StudentSectioningXMLLoader.createBitSet(requestEl.attributeValue("dates")), 0);
        FreeTimeRequest request = new FreeTimeRequest(Long.parseLong(requestEl.attributeValue("id")), Integer.parseInt(requestEl.attributeValue("priority")), "true".equals(requestEl.attributeValue("alternative")), student, time);
        if (requestEl.attributeValue("weight") != null) {
            request.setWeight(Double.parseDouble(requestEl.attributeValue("weight")));
        }
        return request;
    }

    public CourseRequest loadCourseRequest(Element requestEl, Student student, Map<Long, Offering> offeringTable, Map<Long, Course> courseTable) {
        Element choiceEl;
        ArrayList<Course> courses = new ArrayList<Course>();
        courses.add(courseTable.get(Long.valueOf(requestEl.attributeValue("course"))));
        Iterator k = requestEl.elementIterator("alternative");
        while (k.hasNext()) {
            courses.add(courseTable.get(Long.valueOf(((Element)k.next()).attributeValue("course"))));
        }
        Long timeStamp = null;
        if (requestEl.attributeValue("timeStamp") != null) {
            timeStamp = Long.valueOf(requestEl.attributeValue("timeStamp"));
        }
        CourseRequest courseRequest = new CourseRequest(Long.parseLong(requestEl.attributeValue("id")), Integer.parseInt(requestEl.attributeValue("priority")), "true".equals(requestEl.attributeValue("alternative")), student, courses, "true".equals(requestEl.attributeValue("waitlist", "false")), Request.RequestPriority.valueOf(requestEl.attributeValue("importance", "true".equals(requestEl.attributeValue("critical", "false")) ? Request.RequestPriority.Critical.name() : Request.RequestPriority.Normal.name())), timeStamp);
        if (this.iWaitlistCritical && Request.RequestPriority.Critical.isCritical(courseRequest) && !courseRequest.isAlternative()) {
            courseRequest.setWaitlist(true);
        }
        if (requestEl.attributeValue("weight") != null) {
            courseRequest.setWeight(Double.parseDouble(requestEl.attributeValue("weight")));
        }
        Iterator k2 = requestEl.elementIterator("waitlisted");
        while (k2.hasNext()) {
            choiceEl = (Element)k2.next();
            courseRequest.getWaitlistedChoices().add(new Choice(offeringTable.get(Long.valueOf(choiceEl.attributeValue("offering"))), choiceEl.getText()));
        }
        k2 = requestEl.elementIterator("selected");
        while (k2.hasNext()) {
            choiceEl = (Element)k2.next();
            courseRequest.getSelectedChoices().add(new Choice(offeringTable.get(Long.valueOf(choiceEl.attributeValue("offering"))), choiceEl.getText()));
        }
        k2 = requestEl.elementIterator("required");
        while (k2.hasNext()) {
            choiceEl = (Element)k2.next();
            courseRequest.getRequiredChoices().add(new Choice(offeringTable.get(Long.valueOf(choiceEl.attributeValue("offering"))), choiceEl.getText()));
        }
        k2 = requestEl.elementIterator("group");
        block4: while (k2.hasNext()) {
            Element groupEl = (Element)k2.next();
            long gid = Long.parseLong(groupEl.attributeValue("id"));
            String gname = groupEl.attributeValue("name", "g" + gid);
            Course course = courseTable.get(Long.valueOf(groupEl.attributeValue("course")));
            for (RequestGroup g : course.getRequestGroups()) {
                if (g.getId() != gid) continue;
                courseRequest.addRequestGroup(g);
                continue block4;
            }
            courseRequest.addRequestGroup(new RequestGroup(gid, gname, course));
        }
        return courseRequest;
    }

    protected Enrollment loadEnrollment(Element enrollmentEl, Request request) {
        if (request instanceof CourseRequest) {
            CourseRequest courseRequest = (CourseRequest)request;
            HashSet<Section> sections = new HashSet<Section>();
            Iterator k = enrollmentEl.elementIterator("section");
            while (k.hasNext()) {
                Element sectionEl = (Element)k.next();
                Section section = courseRequest.getSection(Long.parseLong(sectionEl.attributeValue("id")));
                sections.add(section);
            }
            Reservation reservation = null;
            if (enrollmentEl.attributeValue("reservation", null) != null) {
                long reservationId = Long.valueOf(enrollmentEl.attributeValue("reservation"));
                block1: for (Course course : courseRequest.getCourses()) {
                    for (Reservation r : course.getOffering().getReservations()) {
                        if (r.getId() != reservationId) continue;
                        reservation = r;
                        continue block1;
                    }
                }
            }
            if (!sections.isEmpty()) {
                Course course;
                if (enrollmentEl.attributeValue("course") != null && (course = courseRequest.getCourse(Long.valueOf(enrollmentEl.attributeValue("course")))) != null) {
                    return courseRequest.createEnrollment(course, sections, reservation);
                }
                return courseRequest.createEnrollment(sections, reservation);
            }
        } else if (request instanceof FreeTimeRequest) {
            return ((FreeTimeRequest)request).createEnrollment();
        }
        return null;
    }

    protected void moveCriticalRequestsUp() {
        for (Student student : ((StudentSectioningModel)this.getModel()).getStudents()) {
            int assigned = 0;
            int critical = 0;
            for (Request r : student.getRequests()) {
                if (!(r instanceof CourseRequest)) continue;
                if (r.getInitialAssignment() != null) {
                    ++assigned;
                }
                if (r.getRequestPriority() == Request.RequestPriority.Normal) continue;
                ++critical;
            }
            if ((!((StudentSectioningModel)this.getModel()).getKeepInitialAssignments() || assigned <= 0) && critical <= 0) continue;
            Collections.sort(student.getRequests(), new Comparator<Request>(){

                @Override
                public int compare(Request r1, Request r2) {
                    int c2;
                    int c1;
                    if (r1.isAlternative() != r2.isAlternative()) {
                        return r1.isAlternative() ? 1 : -1;
                    }
                    if (((StudentSectioningModel)StudentSectioningXMLLoader.this.getModel()).getKeepInitialAssignments()) {
                        boolean a2;
                        boolean a1 = r1 instanceof CourseRequest && r1.getInitialAssignment() != null;
                        boolean bl = a2 = r2 instanceof CourseRequest && r2.getInitialAssignment() != null;
                        if (a1 != a2) {
                            return a1 ? -1 : 1;
                        }
                    }
                    if ((c1 = r1.getRequestPriority().ordinal()) != (c2 = r2.getRequestPriority().ordinal())) {
                        return c1 < c2 ? -1 : 1;
                    }
                    return r1.getPriority() < r2.getPriority() ? -1 : 1;
                }
            });
            int p = 0;
            for (Request r : student.getRequests()) {
                r.setPriority(p++);
            }
        }
    }
}

