/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.instructor.criteria;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.criteria.AbstractCriterion;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.instructor.criteria.InstructorSchedulingCriterion;
import org.cpsolver.instructor.model.Instructor;
import org.cpsolver.instructor.model.TeachingAssignment;
import org.cpsolver.instructor.model.TeachingRequest;

public class UnusedInstructorLoad
extends InstructorSchedulingCriterion {
    public UnusedInstructorLoad() {
        this.setValueUpdateType(AbstractCriterion.ValueUpdateType.NoUpdate);
    }

    @Override
    public double getWeightDefault(DataProperties config) {
        return 100000.0;
    }

    @Override
    public double getValue(Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, TeachingAssignment value, Set<TeachingAssignment> conflicts) {
        Instructor.Context cx = (Instructor.Context)value.getInstructor().getContext(assignment);
        float load = cx.getLoad();
        if (!cx.getAssignments().contains(value)) {
            load += ((TeachingRequest.Variable)value.variable()).getRequest().getLoad();
        }
        if (conflicts != null) {
            for (TeachingAssignment ta : conflicts) {
                if (!ta.getInstructor().equals(value.getInstructor())) continue;
                load -= ((TeachingRequest.Variable)ta.variable()).getRequest().getLoad();
            }
        }
        return Math.max(0.0f, value.getInstructor().getMaxLoad() - load);
    }

    @Override
    public double getValue(Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, Collection<TeachingRequest.Variable> variables) {
        double unused = 0.0;
        HashSet<Instructor> instructors = new HashSet<Instructor>();
        for (TeachingRequest.Variable req : variables) {
            TeachingAssignment ta = assignment.getValue(req);
            if (ta == null || !instructors.add(ta.getInstructor())) continue;
            unused += (double)(ta.getInstructor().getMaxLoad() - ((Instructor.Context)ta.getInstructor().getContext(assignment)).getLoad());
        }
        return unused;
    }

    @Override
    public String getAbbreviation() {
        return "UnusedLoad";
    }
}

