/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.instructor.criteria;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.criteria.AbstractCriterion;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.instructor.criteria.InstructorSchedulingCriterion;
import org.cpsolver.instructor.model.Instructor;
import org.cpsolver.instructor.model.TeachingAssignment;
import org.cpsolver.instructor.model.TeachingRequest;

public class TimeOverlaps
extends InstructorSchedulingCriterion {
    public TimeOverlaps() {
        this.setValueUpdateType(AbstractCriterion.ValueUpdateType.NoUpdate);
    }

    @Override
    public double getWeightDefault(DataProperties config) {
        return 1000.0;
    }

    @Override
    public double getValue(Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, TeachingAssignment value, Set<TeachingAssignment> conflicts) {
        return value.getInstructor().share(assignment, value);
    }

    @Override
    public double getValue(Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, Collection<TeachingRequest.Variable> variables) {
        double value = 0.0;
        for (Instructor instructor : this.getAssignedInstructors(assignment, variables)) {
            value += (double)((Instructor.Context)instructor.getContext(assignment)).countTimeOverlaps();
        }
        return value;
    }

    @Override
    public String getAbbreviation() {
        return "Overlaps";
    }

    @Override
    public void getInfo(Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, Map<String, String> info) {
        double val = this.getValue(assignment);
        if (val != 0.0) {
            info.put(this.getName(), sDoubleFormat.format(val / 12.0) + " h");
        }
    }

    @Override
    public void getInfo(Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, Map<String, String> info, Collection<TeachingRequest.Variable> variables) {
        double val = this.getValue(assignment, variables);
        if (val != 0.0) {
            info.put(this.getName(), sDoubleFormat.format(val / 12.0) + " h");
        }
    }
}

