/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.instructor.criteria;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.criteria.AbstractCriterion;
import org.cpsolver.ifs.model.Constraint;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.instructor.constraints.SameLinkConstraint;
import org.cpsolver.instructor.criteria.InstructorSchedulingCriterion;
import org.cpsolver.instructor.model.TeachingAssignment;
import org.cpsolver.instructor.model.TeachingRequest;

public class SameLink
extends InstructorSchedulingCriterion {
    public SameLink() {
        this.setValueUpdateType(AbstractCriterion.ValueUpdateType.NoUpdate);
    }

    @Override
    public double getWeightDefault(DataProperties config) {
        return 100.0;
    }

    @Override
    public double getValue(Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, TeachingAssignment value, Set<TeachingAssignment> conflicts) {
        double ret = 0.0;
        for (Constraint c : ((TeachingRequest.Variable)value.variable()).constraints()) {
            if (!(c instanceof SameLinkConstraint)) continue;
            ret += (double)((SameLinkConstraint)c).getCurrentPreference(assignment, value);
        }
        return ret;
    }

    @Override
    public double getValue(Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, Collection<TeachingRequest.Variable> variables) {
        double ret = 0.0;
        HashSet constraints = new HashSet();
        for (TeachingRequest.Variable req : variables) {
            for (Constraint c : req.constraints()) {
                if (!(c instanceof SameLinkConstraint) || !constraints.add(c)) continue;
                ret += (double)((SameLinkConstraint.Context)((SameLinkConstraint)c).getContext((Assignment)assignment)).getPreference();
            }
        }
        return ret;
    }

    @Override
    protected double[] computeBounds(Assignment<TeachingRequest.Variable, TeachingAssignment> assignment) {
        double[] bounds = new double[]{0.0, 0.0};
        for (Constraint c : this.getModel().constraints()) {
            if (!(c instanceof SameLinkConstraint) || c.isHard()) continue;
            bounds[1] = bounds[1] + (double)(Math.abs(((SameLinkConstraint)c).getPreference()) * (c.variables().size() - 1));
        }
        return bounds;
    }

    @Override
    public double[] getBounds(Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, Collection<TeachingRequest.Variable> variables) {
        double[] bounds = new double[]{0.0, 0.0};
        HashSet constraints = new HashSet();
        for (TeachingRequest.Variable req : variables) {
            for (Constraint c : req.constraints()) {
                if (!(c instanceof SameLinkConstraint) || c.isHard() || !constraints.add(c)) continue;
                bounds[1] = bounds[1] + (double)(Math.abs(((SameLinkConstraint)c).getPreference()) * (c.variables().size() - 1));
            }
        }
        return bounds;
    }

    @Override
    public String getAbbreviation() {
        return "SameLink";
    }
}

