/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.perturbations;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.extension.Extension;
import org.cpsolver.ifs.extension.ViolatedInitials;
import org.cpsolver.ifs.model.Model;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.perturbations.PerturbationsCounter;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;

public class DefaultPerturbationsCounter<V extends Variable<V, T>, T extends Value<V, T>>
implements PerturbationsCounter<V, T> {
    private ViolatedInitials<V, T> iViolatedInitials = null;
    protected static DecimalFormat sDoubleFormat = new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.US));

    public DefaultPerturbationsCounter(DataProperties properties) {
    }

    @Override
    public void init(Solver<V, T> solver) {
        for (Extension<V, T> extension : solver.getExtensions()) {
            if (!ViolatedInitials.class.isInstance(extension)) continue;
            this.iViolatedInitials = (ViolatedInitials)extension;
        }
    }

    @Override
    public double getPerturbationPenalty(Assignment<V, T> assignment, Model<V, T> model) {
        double penalty = 0.0;
        for (Variable variable : model.variablesWithInitialValue()) {
            T value = assignment.getValue(variable);
            if (value == null || variable.getInitialAssignment() == null || ((Value)value).equals(variable.getInitialAssignment())) continue;
            penalty += this.getPenaltyD(assignment, value, variable.getInitialAssignment());
        }
        return penalty;
    }

    @Override
    public double getPerturbationPenalty(Assignment<V, T> assignment, Model<V, T> model, Collection<V> variables) {
        double penalty = 0.0;
        for (Variable variable : variables) {
            T value = assignment.getValue(variable);
            if (value == null || variable.getInitialAssignment() == null || ((Value)value).equals(variable.getInitialAssignment())) continue;
            penalty += this.getPenaltyD(assignment, value, variable.getInitialAssignment());
        }
        return penalty;
    }

    protected ViolatedInitials<V, T> getViolatedInitials() {
        return this.iViolatedInitials;
    }

    protected double getPenalty(Assignment<V, T> assignment, T assignedValue, T initialValue) {
        return 1.0;
    }

    protected double getPenaltyA(Assignment<V, T> assignment, T selectedValue, T initialValue) {
        return this.getPenalty(assignment, null, initialValue);
    }

    protected double getPenaltyB(Assignment<V, T> assignment, T selectedValue, T assignedValue, T initialValue) {
        return this.getPenalty(assignment, assignedValue, initialValue);
    }

    protected double getPenaltyC(Assignment<V, T> assignment, T selectedValue, T assignedValue, T initialValue) {
        return -this.getPenalty(assignment, assignedValue, initialValue);
    }

    protected double getPenaltyD(Assignment<V, T> assignment, T selectedValue, T initialValue) {
        return this.getPenalty(assignment, selectedValue, initialValue);
    }

    @Override
    public double getPerturbationPenalty(Assignment<V, T> assignment, Model<V, T> model, T selectedValue, Collection<T> conflicts) {
        Set<T> violations;
        double penalty = 0.0;
        Set<T> set = violations = this.getViolatedInitials() == null ? null : this.getViolatedInitials().getViolatedInitials(selectedValue);
        if (violations != null) {
            for (Value aValue : violations) {
                if (assignment.getValue(aValue.variable()) != null) continue;
                penalty += this.getPenaltyA(assignment, selectedValue, aValue);
            }
        }
        if (conflicts != null) {
            for (Value conflictValue : conflicts) {
                Object initialValue = ((Variable)conflictValue.variable()).getInitialAssignment();
                if (initialValue == null) continue;
                if (((Value)initialValue).equals(conflictValue)) {
                    penalty += this.getPenaltyB(assignment, selectedValue, conflictValue, initialValue);
                    continue;
                }
                if (violations != null && violations.contains(initialValue)) continue;
                penalty += this.getPenaltyC(assignment, selectedValue, conflictValue, initialValue);
            }
        }
        if (((Variable)((Value)selectedValue).variable()).getInitialAssignment() != null && !((Value)selectedValue).equals(((Variable)((Value)selectedValue).variable()).getInitialAssignment())) {
            penalty += this.getPenaltyD(assignment, selectedValue, ((Variable)((Value)selectedValue).variable()).getInitialAssignment());
        }
        return penalty;
    }

    @Override
    public void getInfo(Assignment<V, T> assignment, Model<V, T> model, Map<String, String> info) {
        if (model.variablesWithInitialValue().size() > 0) {
            info.put("Perturbations: Total penalty", sDoubleFormat.format(this.getPerturbationPenalty(assignment, model)));
        }
    }

    @Override
    public void getInfo(Assignment<V, T> assignment, Model<V, T> model, Map<String, String> info, Collection<V> variables) {
        if (model.variablesWithInitialValue().size() > 0) {
            info.put("Perturbations: Total penalty", sDoubleFormat.format(this.getPerturbationPenalty(assignment, model, variables)));
        }
    }
}

