/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.example.rpp;

import java.util.ArrayList;
import org.cpsolver.ifs.example.rpp.Location;
import org.cpsolver.ifs.model.Variable;

public class Rectangle
extends Variable<Rectangle, Location> {
    private String iName;
    private int iMinX;
    private int iMaxX;
    private int iMinY;
    private int iMaxY;
    private int iHeight;
    private int iWidth;
    private int iProhibitedX = -1;
    private int iProhibitedY = -1;

    public Rectangle(String name, int width, int height, int minX, int maxX, int minY, int maxY, Location initialLocation) {
        super(initialLocation);
        this.iName = name;
        this.iWidth = width;
        this.iHeight = height;
        this.iMinX = minX;
        this.iMaxX = maxX;
        this.iMinY = minY;
        this.iMaxY = maxY;
        this.setValues(this.computeValues());
    }

    public void setProhibited(int x, int y) {
        this.iProhibitedX = x;
        this.iProhibitedY = y;
        this.setValues(this.computeValues());
        if (this.getInitialAssignment() != null && !this.values(null).contains(this.getInitialAssignment())) {
            this.setInitialAssignment(null);
        }
    }

    public void setProhibited() {
        if (this.getInitialAssignment() == null) {
            return;
        }
        this.setProhibited(((Location)this.getInitialAssignment()).getX(), ((Location)this.getInitialAssignment()).getY());
    }

    public boolean isProhibited(int x, int y) {
        return this.iProhibitedX == x || this.iProhibitedY == y;
    }

    public int getProhibitedX() {
        return this.iProhibitedX;
    }

    public int getProhibitedY() {
        return this.iProhibitedY;
    }

    public int getMinX() {
        return this.iMinX;
    }

    public int getMaxX() {
        return this.iMaxX;
    }

    public int getMinY() {
        return this.iMinY;
    }

    public int getMaxY() {
        return this.iMaxY;
    }

    public int getWidth() {
        return this.iWidth;
    }

    public int getHeight() {
        return this.iHeight;
    }

    @Override
    public String getName() {
        return this.iName;
    }

    public void setBounds(int minX, int maxX, int minY, int maxY) {
        this.iMinX = minX;
        this.iMaxX = maxX;
        this.iMinY = minY;
        this.iMaxY = maxY;
        if (this.getInitialAssignment() != null && !this.values(null).contains(this.getInitialAssignment())) {
            this.setInitialAssignment(null);
        }
    }

    private ArrayList<Location> computeValues() {
        ArrayList<Location> locations = new ArrayList<Location>((this.iMaxX - this.iMinX) * (this.iMaxY - this.iMinY));
        for (int x = this.iMinX; x <= this.iMaxX; ++x) {
            for (int y = this.iMinY; y <= this.iMaxY; ++y) {
                if (this.isProhibited(x, y)) continue;
                Location val = new Location(this, x, y);
                locations.add(val);
                if (this.getInitialAssignment() != null && ((Location)this.getInitialAssignment()).equals(val)) {
                    this.setInitialAssignment(val);
                }
                if (this.getBestAssignment() == null || !((Location)this.getBestAssignment()).equals(val)) continue;
                this.setBestAssignment(val, 0L);
            }
        }
        return locations;
    }

    @Override
    public String toString() {
        return "Rectangle{name='" + this.getName() + "', size=[" + this.getWidth() + "," + this.getHeight() + "], bounds=[" + this.iMinX + ".." + this.iMaxX + "," + this.iMinY + ".." + this.iMaxY + "], super=" + super.toString() + "}";
    }

    @Override
    public boolean equals(Object o) {
        return ((Rectangle)o).getName().equals(this.getName());
    }
}

