/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.example.jobshop;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cpsolver.ifs.example.jobshop.JobShopModel;
import org.cpsolver.ifs.example.jobshop.Location;
import org.cpsolver.ifs.example.jobshop.Operation;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.Progress;
import org.cpsolver.ifs.util.ProgressWriter;
import org.cpsolver.ifs.util.ToolBox;

public class Test {
    private static SimpleDateFormat sDateFormat = new SimpleDateFormat("dd-MMM-yy_HHmmss", Locale.US);
    private static Logger sLogger = LogManager.getLogger(Test.class);

    public static void test(DataProperties properties) {
        try {
            String inputFile = properties.getProperty("General.Input");
            JobShopModel model = JobShopModel.loadModel(inputFile);
            Solver<Operation, Location> s = new Solver<Operation, Location>(properties);
            s.setInitalSolution(model);
            s.start();
            s.getSolverThread().join();
            Solution best = s.currentSolution();
            best.restoreBest();
            sLogger.info("Best solution info:" + best.getInfo());
            sLogger.info("Best solution:" + model.toString());
            model.save(best.getAssignment(), properties.getProperty("General.Output") + File.separator + "solution.txt");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            Progress.getInstance().addProgressListener(new ProgressWriter(System.out));
            File inputCfg = new File(args[0]);
            DataProperties properties = ToolBox.loadProperties(inputCfg);
            String outDir = properties.getProperty("General.Output", ".") + File.separator + inputCfg.getName().substring(0, inputCfg.getName().lastIndexOf(46)) + File.separator + sDateFormat.format(new Date());
            new File(outDir).mkdirs();
            properties.setProperty("General.Output", outDir.toString());
            ToolBox.configureLogging(outDir, null);
            Test.test(properties);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

