/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.example.jobshop;

import org.cpsolver.ifs.example.jobshop.Operation;
import org.cpsolver.ifs.model.Value;

public class Location
extends Value<Operation, Location> {
    private int iStartTime = -1;

    public Location(Operation op, int startTime) {
        super(op);
        this.iStartTime = startTime;
    }

    public int getStartTime() {
        return this.iStartTime;
    }

    public int getFinishingTime() {
        return this.iStartTime + ((Operation)this.variable()).getProcessingTime() - 1;
    }

    @Override
    public double toDouble() {
        return this.iStartTime;
    }

    @Override
    public String toString() {
        return ((Operation)this.variable()).getName() + "=" + this.iStartTime;
    }

    @Override
    public String getName() {
        return String.valueOf(this.iStartTime);
    }

    public boolean overlap(Location anotherLocation) {
        if (this.getStartTime() + ((Operation)this.variable()).getProcessingTime() <= anotherLocation.getStartTime()) {
            return false;
        }
        return anotherLocation.getStartTime() + ((Operation)anotherLocation.variable()).getProcessingTime() > this.getStartTime();
    }

    public boolean before(Location anotherLocation) {
        return this.getStartTime() + ((Operation)this.variable()).getProcessingTime() <= anotherLocation.getStartTime();
    }

    public boolean after(Location anotherLocation) {
        return anotherLocation.before(this);
    }
}

