/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.example.jobshop;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.StringTokenizer;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.example.jobshop.Job;
import org.cpsolver.ifs.example.jobshop.Location;
import org.cpsolver.ifs.example.jobshop.Machine;
import org.cpsolver.ifs.example.jobshop.Operation;
import org.cpsolver.ifs.model.Model;
import org.cpsolver.ifs.util.ToolBox;

public class JobShopModel
extends Model<Operation, Location> {
    private int iTotalNumberOfSlots = 1250;
    private Machine[] iMachines;
    private Job[] iJobs;

    public JobShopModel(int nrMachines, int nrJobs) {
        this.iMachines = new Machine[nrMachines];
        this.iJobs = new Job[nrJobs];
    }

    public int getTotalNumberOfSlots() {
        return this.iTotalNumberOfSlots;
    }

    public Machine getMachine(int machineNumber) {
        return this.iMachines[machineNumber];
    }

    public int countMachines() {
        return this.iMachines.length;
    }

    public Job getJob(int jobNumber) {
        return this.iJobs[jobNumber];
    }

    public int countJobs() {
        return this.iJobs.length;
    }

    private void setJob(int jobNumber, Job job) {
        this.iJobs[jobNumber] = job;
    }

    private void setMachine(int machineNumber, Machine machine) {
        this.iMachines[machineNumber] = machine;
    }

    public static JobShopModel loadModel(String file) throws IOException {
        int i;
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line = reader.readLine();
        while (line.startsWith("#")) {
            line = reader.readLine();
        }
        StringTokenizer stk = new StringTokenizer(line, " ");
        int nrJobs = Integer.parseInt(stk.nextToken());
        int nrMachines = Integer.parseInt(stk.nextToken());
        JobShopModel model = new JobShopModel(nrMachines, nrJobs);
        Machine[] machine = new Machine[nrMachines];
        for (i = 0; i < nrMachines; ++i) {
            machine[i] = new Machine(i);
            model.addConstraint(machine[i]);
            model.setMachine(i, machine[i]);
        }
        for (i = 0; i < nrJobs; ++i) {
            Job job = new Job(i);
            model.addConstraint(job);
            model.setJob(i, job);
            line = reader.readLine();
            stk = new StringTokenizer(line, " ");
            for (int j = 0; j < nrMachines; ++j) {
                int machineNumber = Integer.parseInt(stk.nextToken());
                int processingTime = Integer.parseInt(stk.nextToken());
                Operation operation = new Operation(job, machine[machineNumber], j, processingTime);
                model.addVariable(operation);
                job.addVariable(operation);
                machine[machineNumber].addVariable(operation);
            }
            if (!stk.hasMoreTokens()) continue;
            job.setDueTime(Integer.parseInt(stk.nextToken()));
        }
        reader.close();
        for (Operation o : model.variables()) {
            o.init();
        }
        return model;
    }

    public int getFinishingTime(Assignment<Operation, Location> assignment) {
        int ret = 0;
        for (Operation op : assignment.assignedVariables()) {
            ret = Math.max(ret, assignment.getValue(op).getFinishingTime());
        }
        return ret;
    }

    @Override
    public Map<String, String> getInfo(Assignment<Operation, Location> assignment) {
        Map<String, String> ret = super.getInfo(assignment);
        ret.put("Finishing time", String.valueOf(this.getFinishingTime(assignment)));
        return ret;
    }

    public void save(Assignment<Operation, Location> assignment, String file) throws IOException {
        PrintWriter writer = new PrintWriter(new FileWriter(file));
        for (int i = 0; i < this.countMachines(); ++i) {
            Machine m = this.getMachine(i);
            ArrayList ops = new ArrayList(m.variables());
            Collections.sort(ops, new OperationComparator(assignment));
            for (Operation var : ops) {
                Operation op = var;
                if (assignment.getValue(op) == null) continue;
                writer.print((op.getJobNumber() < 10 ? " " : "") + op.getJobNumber() + " ");
            }
            writer.println();
        }
        writer.println(";");
        Map<String, String> info = this.getInfo(assignment);
        for (String key : info.keySet()) {
            String value = info.get(key);
            writer.println("; " + key + ": " + value);
        }
        writer.println(";");
        for (int i = 0; i < this.countJobs(); ++i) {
            Job job = this.getJob(i);
            writer.print("; ");
            for (Operation op : job.variables()) {
                Location loc = assignment.getValue(op);
                writer.print((loc == null ? "----" : ToolBox.trim(String.valueOf(loc.getStartTime()), 4)) + " ");
            }
            writer.println();
        }
        writer.flush();
        writer.close();
    }

    private static class OperationComparator
    implements Comparator<Operation> {
        Assignment<Operation, Location> iAssignment;

        public OperationComparator(Assignment<Operation, Location> assignment) {
            this.iAssignment = assignment;
        }

        @Override
        public int compare(Operation op1, Operation op2) {
            Location loc1 = this.iAssignment.getValue(op1);
            Location loc2 = this.iAssignment.getValue(op2);
            if (loc1 == null) {
                if (loc2 == null) {
                    return 0;
                }
                return -1;
            }
            if (loc2 == null) {
                return 1;
            }
            return loc1.getStartTime() < loc2.getStartTime() ? -1 : (loc1.getStartTime() == loc2.getStartTime() ? 0 : 1);
        }
    }
}

