/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.example.csp;

import java.util.Random;
import org.cpsolver.ifs.example.csp.CSPBinaryConstraint;
import org.cpsolver.ifs.example.csp.CSPValue;
import org.cpsolver.ifs.example.csp.CSPVariable;
import org.cpsolver.ifs.model.Model;

public class CSPModel
extends Model<CSPVariable, CSPValue> {
    public CSPModel(int nrVariables, int nrValues, int nrConstraints, int nrCompatiblePairs, long seed) {
        this.generate(nrVariables, nrValues, nrConstraints, nrCompatiblePairs, seed);
    }

    public CSPModel() {
    }

    private void swap(CSPVariable[][] allPairs, int first, int second) {
        CSPVariable[] a = allPairs[first];
        allPairs[first] = allPairs[second];
        allPairs[second] = a;
    }

    private void buildBinaryConstraintGraph(Random rnd) {
        int numberOfAllPairs = this.variables().size() * (this.variables().size() - 1) / 2;
        CSPVariable[][] allPairs = new CSPVariable[numberOfAllPairs][];
        int idx = 0;
        for (CSPVariable cSPVariable : this.variables()) {
            for (CSPVariable v2 : this.variables()) {
                if (cSPVariable.getId() >= v2.getId()) continue;
                allPairs[idx++] = new CSPVariable[]{cSPVariable, v2};
            }
        }
        idx = 0;
        for (CSPBinaryConstraint cSPBinaryConstraint : this.constraints()) {
            this.swap(allPairs, idx, idx + (int)(rnd.nextDouble() * (double)(numberOfAllPairs - idx)));
            cSPBinaryConstraint.addVariable(allPairs[idx][0]);
            cSPBinaryConstraint.addVariable(allPairs[idx][1]);
            cSPBinaryConstraint.init(rnd);
            ++idx;
        }
    }

    private void generate(int nrVariables, int nrValues, int nrConstraints, int nrCompatiblePairs, long seed) {
        int i;
        Random rnd = new Random(seed);
        for (i = 0; i < nrVariables; ++i) {
            CSPVariable var = new CSPVariable(i + 1, nrValues);
            this.addVariable(var);
        }
        for (i = 0; i < nrConstraints; ++i) {
            CSPBinaryConstraint c = new CSPBinaryConstraint(i + 1, nrCompatiblePairs);
            this.addConstraint(c);
        }
        this.buildBinaryConstraintGraph(rnd);
    }
}

