/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.example.csp;

import java.util.Random;
import java.util.Set;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.example.csp.CSPValue;
import org.cpsolver.ifs.example.csp.CSPVariable;
import org.cpsolver.ifs.model.BinaryConstraint;

public class CSPBinaryConstraint
extends BinaryConstraint<CSPVariable, CSPValue> {
    private boolean[][] iIsConsistent = null;
    private int iNrCompatiblePairs;

    public CSPBinaryConstraint(int id, int nrCompatiblePairs) {
        this.iId = id;
        this.iNrCompatiblePairs = nrCompatiblePairs;
    }

    private void swap(int[][] allPairs, int first, int second) {
        int[] a = allPairs[first];
        allPairs[first] = allPairs[second];
        allPairs[second] = a;
    }

    public void init(Random rndNumGen) {
        int numberOfAllPairs = ((CSPVariable)this.first()).values(null).size() * ((CSPVariable)this.second()).values(null).size();
        int[][] allPairs = new int[numberOfAllPairs][];
        int idx = 0;
        this.iIsConsistent = new boolean[((CSPVariable)this.first()).values(null).size()][((CSPVariable)this.second()).values(null).size()];
        for (CSPValue v1 : ((CSPVariable)this.first()).values(null)) {
            for (CSPValue v2 : ((CSPVariable)this.second()).values(null)) {
                this.iIsConsistent[(int)v1.toDouble()][(int)v2.toDouble()] = false;
                allPairs[idx++] = new int[]{(int)v1.toDouble(), (int)v2.toDouble()};
            }
        }
        for (int i = 0; i < this.iNrCompatiblePairs; ++i) {
            this.swap(allPairs, i, i + (int)(rndNumGen.nextDouble() * (double)(numberOfAllPairs - i)));
            this.iIsConsistent[allPairs[i][0]][allPairs[i][1]] = true;
        }
    }

    @Override
    public boolean isConsistent(CSPValue value1, CSPValue value2) {
        if (value1 == null || value2 == null) {
            return true;
        }
        if (this.isFirst(value1.variable())) {
            return this.iIsConsistent[(int)value1.toDouble()][(int)value2.toDouble()];
        }
        return this.iIsConsistent[(int)value2.toDouble()][(int)value1.toDouble()];
    }

    @Override
    public void computeConflicts(Assignment<CSPVariable, CSPValue> assignment, CSPValue aValue, Set<CSPValue> conflicts) {
        if (this.isFirst(aValue.variable())) {
            if (!this.isConsistent(aValue, assignment.getValue((CSPVariable)this.second()))) {
                conflicts.add(assignment.getValue((CSPVariable)this.second()));
            }
        } else if (!this.isConsistent(assignment.getValue((CSPVariable)this.first()), aValue)) {
            conflicts.add(assignment.getValue((CSPVariable)this.first()));
        }
    }

    @Override
    public String getName() {
        return "C" + this.getId();
    }
}

