/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.exam.neighbours;

import java.text.DecimalFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.cpsolver.exam.model.Exam;
import org.cpsolver.exam.model.ExamPlacement;
import org.cpsolver.exam.model.ExamRoomPlacement;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Neighbour;
import org.cpsolver.ifs.model.Value;

public class ExamRoomSwapNeighbour
implements Neighbour<Exam, ExamPlacement> {
    private double iValue = 0.0;
    private ExamPlacement iX1;
    private ExamPlacement iX2 = null;
    private ExamRoomPlacement iR1;
    private ExamRoomPlacement iR2 = null;

    public ExamRoomSwapNeighbour(Assignment<Exam, ExamPlacement> assignment, ExamPlacement placement, ExamRoomPlacement current, ExamRoomPlacement swap) {
        if (placement.getRoomPlacements().contains(swap)) {
            return;
        }
        if (!ExamRoomSwapNeighbour.checkParents(placement.getRoomPlacements(), current, swap)) {
            return;
        }
        Exam exam = (Exam)placement.variable();
        if (!swap.isAvailable(placement.getPeriod())) {
            return;
        }
        if (!exam.checkDistributionConstraints(assignment, swap)) {
            return;
        }
        int size = 0;
        for (ExamRoomPlacement r : placement.getRoomPlacements()) {
            size += r.getSize(exam.hasAltSeating());
        }
        size -= current.getSize(exam.hasAltSeating());
        if ((size += swap.getSize(exam.hasAltSeating())) < exam.getSize()) {
            return;
        }
        Value conflict = null;
        HashSet<ExamPlacement> conf = new HashSet<ExamPlacement>();
        swap.getRoom().computeConflicts(assignment, exam, placement.getPeriod(), conf);
        if (conf.size() > 1) {
            return;
        }
        if (conf.size() == 1) {
            conflict = (ExamPlacement)conf.iterator().next();
        }
        if (conflict == null) {
            HashSet<ExamRoomPlacement> newRooms = new HashSet<ExamRoomPlacement>(placement.getRoomPlacements());
            newRooms.remove(current);
            newRooms.add(swap);
            Iterator i = newRooms.iterator();
            while (i.hasNext()) {
                ExamRoomPlacement r = (ExamRoomPlacement)i.next();
                if (r.equals(swap) || size - r.getSize(exam.hasAltSeating()) < exam.getSize()) continue;
                i.remove();
                size -= r.getSize(exam.hasAltSeating());
            }
            this.iX1 = new ExamPlacement(exam, placement.getPeriodPlacement(), newRooms);
            ExamPlacement p = assignment.getValue(exam);
            this.iValue = this.iX1.toDouble(assignment) - (p == null ? 0.0 : p.toDouble(assignment));
        } else {
            Exam x = (Exam)conflict.variable();
            ExamRoomPlacement xNew = x.getRoomPlacement(current.getRoom());
            if (xNew == null) {
                return;
            }
            if (!((ExamPlacement)conflict).contains(current.getRoom())) {
                return;
            }
            if (swap.getRoom().equals(current.getRoom().getParentRoom()) || current.getRoom().equals(swap.getRoom().getParentRoom())) {
                return;
            }
            if (!x.checkDistributionConstraints(assignment, xNew)) {
                return;
            }
            if (!ExamRoomSwapNeighbour.checkParents(placement.getRoomPlacements(), swap, xNew)) {
                return;
            }
            int xSize = 0;
            for (ExamRoomPlacement r : ((ExamPlacement)conflict).getRoomPlacements()) {
                xSize += r.getSize(x.hasAltSeating());
            }
            xSize -= swap.getSize(x.hasAltSeating());
            if ((xSize += current.getSize(x.hasAltSeating())) < x.getSize()) {
                return;
            }
            HashSet<ExamPlacement> otherConf = new HashSet<ExamPlacement>();
            otherConf.add(placement);
            current.getRoom().computeConflicts(assignment, x, placement.getPeriod(), otherConf);
            if (otherConf.size() > 1) {
                return;
            }
            HashSet<ExamRoomPlacement> newRooms = new HashSet<ExamRoomPlacement>(placement.getRoomPlacements());
            newRooms.remove(current);
            newRooms.add(swap);
            Iterator i = newRooms.iterator();
            while (i.hasNext()) {
                ExamRoomPlacement r = (ExamRoomPlacement)i.next();
                if (r.equals(swap) || size - r.getSize(exam.hasAltSeating()) < exam.getSize()) continue;
                i.remove();
                size -= r.getSize(exam.hasAltSeating());
            }
            this.iX1 = new ExamPlacement(exam, placement.getPeriodPlacement(), newRooms);
            HashSet<ExamRoomPlacement> xRooms = new HashSet<ExamRoomPlacement>(((ExamPlacement)conflict).getRoomPlacements());
            xRooms.remove(x.getRoomPlacement(swap.getRoom()));
            xRooms.add(xNew);
            Iterator i2 = xRooms.iterator();
            while (i2.hasNext()) {
                ExamRoomPlacement r = (ExamRoomPlacement)i2.next();
                if (r.equals(swap) || xSize - r.getSize(x.hasAltSeating()) < x.getSize()) continue;
                i2.remove();
                xSize -= r.getSize(x.hasAltSeating());
            }
            this.iX2 = new ExamPlacement(x, ((ExamPlacement)conflict).getPeriodPlacement(), xRooms);
            ExamPlacement p = assignment.getValue(exam);
            this.iValue = this.iX1.toDouble(assignment) - (p == null ? 0.0 : p.toDouble(assignment)) + this.iX2.toDouble(assignment) - ((ExamPlacement)conflict).toDouble(assignment);
        }
        this.iR1 = current;
        this.iR2 = swap;
    }

    public boolean canDo() {
        return this.iX1 != null;
    }

    @Override
    public void assign(Assignment<Exam, ExamPlacement> assignment, long iteration) {
        if (this.iX2 == null) {
            assignment.assign(iteration, this.iX1);
        } else {
            assignment.unassign(iteration, (Exam)this.iX1.variable());
            assignment.unassign(iteration, (Exam)this.iX2.variable());
            assignment.assign(iteration, this.iX1);
            assignment.assign(iteration, this.iX2);
        }
    }

    public String toString() {
        if (this.iX2 == null) {
            return this.iX1.variable() + " := " + this.iX1.toString() + " /  (value:" + this.value((Assignment<Exam, ExamPlacement>)null) + ")";
        }
        return ((Exam)this.iX1.variable()).getName() + ": " + this.iR1.getRoom() + " <-> " + this.iR2.getRoom() + " (w " + ((Exam)this.iX2.variable()).getName() + ", value:" + this.value((Assignment<Exam, ExamPlacement>)null) + ")";
    }

    protected static String toString(double[] x, double[] y) {
        DecimalFormat df = new DecimalFormat("0.00");
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < x.length; ++i) {
            if (i > 0) {
                s.append(",");
            }
            s.append(df.format(x[i] - y[i]));
        }
        return "[" + s.toString() + "]";
    }

    @Override
    public double value(Assignment<Exam, ExamPlacement> assignment) {
        return this.iValue;
    }

    @Override
    public Map<Exam, ExamPlacement> assignments() {
        HashMap<Exam, ExamPlacement> ret = new HashMap<Exam, ExamPlacement>();
        ret.put((Exam)this.iX1.variable(), this.iX1);
        if (this.iX2 != null) {
            ret.put((Exam)this.iX2.variable(), this.iX2);
        }
        return ret;
    }

    private static boolean checkParents(Collection<ExamRoomPlacement> rooms, ExamRoomPlacement current, ExamRoomPlacement swap) {
        if (swap.getRoom().getParentRoom() != null) {
            for (ExamRoomPlacement r : rooms) {
                if (r.equals(current) || !r.getRoom().equals(swap.getRoom().getParentRoom())) continue;
                return false;
            }
        }
        if (swap.getRoom().getPartitions() != null) {
            for (ExamRoomPlacement r : rooms) {
                if (r.equals(current) || !swap.getRoom().getPartitions().contains(r.getRoom())) continue;
                return false;
            }
        }
        return true;
    }
}

