/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.exam.heuristics;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cpsolver.exam.model.Exam;
import org.cpsolver.exam.model.ExamModel;
import org.cpsolver.exam.model.ExamPeriodPlacement;
import org.cpsolver.exam.model.ExamPlacement;
import org.cpsolver.exam.model.ExamRoomPlacement;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.context.AssignmentContext;
import org.cpsolver.ifs.assignment.context.NeighbourSelectionWithContext;
import org.cpsolver.ifs.extension.ConflictStatistics;
import org.cpsolver.ifs.extension.Extension;
import org.cpsolver.ifs.heuristics.ValueSelection;
import org.cpsolver.ifs.model.Neighbour;
import org.cpsolver.ifs.model.SimpleNeighbour;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.ToolBox;

public class ExamTabuSearch
extends NeighbourSelectionWithContext<Exam, ExamPlacement, TabuList>
implements ValueSelection<Exam, ExamPlacement> {
    private static Logger sLog = LogManager.getLogger(ExamTabuSearch.class);
    private ConflictStatistics<Exam, ExamPlacement> iStat = null;
    private long iFirstIteration = -1L;
    private long iMaxIdleIterations = 10000L;
    private int iTabuMinSize = 0;
    private int iTabuMaxSize = 0;
    private double iConflictWeight = 1000000.0;
    private double iValueWeight = 1.0;

    public ExamTabuSearch(DataProperties properties) throws Exception {
        this.iTabuMinSize = properties.getPropertyInt("TabuSearch.MinSize", this.iTabuMinSize);
        this.iTabuMaxSize = properties.getPropertyInt("TabuSearch.MaxSize", this.iTabuMaxSize);
        this.iMaxIdleIterations = properties.getPropertyLong("TabuSearch.MaxIdle", this.iMaxIdleIterations);
        this.iConflictWeight = properties.getPropertyDouble("Value.ConflictWeight", this.iConflictWeight);
        this.iValueWeight = properties.getPropertyDouble("Value.ValueWeight", this.iValueWeight);
    }

    @Override
    public void init(Solver<Exam, ExamPlacement> solver) {
        super.init(solver);
        for (Extension<Exam, ExamPlacement> extension : solver.getExtensions()) {
            if (!ConflictStatistics.class.isInstance(extension)) continue;
            this.iStat = (ConflictStatistics)extension;
        }
    }

    @Override
    public Neighbour<Exam, ExamPlacement> selectNeighbour(Solution<Exam, ExamPlacement> solution) {
        if (this.iFirstIteration < 0L) {
            this.iFirstIteration = solution.getIteration();
        }
        TabuList tabu = (TabuList)this.getContext(solution.getAssignment());
        long idle = solution.getIteration() - Math.max(this.iFirstIteration, solution.getBestIteration());
        if (idle > this.iMaxIdleIterations) {
            sLog.debug("  [tabu]    max idle iterations reached");
            this.iFirstIteration = -1L;
            if (tabu.size() > 0) {
                tabu.clear();
            }
            return null;
        }
        if (tabu.size() > 0 && this.iTabuMaxSize > this.iTabuMinSize) {
            if (idle == 0L) {
                tabu.resize(this.iTabuMinSize);
            } else if (idle % (this.iMaxIdleIterations / (long)(this.iTabuMaxSize - this.iTabuMinSize)) == 0L) {
                tabu.resize(Math.min(this.iTabuMaxSize, tabu.size() + 1));
            }
        }
        boolean acceptConflicts = solution.getModel().getBestUnassignedVariables() > 0;
        ExamModel model = (ExamModel)solution.getModel();
        Assignment<Exam, ExamPlacement> assignment = solution.getAssignment();
        double bestEval = 0.0;
        ArrayList<ExamPlacement> best = null;
        for (Exam exam : model.variables()) {
            ExamPlacement assigned = assignment.getValue(exam);
            double assignedVal = assigned == null ? this.iConflictWeight : this.iValueWeight * assigned.toDouble(assignment);
            for (ExamPeriodPlacement period : exam.getPeriodPlacements()) {
                int un;
                ExamPlacement value;
                Set<ExamRoomPlacement> rooms = exam.findBestAvailableRooms(assignment, period);
                if (rooms == null) {
                    rooms = exam.findRoomsRandom(assignment, period, false);
                }
                if (rooms == null || (value = new ExamPlacement(exam, period, rooms)).equals(assigned)) continue;
                double eval = this.iValueWeight * value.toDouble(assignment) - assignedVal;
                if (acceptConflicts) {
                    Set<ExamPlacement> conflicts = model.conflictValues(assignment, value);
                    for (ExamPlacement conflict : conflicts) {
                        eval -= this.iValueWeight * conflict.toDouble(assignment);
                        eval += this.iConflictWeight * (1.0 + (this.iStat == null ? 0.0 : this.iStat.countRemovals(solution.getIteration(), conflict, value)));
                    }
                } else if (model.inConflict(assignment, value)) continue;
                if (tabu.size() > 0 && tabu.contains(exam.getId() + ":" + value.getPeriod().getIndex()) && ((un = model.variables().size() - assignment.nrAssignedVariables() - (assigned == null ? 0 : 1)) > model.getBestUnassignedVariables() || un == model.getBestUnassignedVariables() && model.getTotalValue(assignment) + eval >= solution.getBestValue())) continue;
                if (best == null || bestEval > eval) {
                    if (best == null) {
                        best = new ArrayList<ExamPlacement>();
                    } else {
                        best.clear();
                    }
                    best.add(value);
                    bestEval = eval;
                    continue;
                }
                if (bestEval != eval) continue;
                best.add(value);
            }
        }
        if (best == null) {
            sLog.debug("  [tabu] --none--");
            this.iFirstIteration = -1L;
            if (tabu.size() > 0) {
                tabu.clear();
            }
            return null;
        }
        ExamPlacement bestVal = (ExamPlacement)ToolBox.random(best);
        if (sLog.isDebugEnabled()) {
            Set<ExamPlacement> conflicts = model.conflictValues(assignment, bestVal);
            double wconf = this.iStat == null ? 0.0 : this.iStat.countRemovals(solution.getIteration(), (ExamPlacement)((Object)conflicts), bestVal);
            sLog.debug("  [tabu] " + bestVal + " (" + (assignment.getValue((Exam)bestVal.variable()) == null ? "" : "was=" + assignment.getValue((Exam)bestVal.variable()) + ", ") + "val=" + bestEval + (conflicts.isEmpty() ? "" : ", conf=" + (wconf + (double)conflicts.size()) + "/" + conflicts) + ")");
        }
        if (tabu.size() > 0) {
            tabu.add(((Exam)bestVal.variable()).getId() + ":" + bestVal.getPeriod().getIndex());
        }
        return new SimpleNeighbour<Exam, ExamPlacement>((Exam)bestVal.variable(), bestVal);
    }

    @Override
    public ExamPlacement selectValue(Solution<Exam, ExamPlacement> solution, Exam exam) {
        if (this.iFirstIteration < 0L) {
            this.iFirstIteration = solution.getIteration();
        }
        TabuList tabu = (TabuList)this.getContext(solution.getAssignment());
        long idle = solution.getIteration() - Math.max(this.iFirstIteration, solution.getBestIteration());
        if (idle > this.iMaxIdleIterations) {
            sLog.debug("  [tabu]    max idle iterations reached");
            this.iFirstIteration = -1L;
            if (tabu.size() > 0) {
                tabu.clear();
            }
            return null;
        }
        if (tabu.size() > 0 && this.iTabuMaxSize > this.iTabuMinSize) {
            if (idle == 0L) {
                tabu.resize(this.iTabuMinSize);
            } else if (idle % (this.iMaxIdleIterations / (long)(this.iTabuMaxSize - this.iTabuMinSize)) == 0L) {
                tabu.resize(Math.min(this.iTabuMaxSize, tabu.size() + 1));
            }
        }
        ExamModel model = (ExamModel)solution.getModel();
        Assignment<Exam, ExamPlacement> assignment = solution.getAssignment();
        double bestEval = 0.0;
        ArrayList<ExamPlacement> best = null;
        ExamPlacement assigned = assignment.getValue(exam);
        double assignedVal = assigned == null ? this.iConflictWeight : this.iValueWeight * assigned.toDouble(assignment);
        for (ExamPeriodPlacement period : exam.getPeriodPlacements()) {
            int un;
            Set<ExamRoomPlacement> rooms = exam.findBestAvailableRooms(assignment, period);
            if (rooms == null) {
                rooms = exam.findRoomsRandom(assignment, period, false);
            }
            if (rooms == null) {
                sLog.info("Exam " + exam.getName() + " has no rooms for period " + period);
                continue;
            }
            ExamPlacement value = new ExamPlacement(exam, period, rooms);
            if (value.equals(assigned)) continue;
            Set<ExamPlacement> conflicts = model.conflictValues(assignment, value);
            double eval = this.iValueWeight * value.toDouble(assignment) - assignedVal;
            for (ExamPlacement conflict : conflicts) {
                eval -= this.iValueWeight * conflict.toDouble(assignment);
                eval += this.iConflictWeight * (1.0 + (this.iStat == null ? 0.0 : this.iStat.countRemovals(solution.getIteration(), conflict, value)));
            }
            if (tabu.size() > 0 && tabu.contains(exam.getId() + ":" + value.getPeriod().getIndex()) && ((un = model.variables().size() - assignment.nrAssignedVariables() - (assigned == null ? 0 : 1)) > model.getBestUnassignedVariables() || un == model.getBestUnassignedVariables() && model.getTotalValue(assignment) + eval >= solution.getBestValue())) continue;
            if (best == null || bestEval > eval) {
                if (best == null) {
                    best = new ArrayList<ExamPlacement>();
                } else {
                    best.clear();
                }
                best.add(value);
                bestEval = eval;
                continue;
            }
            if (bestEval != eval) continue;
            best.add(value);
        }
        if (best == null) {
            return null;
        }
        ExamPlacement bestVal = (ExamPlacement)ToolBox.random(best);
        if (sLog.isDebugEnabled()) {
            Set<ExamPlacement> conflicts = model.conflictValues(assignment, bestVal);
            double wconf = this.iStat == null ? 0.0 : this.iStat.countRemovals(solution.getIteration(), (ExamPlacement)((Object)conflicts), bestVal);
            sLog.debug("  [tabu] " + bestVal + " (" + (assignment.getValue((Exam)bestVal.variable()) == null ? "" : "was=" + assignment.getValue((Exam)bestVal.variable()) + ", ") + "val=" + bestEval + (conflicts.isEmpty() ? "" : ", conf=" + (wconf + (double)conflicts.size()) + "/" + conflicts) + ")");
        }
        if (tabu.size() > 0) {
            tabu.add(exam.getId() + ":" + bestVal.getPeriod().getIndex());
        }
        return bestVal;
    }

    @Override
    public TabuList createAssignmentContext(Assignment<Exam, ExamPlacement> assignment) {
        return new TabuList(this.iTabuMinSize);
    }

    private static class TabuItem
    implements Comparable<TabuItem> {
        private Object iObject;
        private long iIteration;

        public TabuItem(Object object, long iteration) {
            this.iObject = object;
            this.iIteration = iteration;
        }

        public Object getObject() {
            return this.iObject;
        }

        public long getIteration() {
            return this.iIteration;
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof TabuItem)) {
                return false;
            }
            return this.getObject().equals(((TabuItem)object).getObject());
        }

        public int hashCode() {
            return this.getObject().hashCode();
        }

        @Override
        public int compareTo(TabuItem o) {
            return Double.compare(this.getIteration(), o.getIteration());
        }

        public String toString() {
            return this.getObject().toString();
        }
    }

    public static class TabuList
    implements AssignmentContext {
        private HashSet<TabuItem> iList = new HashSet();
        private int iSize;
        private long iIteration = 0L;

        public TabuList(int size) {
            this.iSize = size;
        }

        public Object add(Object object) {
            if (this.iSize == 0) {
                return object;
            }
            if (this.contains(object)) {
                this.iList.remove(new TabuItem(object, 0L));
                this.iList.add(new TabuItem(object, this.iIteration++));
                return null;
            }
            Object oldest = null;
            if (this.iList.size() >= this.iSize) {
                oldest = this.removeOldest();
            }
            this.iList.add(new TabuItem(object, this.iIteration++));
            return oldest;
        }

        public void resize(int newSize) {
            this.iSize = newSize;
            while (this.iList.size() > newSize) {
                this.removeOldest();
            }
        }

        public boolean contains(Object object) {
            return this.iList.contains(new TabuItem(object, 0L));
        }

        public void clear() {
            this.iList.clear();
        }

        public int size() {
            return this.iSize;
        }

        public Object removeOldest() {
            TabuItem oldest = null;
            for (TabuItem element : this.iList) {
                if (oldest != null && oldest.getIteration() <= element.getIteration()) continue;
                oldest = element;
            }
            if (oldest == null) {
                return null;
            }
            this.iList.remove(oldest);
            return oldest.getObject();
        }

        public String toString() {
            return new TreeSet<TabuItem>(this.iList).toString();
        }
    }
}

