/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.sectioning;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.sectioning.SctStudent;

public class SctEnrollment
implements Comparable<SctEnrollment> {
    private int iId;
    private SctStudent iStudent;
    private List<Lecture> iLectures;
    private double iConflictWeight;

    public SctEnrollment(int id, SctStudent student, Collection<Lecture> lectures, double conflictWeight) {
        this.iId = id;
        this.iStudent = student;
        this.iLectures = new ArrayList<Lecture>(lectures);
        this.iConflictWeight = conflictWeight;
    }

    public SctEnrollment(int id, SctStudent student, Collection<Lecture> lectures) {
        this.iId = id;
        this.iStudent = student;
        this.iLectures = new ArrayList<Lecture>(lectures);
        this.iConflictWeight = 0.0;
        for (Lecture lecture : lectures) {
            for (Lecture other : student.getStudent().getLectures()) {
                if (lecture.getConfiguration().getOfferingId().equals(other.getConfiguration().getOfferingId())) continue;
                this.iConflictWeight += student.getJenrConflictWeight(lecture, other);
            }
            for (Lecture other : lectures) {
                if (lecture.getClassId().compareTo(other.getClassId()) >= 0) continue;
                this.iConflictWeight += student.getJenrConflictWeight(lecture, other);
            }
        }
    }

    public SctStudent getStudent() {
        return this.iStudent;
    }

    public List<Lecture> getLectures() {
        return this.iLectures;
    }

    public double getConflictWeight() {
        return this.iConflictWeight;
    }

    @Override
    public int compareTo(SctEnrollment o) {
        int cmp = Double.compare(this.getConflictWeight(), o.getConflictWeight());
        if (cmp != 0) {
            return cmp;
        }
        return Double.compare(this.iId, o.iId);
    }

    public Integer getId() {
        return this.iId;
    }

    public String toString() {
        return this.iConflictWeight + "/" + this.iLectures;
    }
}

