/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.neighbourhoods;

import java.util.List;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.RoomLocation;
import org.cpsolver.coursett.model.TimetableModel;
import org.cpsolver.ifs.algorithms.neighbourhoods.RandomMove;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Neighbour;
import org.cpsolver.ifs.model.SimpleNeighbour;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.ToolBox;

public class RoomChange
extends RandomMove<Lecture, Placement> {
    public RoomChange(DataProperties config) {
        super(config);
    }

    @Override
    public Neighbour<Lecture, Placement> selectNeighbour(Solution<Lecture, Placement> solution) {
        TimetableModel model = (TimetableModel)solution.getModel();
        Assignment<Lecture, Placement> assignment = solution.getAssignment();
        int varIdx = ToolBox.random(model.variables().size());
        for (int i = 0; i < model.variables().size(); ++i) {
            List<RoomLocation> values;
            Lecture lecture = (Lecture)model.variables().get((i + varIdx) % model.variables().size());
            Placement old = assignment.getValue(lecture);
            if (old == null || old.getNrRooms() != 1 || (values = lecture.roomLocations()).isEmpty()) continue;
            int valIdx = ToolBox.random(values.size());
            for (int j = 0; j < values.size(); ++j) {
                Placement placement;
                RoomLocation room = values.get((j + valIdx) % values.size());
                if (room.getPreference() > 50 || room.equals(old.getRoomLocation()) || !(placement = new Placement(lecture, old.getTimeLocation(), room)).isValid() || model.inConflict(assignment, placement)) continue;
                SimpleNeighbour<Lecture, Placement> n = new SimpleNeighbour<Lecture, Placement>(lecture, placement);
                if (this.iHC && !(n.value(assignment) <= 0.0)) continue;
                return n;
            }
        }
        return null;
    }
}

