/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.model;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.cpsolver.coursett.model.Configuration;
import org.cpsolver.coursett.model.FinalSectioning;
import org.cpsolver.coursett.model.InitialSectioning;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.Student;
import org.cpsolver.coursett.model.StudentSectioning;
import org.cpsolver.coursett.model.TimetableModel;
import org.cpsolver.coursett.sectioning.StudentSwapSectioning;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.InfoProvider;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.termination.TerminationCondition;
import org.cpsolver.ifs.util.Progress;

public class DefaultStudentSectioning
implements StudentSectioning,
InfoProvider<Lecture, Placement> {
    protected TimetableModel iModel = null;
    private Progress iProgress = null;
    protected FinalSectioning iFinalSectioning = null;
    protected boolean iMustFollowReservations = false;
    protected static DecimalFormat sDF2 = new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.US));

    public DefaultStudentSectioning(TimetableModel model) {
        this.iModel = model;
        this.iFinalSectioning = new FinalSectioning(model);
        this.iMustFollowReservations = model.getProperties().getPropertyBoolean("StudentSectioning.MustFollowReservations", false);
    }

    public Progress getProgress() {
        if (this.iProgress == null) {
            this.iProgress = Progress.getInstance(this.iModel);
        }
        return this.iProgress;
    }

    @Override
    public void initialSectioning(Assignment<Lecture, Placement> assignment, Long offeringId, String courseName, Collection<Student> students, Collection<Configuration> configurations) {
        block16: {
            block15: {
                if (students == null || students.isEmpty()) {
                    return;
                }
                if (configurations == null || configurations.isEmpty()) {
                    return;
                }
                if (configurations.size() != 1) break block15;
                if (this.isMustFollowReservations()) {
                    ArrayList<Student> availableStudents = new ArrayList<Student>(students.size());
                    Configuration cfg = configurations.iterator().next();
                    for (Student st : students) {
                        if (st.canEnroll(cfg)) {
                            availableStudents.add(st);
                            st.addConfiguration(cfg);
                        } else {
                            this.getProgress().debug("Unable to enroll student " + st.getId() + " in " + courseName);
                        }
                        for (Long subpartId : cfg.getTopSubpartIds()) {
                            this.initialSectioningLectures(assignment, offeringId, courseName, availableStudents, cfg.getTopLectures(subpartId));
                        }
                    }
                } else {
                    Configuration cfg = configurations.iterator().next();
                    for (Student st : students) {
                        st.addConfiguration(cfg);
                    }
                    for (Long subpartId : cfg.getTopSubpartIds()) {
                        this.initialSectioningLectures(assignment, offeringId, courseName, students, cfg.getTopLectures(subpartId));
                    }
                }
                break block16;
            }
            this.getProgress().trace("sectioning " + students.size() + " students of course " + courseName + " into " + configurations.size() + " configurations");
            InitialSectioning.Group[] studentsPerSection = this.studentsToConfigurations(offeringId, students, configurations);
            for (int i = 0; i < configurations.size(); ++i) {
                InitialSectioning.Group group = studentsPerSection[i];
                this.getProgress().trace(i + 1 + ". configuration got " + group.getStudents().size() + " students (weighted=" + group.size() + ", cfgLimit=" + group.getConfiguration().getLimit() + ")");
                for (Student st : group.getStudents()) {
                    st.addConfiguration(group.getConfiguration());
                }
                for (Long subpartId : group.getConfiguration().getTopSubpartIds()) {
                    this.initialSectioningLectures(assignment, offeringId, courseName, group.getStudents(), group.getConfiguration().getTopLectures(subpartId));
                }
            }
            if (!this.isMustFollowReservations()) break block16;
            for (Student st : students) {
                boolean hasConfig = false;
                for (Configuration cfg : configurations) {
                    if (!st.getConfigurations().contains(cfg)) continue;
                    hasConfig = true;
                    break;
                }
                if (hasConfig) continue;
                this.getProgress().debug("Unable to enroll student " + st.getId() + " in " + courseName);
            }
        }
    }

    protected String getClassLabel(Lecture lecture) {
        return "<A href='classDetail.do?cid=" + lecture.getClassId() + "'>" + lecture.getName() + "</A>";
    }

    protected void initialSectioningLectures(Assignment<Lecture, Placement> assignment, Long offeringId, String courseName, Collection<Student> students, Collection<Lecture> lectures) {
        block16: {
            block15: {
                if (lectures == null || lectures.isEmpty()) {
                    return;
                }
                if (students == null || students.isEmpty()) {
                    return;
                }
                for (Lecture lecture : lectures) {
                    if (lecture.classLimit(assignment) != 0 || lecture.isCommitted()) continue;
                    this.getProgress().warn("Class " + this.getClassLabel(lecture) + " has zero class limit.");
                }
                this.getProgress().trace("sectioning " + students.size() + " students of course " + courseName + " into " + lectures.size() + " sections");
                if (lectures.size() != 1) break block15;
                ArrayList<Student> availableStudents = this.isMustFollowReservations() ? new ArrayList<Student>(students.size()) : students;
                Lecture lect = lectures.iterator().next();
                for (Student st : students) {
                    if (!st.canEnroll(lect)) {
                        this.getProgress().debug("Unable to enroll student " + st.getId() + " in class " + this.getClassLabel(lect));
                        if (this.isMustFollowReservations()) continue;
                    }
                    lect.addStudent(assignment, st);
                    st.addLecture(lect);
                    if (!this.isMustFollowReservations()) continue;
                    availableStudents.add(st);
                }
                if (!lect.hasAnyChildren()) break block16;
                for (Long subpartId : lect.getChildrenSubpartIds()) {
                    List<Lecture> children = lect.getChildren(subpartId);
                    this.initialSectioningLectures(assignment, offeringId, lect.getName(), availableStudents, children);
                }
                break block16;
            }
            InitialSectioning.Group[] studentsPerSection = this.studentsToLectures(offeringId, (Collection<Student>)students, lectures);
            for (int i = 0; i < studentsPerSection.length; ++i) {
                InitialSectioning.Group group = studentsPerSection[i];
                Lecture lect = group.getLecture();
                if (group.getStudents().isEmpty()) {
                    this.getProgress().trace("Lecture " + this.getClassLabel(lect) + " got no students (cl=" + lect.classLimit(assignment) + ")");
                    continue;
                }
                this.getProgress().trace("Lecture " + this.getClassLabel(lect) + " got " + group.getStudents().size() + " students (weighted=" + group.size() + ", classLimit=" + lect.classLimit(assignment) + ")");
                List<Student> studentsThisSection = group.getStudents();
                for (Student st : studentsThisSection) {
                    if (!st.canEnroll(lect)) {
                        if (this.isMustFollowReservations()) {
                            this.getProgress().info("Unable to enroll student " + st.getId() + " in class " + this.getClassLabel(lect));
                            continue;
                        }
                        this.getProgress().debug("Unable to enroll student " + st.getId() + " in class " + this.getClassLabel(lect));
                    }
                    lect.addStudent(assignment, st);
                    st.addLecture(lect);
                }
                if (!lect.hasAnyChildren()) continue;
                for (Long subpartId : lect.getChildrenSubpartIds()) {
                    List<Lecture> children = lect.getChildren(subpartId);
                    this.initialSectioningLectures(assignment, offeringId, lect.getName(), studentsThisSection, children);
                }
            }
            if (this.isMustFollowReservations()) {
                for (Student st : students) {
                    boolean hasLecture = false;
                    for (Lecture lect : lectures) {
                        if (!st.getLectures().contains(lect)) continue;
                        hasLecture = true;
                        break;
                    }
                    if (hasLecture) continue;
                    this.getProgress().debug("Unable to enroll student " + st.getId() + " in " + courseName);
                }
            }
        }
    }

    protected InitialSectioning.Group[] studentsToConfigurations(Long offeringId, Collection<Student> students, Collection<Configuration> configurations) {
        InitialSectioning sect = new InitialSectioning(this.getProgress(), offeringId, configurations, students);
        sect.setMustFollowReservations(this.isMustFollowReservations());
        return sect.getGroups();
    }

    protected InitialSectioning.Group[] studentsToLectures(Long offeringId, Collection<Student> students, Collection<Lecture> lectures) {
        InitialSectioning sect = new InitialSectioning(this.getProgress(), offeringId, lectures, students);
        sect.setMustFollowReservations(this.isMustFollowReservations());
        return sect.getGroups();
    }

    @Override
    public boolean hasFinalSectioning() {
        return true;
    }

    @Override
    public void switchStudents(Solution<Lecture, Placement> solution, TerminationCondition<Lecture, Placement> termination) {
        this.iFinalSectioning.execute(solution, termination);
    }

    @Override
    public void resection(Assignment<Lecture, Placement> assignment, Lecture lecture, boolean recursive, boolean configAsWell) {
        this.iFinalSectioning.resection(assignment, lecture, recursive, configAsWell);
    }

    @Override
    public void getInfo(Assignment<Lecture, Placement> assignment, Map<String, String> info) {
        if (!this.iModel.getStudentGroups().isEmpty()) {
            info.put("Student groups", sDF2.format(100.0 * StudentSwapSectioning.group(this.iModel) / (double)this.iModel.getStudentGroups().size()) + "%");
        }
    }

    @Override
    public void getInfo(Assignment<Lecture, Placement> assignment, Map<String, String> info, Collection<Lecture> variables) {
        if (!this.iModel.getStudentGroups().isEmpty()) {
            info.put("Student groups", sDF2.format(StudentSwapSectioning.gp(this.iModel, variables)) + "%");
        }
    }

    public boolean isMustFollowReservations() {
        return this.iMustFollowReservations;
    }

    public void setMustFollowReservations(boolean mustFollow) {
        this.iMustFollowReservations = mustFollow;
    }
}

