/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.custom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import org.cpsolver.coursett.model.Configuration;
import org.cpsolver.coursett.model.DefaultStudentSectioning;
import org.cpsolver.coursett.model.InitialSectioning;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.Student;
import org.cpsolver.coursett.model.TimetableModel;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.termination.TerminationCondition;
import org.cpsolver.ifs.util.Progress;

public class DeterministicStudentSectioning
extends DefaultStudentSectioning {
    public DeterministicStudentSectioning(TimetableModel model) {
        super(model);
    }

    @Override
    protected InitialSectioning.Group[] studentsToConfigurations(Long offeringId, Collection<Student> students, Collection<Configuration> configurations) {
        DeterministicInitialSectioning sect = new DeterministicInitialSectioning(this.getProgress(), offeringId, configurations, students);
        sect.setMustFollowReservations(this.isMustFollowReservations());
        return sect.getGroups();
    }

    @Override
    protected InitialSectioning.Group[] studentsToLectures(Long offeringId, Collection<Student> students, Collection<Lecture> lectures) {
        TreeSet<Lecture> sortedLectures = new TreeSet<Lecture>(new Comparator<Lecture>(){

            @Override
            public int compare(Lecture l1, Lecture l2) {
                return l1.getClassId().compareTo(l2.getClassId());
            }
        });
        sortedLectures.addAll(lectures);
        DeterministicInitialSectioning sect = new DeterministicInitialSectioning(this.getProgress(), offeringId, sortedLectures, students);
        sect.setMustFollowReservations(this.isMustFollowReservations());
        return sect.getGroups();
    }

    @Override
    public boolean hasFinalSectioning() {
        return false;
    }

    @Override
    public void switchStudents(Solution<Lecture, Placement> solution, TerminationCondition<Lecture, Placement> termination) {
    }

    @Override
    public void resection(Assignment<Lecture, Placement> assignment, Lecture lecture, boolean recursive, boolean configAsWell) {
    }

    public static class DeterministicInitialSectioning
    extends InitialSectioning
    implements Comparator<Student> {
        public DeterministicInitialSectioning(Progress progress, Long offeringId, Collection<?> lectureOrConfigurations, Collection<Student> students) {
            super(progress, offeringId, lectureOrConfigurations, students);
            this.iStudents = new TreeSet<Student>(this);
            this.iStudents.addAll(students);
        }

        @Override
        protected void tweakSizes(double total) {
            block5: {
                double studentsWeight = 0.0;
                for (Student s : this.iStudents) {
                    studentsWeight += s.getOfferingWeight(this.iOfferingId);
                }
                if (!(studentsWeight > total)) break block5;
                if (total == 0.0) {
                    for (int idx = 0; idx < this.iGroups.length; ++idx) {
                        this.iGroups[idx].setMaxSize(total / (double)this.iGroups.length);
                    }
                } else {
                    double factor = studentsWeight / total;
                    for (int idx = 0; idx < this.iGroups.length; ++idx) {
                        this.iGroups[idx].setMaxSize(factor * this.iGroups[idx].getMaxSize());
                        this.iGroups[idx].setMinSize(Math.min(this.iGroups[idx].getMinSize(), 0.9 * this.iGroups[idx].getMaxSize()));
                    }
                }
            }
        }

        @Override
        public InitialSectioning.Group[] getGroups() {
            Iterator i = this.iStudents.iterator();
            block0: while (i.hasNext()) {
                Student student = (Student)i.next();
                for (int idx = 0; idx < this.iGroups.length; ++idx) {
                    if (!this.iGroups[idx].isEnrolled(student)) continue;
                    this.iGroups[idx].addStudent(student);
                    i.remove();
                    continue block0;
                }
            }
            block2: for (Student student : this.iStudents) {
                double studentWeight = student.getOfferingWeight(this.iOfferingId);
                for (int idx = 0; idx < this.iGroups.length; ++idx) {
                    InitialSectioning.Group g = this.iGroups[idx];
                    if (!g.canEnroll(student) || g.size() >= g.getMaxSize()) continue;
                    g.addStudent(student);
                    continue block2;
                }
                InitialSectioning.Group group = null;
                int excess = 0;
                for (int idx = 0; idx < this.iGroups.length; ++idx) {
                    InitialSectioning.Group g = this.iGroups[idx];
                    if (!g.canEnroll(student)) continue;
                    int ex = (int)Math.round(g.size() + studentWeight - g.getMaxSize());
                    if (group != null && ex >= excess) continue;
                    group = g;
                    excess = ex;
                }
                if (group != null) {
                    group.addStudent(student);
                    continue;
                }
                if (this.isMustFollowReservations()) {
                    this.getProgress().debug("Unable to find a valid section for student " + student.getId() + ".");
                    continue;
                }
                this.getProgress().debug("Unable to find a valid section for student " + student.getId() + ", enrolling to " + (this.iGroups[0].getLecture() != null ? this.iGroups[0].getLecture().getName() : this.iGroups[0].getConfiguration().getConfigId().toString()));
                this.iGroups[0].addStudent(student);
            }
            block5: for (int idx = 0; idx < this.iGroups.length; ++idx) {
                InitialSectioning.Group group = this.iGroups[idx];
                if (!(group.size() > group.getMaxSize())) continue;
                for (Student student : new ArrayList<Student>(group.getStudents())) {
                    if (group.isEnrolled(student) || group.size() - student.getOfferingWeight(this.iOfferingId) < group.getMaxSize()) continue;
                    for (int x = 0; x < this.iGroups.length; ++x) {
                        if (idx == x || !this.iGroups[x].canEnroll(student) || this.iGroups[x].size() >= this.iGroups[x].getMaxSize()) continue;
                        group.removeStudent(student);
                        this.iGroups[x].addStudent(student);
                        break;
                    }
                    if (!(group.size() <= group.getMaxSize())) continue;
                    continue block5;
                }
            }
            return this.iGroups;
        }

        @Override
        public int compare(Student s1, Student s2) {
            int cmp = (s1.getCurriculum() == null ? "" : s1.getCurriculum()).compareToIgnoreCase(s2.getCurriculum() == null ? "" : s2.getCurriculum());
            if (cmp != 0) {
                return cmp;
            }
            cmp = (s1.getAcademicArea() == null ? "" : s1.getAcademicArea()).compareToIgnoreCase(s2.getAcademicArea() == null ? "" : s2.getAcademicArea());
            if (cmp != 0) {
                return cmp;
            }
            cmp = (s1.getMajor() == null ? "" : s1.getMajor()).compareToIgnoreCase(s2.getMajor() == null ? "" : s2.getMajor());
            if (cmp != 0) {
                return cmp;
            }
            cmp = (s1.getAcademicClassification() == null ? "" : s1.getAcademicClassification()).compareToIgnoreCase(s2.getAcademicClassification() == null ? "" : s2.getAcademicClassification());
            if (cmp != 0) {
                return cmp;
            }
            return s1.getId().compareTo(s2.getId());
        }
    }
}

