/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.webutil;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.Session;
import org.unitime.commons.web.WebTable;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.ManagerRole;
import org.unitime.timetable.model.SolverGroup;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.model.comparators.RolesComparator;
import org.unitime.timetable.model.dao.TimetableManagerDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.NameFormat;
import org.unitime.timetable.webutil.PdfWebTable;

public class TimetableManagerBuilder {
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);

    public PdfWebTable getManagersTable(SessionContext context, String format, boolean showAll) {
        String[] stringArray;
        int cols = 7;
        Session hibSession = null;
        boolean html = "html".equalsIgnoreCase(format);
        boolean pdf = "pdf".equalsIgnoreCase(format);
        boolean dispLastChanges = CommonValues.Yes.eq(UserProperty.DisplayLastChanges.get(context.getUser()));
        if (dispLastChanges) {
            ++cols;
        }
        Long currentAcadSession = context.getUser().getCurrentAcademicSessionId();
        String string = html ? "" : MSG.sectManagerList(currentAcadSession == null ? "" : context.getUser().getCurrentAuthority().getQualifiers("Session").get(0).getQualifierLabel());
        if (dispLastChanges) {
            String[] stringArray2 = new String[8];
            stringArray2[0] = MSG.columnRoles();
            stringArray2[1] = MSG.columnExternalId();
            stringArray2[2] = MSG.columnManagerName();
            stringArray2[3] = MSG.columnEmailAddress();
            stringArray2[4] = MSG.columnDepartment();
            stringArray2[5] = MSG.columnSubjectArea();
            stringArray2[6] = MSG.columnSolverGroup();
            stringArray = stringArray2;
            stringArray2[7] = MSG.columnLastChange();
        } else {
            String[] stringArray3 = new String[7];
            stringArray3[0] = MSG.columnRoles();
            stringArray3[1] = MSG.columnExternalId();
            stringArray3[2] = MSG.columnManagerName();
            stringArray3[3] = MSG.columnEmailAddress();
            stringArray3[4] = MSG.columnDepartment();
            stringArray3[5] = MSG.columnSubjectArea();
            stringArray = stringArray3;
            stringArray3[6] = MSG.columnSolverGroup();
        }
        PdfWebTable webTable = new PdfWebTable(cols, string, "timetableManagerList.action?order=%%", stringArray, new String[]{"left", "left", "left", "left", "left", "left", "left", "left"}, new boolean[]{true, true, true, true, true, true, true, false});
        webTable.enableHR("#9CB0CE");
        webTable.setRowStyle("white-space: nowrap");
        TimetableManagerDAO empDao = TimetableManagerDAO.getInstance();
        hibSession = empDao.getSession();
        List empList = hibSession.createQuery("from TimetableManager order by lastName, firstName", TimetableManager.class).list();
        Iterator iterEmp = empList.iterator();
        NameFormat nameFormat = NameFormat.fromReference(context.getUser().getProperty(UserProperty.NameFormat));
        while (iterEmp.hasNext()) {
            TimetableManager manager = (TimetableManager)iterEmp.next();
            String puid = manager.getExternalUniqueId();
            String email = manager.getEmailAddress() != null ? manager.getEmailAddress() : " ";
            String fullName = nameFormat.format(manager);
            Object subjectList = "";
            Object roleStr = "";
            Object deptStr = "";
            Set<Department> depts = manager.getDepartments();
            Set<ManagerRole> mgrRolesSet = manager.getManagerRoles();
            String onClick = context.hasPermission(manager, Right.TimetableManagerEdit) ? "onClick=\"document.location='timetableManagerEdit.action?op=Edit&id=" + manager.getUniqueId() + "';\"" : null;
            Object roleOrd = "";
            ArrayList<ManagerRole> mgrRoles = new ArrayList<ManagerRole>(mgrRolesSet);
            Collections.sort(mgrRoles, new RolesComparator());
            boolean sessionIndependent = false;
            for (ManagerRole mgrRole : mgrRoles) {
                boolean receivesEmail;
                String roleRef;
                String title = roleRef = mgrRole.getRole().getAbbv();
                boolean bl = receivesEmail = mgrRole.isReceiveEmails() == null ? false : mgrRole.isReceiveEmails();
                if (((String)roleStr).length() > 0) {
                    roleStr = (String)roleStr + "," + (html ? "<br>" : "\n");
                }
                roleStr = mgrRoles.size() > 1 && mgrRole.isPrimary().booleanValue() ? (String)roleStr + (html ? "<span title='" + roleRef + " - " + MSG.flagPrimaryRole() + (String)(receivesEmail ? "" : ", " + MSG.explNoEmailForThisRole()) + "' style='font-weight:bold;'>" + roleRef + (receivesEmail ? "" : "*") + "</span>" : (pdf ? "@@BOLD " + roleRef + (receivesEmail ? "" : "*") + "@@END_BOLD " : roleRef + (receivesEmail ? "" : "*"))) : (String)roleStr + (String)(html ? (!receivesEmail ? "<span title='" + roleRef + (String)(receivesEmail ? "" : ", " + MSG.explNoEmailForThisRole()) + "' style='font-weight:normal;'>" + roleRef + (receivesEmail ? "" : "*") + "</span>" : roleRef) : roleRef + (receivesEmail ? "" : "*"));
                roleOrd = (String)roleOrd + title;
                if (!mgrRole.getRole().hasRight(Right.SessionIndependent) && (!mgrRole.getRole().hasRight(Right.SessionIndependentIfNoSessionGiven) || !manager.getDepartments().isEmpty())) continue;
                sessionIndependent = true;
            }
            boolean departmental = false;
            for (Department dept : depts) {
                if (!dept.getSession().getUniqueId().equals(currentAcadSession)) continue;
                departmental = true;
                if (((String)deptStr).trim().length() > 0) {
                    deptStr = (String)deptStr + ", " + (html ? "<br>" : "\n");
                }
                deptStr = (String)deptStr + (html ? "<span title='" + dept.getHtmlTitle() + "'>" + (dept.isExternalManager() != false ? "<b>" : "") + dept.getDeptCode() + (String)(dept.getAbbreviation() == null ? "" : ": " + dept.getAbbreviation().trim()) + (dept.isExternalManager() != false ? "</b>" : "") + "</span>" : (dept.isExternalManager() != false && pdf ? "@@BOLD " : "") + dept.getDeptCode() + (String)(dept.getAbbreviation() == null ? "" : ": " + dept.getAbbreviation().trim()) + (dept.isExternalManager() != false && pdf ? "@@END_BOLD " : ""));
                Set<SubjectArea> saList = dept.getSubjectAreas();
                if (saList == null || saList.size() <= 0) continue;
                for (SubjectArea sa : saList) {
                    if (((String)subjectList).length() > 0) {
                        subjectList = (String)subjectList + "," + (html ? "<br>" : "\n");
                    }
                    subjectList = (String)subjectList + (String)(html ? "<span title='" + sa.getTitle() + "'>" + sa.getSubjectAreaAbbreviation().trim() + "</span>" : sa.getSubjectAreaAbbreviation().trim());
                }
            }
            if (!showAll && !sessionIndependent && !departmental) continue;
            if (html && ((String)deptStr).trim().length() == 0) {
                deptStr = "&nbsp;";
            }
            if (html && ((String)subjectList).trim().length() == 0) {
                subjectList = "&nbsp;";
            }
            Object solverGroupStr = "";
            for (SolverGroup sg : manager.getSolverGroups()) {
                if (!sg.getSession().getUniqueId().equals(currentAcadSession)) continue;
                if (((String)solverGroupStr).length() > 0) {
                    solverGroupStr = (String)solverGroupStr + "," + (html ? "<br>" : "\n");
                }
                solverGroupStr = (String)solverGroupStr + (String)(html ? "<span title='" + sg.getName() + "'>" + sg.getAbbv() + "</span>" : sg.getAbbv());
            }
            if (html && ((String)solverGroupStr).length() == 0) {
                solverGroupStr = "&nbsp;";
            }
            Object lastChangeStr = null;
            Long lastChangeCmp = null;
            if (dispLastChanges) {
                ChangeLog lastChange;
                List<ChangeLog> changes = null;
                if (currentAcadSession != null) {
                    changes = ChangeLog.findLastNChanges(currentAcadSession, manager.getUniqueId(), null, null, 1);
                }
                ChangeLog changeLog = lastChange = changes == null || changes.isEmpty() ? null : changes.get(0);
                lastChangeStr = html ? (lastChange == null ? "&nbsp;" : "<span title='" + lastChange.getLabel() + "'>" + MSG.formatLastChange(lastChange.getSourceTitle(), lastChange.getOperationTitle(), ChangeLog.sDFdate.format(lastChange.getTimeStamp())) + "</span>") : (lastChange == null ? "" : MSG.formatLastChange(lastChange.getSourceTitle(), lastChange.getOperationTitle(), ChangeLog.sDFdate.format(lastChange.getTimeStamp())));
                lastChangeCmp = lastChange == null ? 0L : lastChange.getTimeStamp().getTime();
            }
            WebTable.WebTableLine line = webTable.addLine(onClick, new String[]{roleStr, puid, fullName, email, deptStr, subjectList, solverGroupStr, lastChangeStr}, new Comparable[]{roleOrd, puid, fullName, email, deptStr, subjectList, solverGroupStr, lastChangeCmp});
            line.setUniqueId(manager.getUniqueId().toString());
        }
        return webTable;
    }
}

