/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.webutil;

import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.security.SessionContext;

public class JavascriptFunctions {
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);

    public static boolean isJsConfirm(SessionContext context) {
        return context.isAuthenticated() ? CommonValues.Yes.eq(context.getUser().getProperty(UserProperty.ConfirmationDialogs)) : true;
    }

    public static String getJsConfirm(SessionContext context) {
        return "var jsConfirm = " + (JavascriptFunctions.isJsConfirm(context) ? "true" : "false") + ";";
    }

    public static String getInheritInstructorPreferencesCondition(SessionContext context) {
        String inheritInstrPref = context.getUser().getProperty(UserProperty.InheritInstructorPrefs);
        if (CommonValues.Always.eq(inheritInstrPref)) {
            return "true";
        }
        if (CommonValues.Never.eq(inheritInstrPref)) {
            return "false";
        }
        return "confirm('" + MSG.confirmApplyInstructorPreferencesToClass() + "')";
    }

    public static String getCancelInheritInstructorPreferencesCondition(SessionContext context) {
        String inheritInstrPref = context.getUser().getProperty(UserProperty.InheritInstructorPrefs);
        if (CommonValues.Always.eq(inheritInstrPref)) {
            return "true";
        }
        if (CommonValues.Never.eq(inheritInstrPref)) {
            return "false";
        }
        return "confirm('" + MSG.confirmRemoveInstructorPreferencesFromClass() + "')";
    }
}

