/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.util.queue;

import jakarta.activation.DataSource;
import jakarta.activation.FileTypeMap;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.commons.io.IOUtils;

public class ByteArrayDataSource
implements DataSource,
Serializable {
    private static final long serialVersionUID = 1L;
    private String iContentType;
    private String iName;
    private byte[] iData;

    public ByteArrayDataSource(File file) throws FileNotFoundException, IOException {
        this.iName = file.getName();
        this.iContentType = FileTypeMap.getDefaultFileTypeMap().getContentType(file);
        try (FileInputStream is = new FileInputStream(file);){
            this.iData = IOUtils.toByteArray((InputStream)is);
        }
    }

    public ByteArrayDataSource(DataSource ds) throws IOException {
        this.iName = ds.getName();
        this.iContentType = ds.getContentType();
        try (InputStream is = ds.getInputStream();){
            this.iData = IOUtils.toByteArray((InputStream)is);
        }
    }

    public String getContentType() {
        return this.iContentType;
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.iData);
    }

    public String getName() {
        return this.iName;
    }

    public OutputStream getOutputStream() throws IOException {
        return null;
    }
}

