/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.util.duration;

import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unitime.timetable.gwt.server.DayCode;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.TimePattern;
import org.unitime.timetable.util.duration.MinutesPerWeek;

public class WeeklyMinutes
extends MinutesPerWeek {
    private Float iSemesterWeeks = null;

    public WeeklyMinutes(String parameter) {
        super(parameter);
        Matcher matcher;
        if (parameter != null && !parameter.isEmpty() && (matcher = Pattern.compile(this.getParamterFormat()).matcher(parameter)).find()) {
            this.iSemesterWeeks = Float.valueOf(matcher.group(1));
        }
    }

    protected float getSemesterWeeks(DatePattern datePattern) {
        if (this.iSemesterWeeks != null) {
            return this.iSemesterWeeks.floatValue();
        }
        if (datePattern != null) {
            DatePattern defaultDatePattern = datePattern.getSession().getDefaultDatePattern();
            if (defaultDatePattern != null) {
                return defaultDatePattern.getEffectiveNumberOfWeeks();
            }
            return datePattern.getEffectiveNumberOfWeeks();
        }
        return 15.0f;
    }

    @Override
    public boolean isValidCombination(int weeklyMinutes, DatePattern datePattern, TimePattern timePattern) {
        if (timePattern.isExactTime()) {
            return true;
        }
        if (datePattern == null) {
            return false;
        }
        if (datePattern.isPatternSet()) {
            for (DatePattern child : datePattern.findChildren()) {
                if (!this.isValidCombination(weeklyMinutes, child, timePattern)) continue;
                return true;
            }
            return false;
        }
        return (float)weeklyMinutes == datePattern.getEffectiveNumberOfWeeks() * (float)timePattern.getNrMeetings().intValue() * (float)timePattern.getMinPerMtg().intValue() / this.getSemesterWeeks(datePattern);
    }

    @Override
    public String getParamterFormat() {
        return "([0-9]*\\.?[0-9]+)?";
    }

    @Override
    public int getExactTimeMinutesPerMeeting(int weeklyMinutes, DatePattern datePattern, int dayCode) {
        Iterator<DatePattern> iterator;
        if (datePattern == null) {
            return 0;
        }
        if (datePattern.isPatternSet() && (iterator = datePattern.findChildren().iterator()).hasNext()) {
            DatePattern child = iterator.next();
            return Math.round(this.getSemesterWeeks(datePattern) * (float)weeklyMinutes / ((float)DayCode.nrDays(dayCode) * child.getEffectiveNumberOfWeeks()));
        }
        return Math.round(this.getSemesterWeeks(datePattern) * (float)weeklyMinutes / ((float)DayCode.nrDays(dayCode) * datePattern.getEffectiveNumberOfWeeks()));
    }

    @Override
    public Integer getArrangedHours(int weeklyMinutes, DatePattern datePattern) {
        Iterator<DatePattern> iterator;
        if (weeklyMinutes <= 0 || datePattern == null) {
            return null;
        }
        if (datePattern.isPatternSet() && (iterator = datePattern.findChildren().iterator()).hasNext()) {
            DatePattern child = iterator.next();
            return Math.round(this.getSemesterWeeks(datePattern) * (float)weeklyMinutes / (child.getEffectiveNumberOfWeeks() * 50.0f));
        }
        return Math.round(this.getSemesterWeeks(datePattern) * (float)weeklyMinutes / (datePattern.getEffectiveNumberOfWeeks() * 50.0f));
    }
}

