/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.util;

import java.util.ArrayList;
import org.unitime.timetable.util.RoomSummaryReportsHelper;

public class OccupancyHelper
extends RoomSummaryReportsHelper {
    public OccupancyHelper(int iMinutesInPeriod, int iPeriodsInHour, int iAllDayStartPeriod, int iAllDayEndPeriod, int iStandardDayStartPeriod, int iStandardDayEndPeriod, int iWeekendDayStartPeriod, int iWeekendDayEndPeriod, int iFirstFullHourStartPeriod, int iLastFullHourStopPeriod, String iSchema) {
        super(iMinutesInPeriod, iPeriodsInHour, iAllDayStartPeriod, iAllDayEndPeriod, iStandardDayStartPeriod, iStandardDayEndPeriod, iWeekendDayStartPeriod, iWeekendDayEndPeriod, iFirstFullHourStartPeriod, iLastFullHourStopPeriod, iSchema);
    }

    public OccupancyHelper() {
    }

    @Override
    protected String getSummaryCalculationForPeriod(String first5MinutePeriod, String last5MinutePeriod, String additionalQueryField) {
        StringBuffer utilCal = new StringBuffer();
        utilCal.append("(case when z.nbr_rooms > 0 and ");
        utilCal.append(additionalQueryField);
        utilCal.append(" > 0 then ");
        utilCal.append("(((((case when z.stop_period > ");
        utilCal.append(last5MinutePeriod);
        utilCal.append(" then ");
        utilCal.append(last5MinutePeriod);
        utilCal.append(" else z.stop_period end) - (case when z.start_period < ");
        utilCal.append(first5MinutePeriod);
        utilCal.append(" then ");
        utilCal.append(first5MinutePeriod);
        utilCal.append(" else z.start_period end)) * ");
        utilCal.append(this.getMinutesInPeriod());
        utilCal.append(") * (");
        utilCal.append(additionalQueryField);
        utilCal.append(" * z.room_proration))  * 1/z.weeks_divisor_for_day_of_week/60.0)");
        utilCal.append(" else 0 end) ");
        return utilCal.toString();
    }

    protected String getRoomProration() {
        StringBuffer sb = new StringBuffer();
        sb.append("(case when r.capacity > 0");
        this.newline(sb, 8);
        sb.append("then");
        this.newline(sb, 12);
        sb.append("(select (r.capacity / sum(oth_r.capacity)) ");
        this.newline(sb, 12);
        sb.append("from ").append(this.getSchema()).append(".meeting om");
        this.newline(sb, 12);
        sb.append("inner join ").append(this.getSchema()).append(".room oth_r on oth_r.session_id = sess.uniqueid ");
        this.newline(sb, 16);
        sb.append("and oth_r.permanent_id = om.location_perm_id  ");
        this.newline(sb, 12);
        sb.append("where om.event_id = m.event_id ");
        this.newline(sb, 16);
        sb.append("and om.meeting_date = m.meeting_date ");
        this.newline(sb, 16);
        sb.append("and om.start_period = m.start_period ");
        this.newline(sb, 16);
        sb.append("and om.stop_period = m.stop_period");
        this.newline(sb, 16);
        sb.append("and r.capacity > 0");
        this.newline(sb, 12);
        sb.append("group by om.event_id");
        this.newline(sb, 12);
        sb.append(")");
        this.newline(sb, 8);
        sb.append("else");
        this.newline(sb, 12);
        sb.append("1");
        this.newline(sb, 8);
        sb.append("end");
        this.newline(sb, 8);
        sb.append(") as room_proration");
        return sb.toString();
    }

    @Override
    protected String getBaseQueryAdditionalSelectColumns() {
        StringBuffer sb = new StringBuffer();
        this.newline(sb, 4);
        sb.append("( ").append(this.getSeatsUsedCaseStatement()).append(" ) as ").append(MESSAGES.utilSqlStationsUsed()).append(",");
        this.newline(sb, 4);
        sb.append("( ").append(this.getSeatsRequestedCaseStatement()).append(" ) as ").append(MESSAGES.utilSqlStationsRequested()).append(",");
        this.newline(sb, 4);
        sb.append("m.uniqueId as meeting_id,");
        this.newline(sb, 4);
        sb.append(this.getRoomProration()).append(",");
        return sb.toString();
    }

    @Override
    public String getPivotedQuery(ArrayList<Integer> allDays, ArrayList<Integer> weekDays, Integer saturday, String campus, String year, String term, ArrayList<Object> headerRow, boolean includeDayOfWkTimeOfDayInHeaderRow, boolean includeSubjectArea, boolean includeDept, boolean includeSection, boolean includeRoomControlingDepartment) {
        return this.getPivotedBaseSummaryQuery(allDays, weekDays, saturday, campus, year, term, headerRow, includeDayOfWkTimeOfDayInHeaderRow, includeSubjectArea, includeDept, includeSection, includeRoomControlingDepartment);
    }

    @Override
    protected ArrayList<RoomSummaryReportsHelper.LabelFieldPair> getLabelPrefixToAdditionalQueryFieldMapping() {
        ArrayList<RoomSummaryReportsHelper.LabelFieldPair> mapping = new ArrayList<RoomSummaryReportsHelper.LabelFieldPair>();
        mapping.add(new RoomSummaryReportsHelper.LabelFieldPair(this, MESSAGES.utilSqlStationsUsed(), MESSAGES.utilSqlStationsUsed()));
        mapping.add(new RoomSummaryReportsHelper.LabelFieldPair(this, MESSAGES.utilSqlStationsRequested(), MESSAGES.utilSqlStationsRequested()));
        return mapping;
    }

    @Override
    protected void addSumStatementToStringBuffer(StringBuffer sb, String sum, String label, boolean leadingComma) {
        if (leadingComma) {
            sb.append(",");
        }
        this.newline(sb, 8);
        sb.append(sum);
        this.newline(sb, 8);
        sb.append(" as ").append(label);
    }
}

