/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.ui;

import java.io.Serializable;
import org.cpsolver.coursett.constraint.FlexibleConstraint;
import org.cpsolver.coursett.constraint.GroupConstraint;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.ifs.assignment.Assignment;
import org.dom4j.Element;
import org.unitime.timetable.solver.ui.TimetableInfo;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.Formats;

public class GroupConstraintInfo
implements TimetableInfo,
Serializable {
    private static final long serialVersionUID = 1L;
    public static int sVersion = 1;
    public String iPreference = "0";
    public boolean iIsSatisfied = false;
    public String iName = null;
    public String iType = null;

    public GroupConstraintInfo() {
    }

    public GroupConstraintInfo(Assignment<Lecture, Placement> assignment, GroupConstraint gc) {
        this.setPreference(gc.getPrologPreference());
        this.setIsSatisfied(gc.isSatisfied(assignment));
        this.setName(gc.getName());
    }

    public GroupConstraintInfo(Assignment<Lecture, Placement> assignment, FlexibleConstraint gc) {
        this.setPreference(gc.getPrologPreference());
        double preference = ((FlexibleConstraint.FlexibleConstraintContext)gc.getContext(assignment)).getPreference();
        this.setIsSatisfied(gc.isHard() || preference <= 0.0);
        this.setName(gc.getName() + (String)(preference <= 0.0 ? "" : " (penalty: " + Formats.getNumberFormat("0.###").format(preference / (double)Math.abs(Constants.preference2preferenceLevel((String)gc.getPrologPreference()))) + ")"));
    }

    public String getPreference() {
        return this.iPreference;
    }

    public void setPreference(String preference) {
        this.iPreference = preference;
    }

    public boolean isSatisfied() {
        return this.iIsSatisfied;
    }

    public void setIsSatisfied(boolean isSatisfied) {
        this.iIsSatisfied = isSatisfied;
    }

    public String getName() {
        return this.iName;
    }

    public void setName(String name) {
        this.iName = name;
    }

    public String getType() {
        return this.iType;
    }

    public void setType(String type) {
        this.iType = type;
    }

    @Override
    public void load(Element root) {
        int version = Integer.parseInt(root.attributeValue("version"));
        if (version == 1) {
            if (root.element("name") != null) {
                this.iName = root.element("name").getText();
            }
            this.iPreference = root.element("pref").getText();
            this.iIsSatisfied = Boolean.valueOf(root.element("isSatisfied").getText());
            this.iType = root.elementText("type");
        }
    }

    @Override
    public void save(Element root) {
        root.addAttribute("version", String.valueOf(sVersion));
        if (this.iName != null) {
            root.addElement("name").setText(this.iName);
        }
        root.addElement("pref").setText(this.iPreference);
        if (this.iType != null) {
            root.addElement("type").setText(this.iType);
        }
        root.addElement("isSatisfied").setText(String.valueOf(this.iIsSatisfied));
    }

    @Override
    public boolean saveToFile() {
        return false;
    }
}

