/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.exam;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.Configurator;
import org.cpsolver.exam.Test;
import org.cpsolver.exam.model.Exam;
import org.cpsolver.exam.model.ExamPlacement;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.DefaultSingleAssignment;
import org.cpsolver.ifs.model.Model;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solution.SolutionListener;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.Progress;
import org.cpsolver.ifs.util.ProgressListener;
import org.cpsolver.ifs.util.ProgressWriter;
import org.cpsolver.ifs.util.ToolBox;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.timetable.solver.exam.ExamDatabaseLoader;
import org.unitime.timetable.solver.exam.ExamDatabaseSaver;
import org.unitime.timetable.solver.exam.ExamModel;

public class ExamTest {
    private static Log sLog = LogFactory.getLog(ExamTest.class);

    public static void main(String[] args) {
        try {
            DataProperties cfg = new DataProperties();
            if (args.length >= 1) {
                cfg.load((InputStream)new FileInputStream(args[0]));
            }
            cfg.putAll((Map)System.getProperties());
            if (args.length >= 2) {
                File logFile = new File(ToolBox.configureLogging((String)args[1], (Properties)cfg, (boolean)true, (boolean)false));
                cfg.setProperty("General.Output", logFile.getParentFile().getAbsolutePath());
            } else {
                ToolBox.configureLogging();
                cfg.setProperty("General.Output", System.getProperty("user.home", ".") + File.separator + "Exam-Test");
            }
            if (!"true".equals(System.getProperty("debug", "false"))) {
                Configurator.setRootLevel((Level)Level.INFO);
            } else {
                Configurator.setRootLevel((Level)Level.DEBUG);
            }
            HibernateUtil.configureHibernate((Properties)cfg);
            ExamModel model = new ExamModel(cfg);
            DefaultSingleAssignment assignment = new DefaultSingleAssignment();
            Progress.getInstance((Object)((Object)model)).addProgressListener((ProgressListener)new ProgressWriter(System.out));
            try {
                new ExamDatabaseLoader(model, (Assignment<Exam, ExamPlacement>)assignment).load();
            }
            catch (Exception e) {
                sLog.error((Object)("Unable to load problem, reason: " + e.getMessage()), (Throwable)e);
                return;
            }
            Solver solver = new Solver(cfg);
            solver.setInitalSolution(new Solution((Model)model, (Assignment)assignment));
            solver.currentSolution().addSolutionListener(new SolutionListener(){

                public void solutionUpdated(Solution solution) {
                }

                public void getInfo(Solution solution, Map info) {
                }

                public void getInfo(Solution solution, Map info, Collection variables) {
                }

                public void bestCleared(Solution solution) {
                }

                public void bestSaved(Solution solution) {
                    ExamModel m = (ExamModel)solution.getModel();
                    Assignment a = solution.getAssignment();
                    if (sLog.isInfoEnabled()) {
                        sLog.info((Object)("**BEST[" + solution.getIteration() + "]** " + (String)(m.nrUnassignedVariables(a) > 0 ? "V:" + m.nrAssignedVariables(a) + "/" + m.variables().size() + " - " : "") + "T:" + new DecimalFormat("0.00").format(m.getTotalValue(a)) + " (" + String.valueOf((Object)m) + ")"));
                    }
                }

                public void bestRestored(Solution solution) {
                }
            });
            Runtime.getRuntime().addShutdownHook(new ShutdownHook(solver));
            solver.start();
            try {
                solver.getSolverThread().join();
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
    }

    public static class ShutdownHook
    extends Thread {
        Solver iSolver = null;

        public ShutdownHook(Solver solver) {
            this.setName("ShutdownHook");
            this.iSolver = solver;
        }

        @Override
        public void run() {
            try {
                Solution solution;
                if (this.iSolver.isRunning()) {
                    this.iSolver.stopSolver();
                }
                if ((solution = this.iSolver.lastSolution()).getBestInfo() == null) {
                    sLog.error((Object)"No best solution found.");
                } else {
                    solution.restoreBest();
                }
                sLog.info((Object)("Best solution:" + ToolBox.dict2string((Map)solution.getExtendedInfo(), (int)1)));
                sLog.info((Object)("Best solution found after " + solution.getBestTime() + " seconds (" + solution.getBestIteration() + " iterations)."));
                sLog.info((Object)("Number of assigned variables is " + solution.getModel().nrAssignedVariables(solution.getAssignment())));
                sLog.info((Object)("Total value of the solution is " + solution.getModel().getTotalValue(solution.getAssignment())));
                if (this.iSolver.getProperties().getPropertyBoolean("General.Save", false)) {
                    new ExamDatabaseSaver(this.iSolver).save();
                }
                File outFile = new File(this.iSolver.getProperties().getProperty("General.OutputFile", this.iSolver.getProperties().getProperty("General.Output") + File.separator + "solution.xml"));
                FileOutputStream fos = new FileOutputStream(outFile);
                new XMLWriter((OutputStream)fos, OutputFormat.createPrettyPrint()).write(((ExamModel)solution.getModel()).save((Assignment<Exam, ExamPlacement>)solution.getAssignment()));
                fos.flush();
                fos.close();
                Test.createReports((org.cpsolver.exam.model.ExamModel)((ExamModel)solution.getModel()), (Assignment)solution.getAssignment(), (File)outFile.getParentFile(), (String)outFile.getName().substring(0, outFile.getName().lastIndexOf(46)));
                Progress.removeInstance((Object)solution.getModel());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

