/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.curricula.students;

import java.util.ArrayList;
import java.util.Set;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.GlobalConstraint;
import org.cpsolver.ifs.util.ToolBox;
import org.unitime.timetable.solver.curricula.students.CurCourse;
import org.unitime.timetable.solver.curricula.students.CurValue;
import org.unitime.timetable.solver.curricula.students.CurVariable;

public class CurStudentLimit
extends GlobalConstraint<CurVariable, CurValue> {
    private int iMinLimit = 0;
    private int iMaxLimit = 0;

    public CurStudentLimit(int minLimit, int maxLimit) {
        this.iMinLimit = minLimit;
        this.iMaxLimit = maxLimit;
    }

    public int getMinLimit() {
        return this.iMinLimit;
    }

    public int getMaxLimit() {
        return this.iMaxLimit;
    }

    public void computeConflicts(Assignment<CurVariable, CurValue> assignment, CurValue value, Set<CurValue> conflicts) {
        Set<CurCourse> courses = value.getStudent().getCourses(assignment);
        int nrCourses = courses.size();
        if (!courses.contains((Object)((CurVariable)value.variable()).getCourse())) {
            ++nrCourses;
        }
        for (CurValue conflict : conflicts) {
            if (!((Object)((Object)conflict.getStudent())).equals((Object)value.getStudent()) || !courses.contains((Object)((CurVariable)conflict.variable()).getCourse())) continue;
            --nrCourses;
        }
        if (nrCourses > this.iMaxLimit) {
            ArrayList<CurValue> adepts = new ArrayList<CurValue>();
            for (CurCourse course : courses) {
                CurValue adept;
                if (course.equals((Object)((CurVariable)value.variable()).getCourse()) || conflicts.contains((Object)(adept = course.getValue(assignment, value.getStudent())))) continue;
                adepts.add(adept);
            }
            conflicts.add((CurValue)((Object)ToolBox.random(adepts)));
            --nrCourses;
        }
    }

    public String toString() {
        return "StudentLimit<" + this.getMinLimit() + "," + this.getMaxLimit() + ">";
    }
}

