/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.unitime.timetable.interfaces.RoomAvailabilityInterface;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.solver.ClassAssignmentProxy;
import org.unitime.timetable.solver.ui.AssignmentPreferenceInfo;

public class CachedClassAssignmentProxy
implements ClassAssignmentProxy {
    private static Object sNULL = Boolean.FALSE;
    private ClassAssignmentProxy iProxy;
    private Map<Long, Object> iAssignmentTable = new HashMap<Long, Object>();
    private Map<Long, Object> iAssignmentInfoTable = new HashMap<Long, Object>();

    public CachedClassAssignmentProxy(ClassAssignmentProxy proxy) {
        this.iProxy = proxy;
    }

    @Override
    public ClassAssignmentProxy.AssignmentInfo getAssignment(Long classId) {
        Object cached = this.iAssignmentTable.get(classId);
        if (cached != null) {
            return sNULL.equals(cached) ? null : (ClassAssignmentProxy.AssignmentInfo)cached;
        }
        ClassAssignmentProxy.AssignmentInfo assignment = this.iProxy.getAssignment(classId);
        this.iAssignmentTable.put(classId, assignment == null ? sNULL : assignment);
        return assignment;
    }

    @Override
    public ClassAssignmentProxy.AssignmentInfo getAssignment(Class_ clazz) {
        Object cached = this.iAssignmentTable.get(clazz.getUniqueId());
        if (cached != null) {
            return sNULL.equals(cached) ? null : (ClassAssignmentProxy.AssignmentInfo)cached;
        }
        ClassAssignmentProxy.AssignmentInfo assignment = this.iProxy.getAssignment(clazz);
        this.iAssignmentTable.put(clazz.getUniqueId(), assignment == null ? sNULL : assignment);
        return assignment;
    }

    @Override
    public AssignmentPreferenceInfo getAssignmentInfo(Long classId) {
        Object cached = this.iAssignmentInfoTable.get(classId);
        if (cached != null) {
            return sNULL.equals(cached) ? null : (AssignmentPreferenceInfo)cached;
        }
        AssignmentPreferenceInfo info = this.iProxy.getAssignmentInfo(classId);
        this.iAssignmentInfoTable.put(classId, info == null ? sNULL : info);
        return info;
    }

    @Override
    public AssignmentPreferenceInfo getAssignmentInfo(Class_ clazz) {
        Object cached = this.iAssignmentInfoTable.get(clazz.getUniqueId());
        if (cached != null) {
            return sNULL.equals(cached) ? null : (AssignmentPreferenceInfo)cached;
        }
        AssignmentPreferenceInfo info = this.iProxy.getAssignmentInfo(clazz);
        this.iAssignmentInfoTable.put(clazz.getUniqueId(), info == null ? sNULL : info);
        return info;
    }

    @Override
    public Map<Long, ClassAssignmentProxy.AssignmentInfo> getAssignmentTable(Collection classesOrClassIds) {
        HashMap<Long, ClassAssignmentProxy.AssignmentInfo> assignments = new HashMap<Long, ClassAssignmentProxy.AssignmentInfo>();
        ArrayList unknown = new ArrayList();
        for (Object classOrClassId : classesOrClassIds) {
            Long classId;
            Object cached;
            if (classOrClassId instanceof Object[]) {
                classOrClassId = ((Object[])classOrClassId)[0];
            }
            if ((cached = this.iAssignmentTable.get(classId = classOrClassId instanceof Class_ ? ((Class_)classOrClassId).getUniqueId() : (Long)classOrClassId)) != null) {
                if (sNULL.equals(cached)) continue;
                assignments.put(classId, (ClassAssignmentProxy.AssignmentInfo)cached);
                continue;
            }
            unknown.add(classOrClassId);
        }
        Map<Long, ClassAssignmentProxy.AssignmentInfo> newAssignments = this.iProxy.getAssignmentTable(unknown);
        for (Object classOrClassId : unknown) {
            if (classOrClassId instanceof Object[]) {
                classOrClassId = ((Object[])classOrClassId)[0];
            }
            Long classId = classOrClassId instanceof Class_ ? ((Class_)classOrClassId).getUniqueId() : (Long)classOrClassId;
            ClassAssignmentProxy.AssignmentInfo assignment = newAssignments.get(classId);
            this.iAssignmentTable.put(classId, assignment == null ? sNULL : assignment);
            if (assignment == null) continue;
            assignments.put(classId, assignment);
        }
        return assignments;
    }

    @Override
    public Map<Long, AssignmentPreferenceInfo> getAssignmentInfoTable(Collection classesOrClassIds) {
        HashMap<Long, AssignmentPreferenceInfo> infos = new HashMap<Long, AssignmentPreferenceInfo>();
        ArrayList unknown = new ArrayList();
        for (Object classOrClassId : classesOrClassIds) {
            Long classId;
            Object cached;
            if (classOrClassId instanceof Object[]) {
                classOrClassId = ((Object[])classOrClassId)[0];
            }
            if ((cached = this.iAssignmentInfoTable.get(classId = classOrClassId instanceof Class_ ? ((Class_)classOrClassId).getUniqueId() : (Long)classOrClassId)) != null) {
                if (sNULL.equals(cached)) continue;
                infos.put(classId, (AssignmentPreferenceInfo)cached);
                continue;
            }
            unknown.add(classOrClassId);
        }
        Map<Long, AssignmentPreferenceInfo> newInfos = this.iProxy.getAssignmentInfoTable(unknown);
        for (Object classOrClassId : unknown) {
            if (classOrClassId instanceof Object[]) {
                classOrClassId = ((Object[])classOrClassId)[0];
            }
            Long classId = classOrClassId instanceof Class_ ? ((Class_)classOrClassId).getUniqueId() : (Long)classOrClassId;
            AssignmentPreferenceInfo info = newInfos.get(classId);
            this.iAssignmentInfoTable.put(classId, info == null ? sNULL : info);
            if (info == null) continue;
            infos.put(classId, info);
        }
        return infos;
    }

    public void setCache(Collection classesOrClassIds) {
        Map<Long, ClassAssignmentProxy.AssignmentInfo> newAssignments = this.iProxy.getAssignmentTable(classesOrClassIds);
        Map<Long, AssignmentPreferenceInfo> newInfos = this.iProxy.getAssignmentInfoTable(classesOrClassIds);
        for (Object classOrClassId : classesOrClassIds) {
            if (classOrClassId instanceof Object[]) {
                classOrClassId = ((Object[])classOrClassId)[0];
            }
            Long classId = classOrClassId instanceof Class_ ? ((Class_)classOrClassId).getUniqueId() : (Long)classOrClassId;
            ClassAssignmentProxy.AssignmentInfo assignment = newAssignments.get(classId);
            this.iAssignmentTable.put(classId, assignment == null ? sNULL : assignment);
            AssignmentPreferenceInfo info = newInfos.get(classId);
            this.iAssignmentInfoTable.put(classId, info == null ? sNULL : info);
        }
    }

    @Override
    public boolean hasConflicts(Long offeringId) {
        return this.iProxy.hasConflicts(offeringId);
    }

    @Override
    public Set<ClassAssignmentProxy.AssignmentInfo> getConflicts(Long classId) {
        return this.iProxy.getConflicts(classId);
    }

    @Override
    public Set<RoomAvailabilityInterface.TimeBlock> getConflictingTimeBlocks(Long classId) {
        return this.iProxy.getConflictingTimeBlocks(classId);
    }
}

