/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.solver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.RoomLocation;
import org.cpsolver.coursett.model.TimeLocation;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.gwt.shared.SuggestionsInterface;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.FilterBoxBackend;
import org.unitime.timetable.solver.SolverProxy;
import org.unitime.timetable.solver.service.SolverService;
import org.unitime.timetable.util.Constants;

@GwtRpcImplements(value=SuggestionsInterface.SuggestionsFilterRpcRequest.class)
public class SuggestionsFilterBackend
extends FilterBoxBackend<SuggestionsInterface.SuggestionsFilterRpcRequest> {
    protected static GwtConstants CONSTANTS = Localization.create(GwtConstants.class);
    protected static GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    @Autowired
    SolverService<SolverProxy> courseTimetablingSolverService;

    @Override
    public EventInterface.FilterRpcResponse execute(SuggestionsInterface.SuggestionsFilterRpcRequest request, SessionContext context) {
        context.checkPermission(Right.Suggestions);
        return super.execute(request, context);
    }

    @Override
    public void load(SuggestionsInterface.SuggestionsFilterRpcRequest request, EventInterface.FilterRpcResponse response, SessionContext context) {
        Map<String, Collection<EventInterface.FilterRpcResponse.Entity>> entities;
        SolverProxy solver;
        if (request.getClassId() != null && (solver = this.courseTimetablingSolverService.getSolver()) != null && (entities = solver.loadSuggestionFilter(request.getClassId())) != null) {
            for (Map.Entry<String, Collection<EventInterface.FilterRpcResponse.Entity>> entry : entities.entrySet()) {
                response.add(entry.getKey(), entry.getValue());
            }
        }
    }

    public static String getDaysName(int days) {
        Object ret = "";
        for (SuggestionsInterface.DayCode dc : SuggestionsInterface.DayCode.values()) {
            if ((dc.getCode() & days) == 0) continue;
            ret = (String)ret + CONSTANTS.shortDays()[dc.ordinal()];
        }
        return ret;
    }

    public static String slot2time(int timeSinceMidnight, boolean useAmPm) {
        int hour = timeSinceMidnight / 60;
        int min = timeSinceMidnight % 60;
        if (useAmPm) {
            return (hour == 0 ? 12 : (hour > 12 ? hour - 12 : hour)) + ":" + (min < 10 ? "0" : "") + min + (hour < 24 && hour >= 12 ? "p" : "a");
        }
        return hour + ":" + (min < 10 ? "0" : "") + min;
    }

    public static Map<String, Collection<EventInterface.FilterRpcResponse.Entity>> load(Lecture lecture) {
        HashMap<String, Collection<EventInterface.FilterRpcResponse.Entity>> entities = new HashMap<String, Collection<EventInterface.FilterRpcResponse.Entity>>();
        if (lecture.getNrRooms() > 0 && lecture.roomLocations() != null) {
            ArrayList<EventInterface.FilterRpcResponse.Entity> rooms = new ArrayList<EventInterface.FilterRpcResponse.Entity>();
            for (RoomLocation r : lecture.roomLocations()) {
                if (r.getMinPreference() > 500) continue;
                EventInterface.FilterRpcResponse.Entity e = new EventInterface.FilterRpcResponse.Entity(r.getId(), r.getName(), r.getName(), new String[0]);
                e.setCount(r.getRoomSize());
                rooms.add(e);
            }
            entities.put("room", rooms);
        }
        int allDays = 0;
        int firstDay = ApplicationProperty.TimePatternFirstDayOfWeek.intValue();
        if (lecture.timeLocations() != null) {
            TreeSet<EventInterface.FilterRpcResponse.Entity> times = new TreeSet<EventInterface.FilterRpcResponse.Entity>();
            TreeSet<EventInterface.FilterRpcResponse.Entity> dates = new TreeSet<EventInterface.FilterRpcResponse.Entity>();
            for (TimeLocation t : lecture.timeLocations()) {
                if (t.getPreference() > 500) continue;
                dates.add(new EventInterface.FilterRpcResponse.Entity(t.getDatePatternId(), t.getDatePatternName(), t.getDatePatternName(), new String[0]));
                int days = t.getDayCode();
                if (firstDay != 0) {
                    days = t.getDayCode() << firstDay;
                    days = (days & 0x7F) + (days >> 7);
                }
                times.add(new EventInterface.FilterRpcResponse.Entity(Long.valueOf(-(Constants.sDayCode2Order[days] << 7) - t.getStartSlot()), SuggestionsFilterBackend.getDaysName(t.getDayCode()) + " " + t.getStartTimeHeader(CONSTANTS.useAmPm()), SuggestionsFilterBackend.getDaysName(t.getDayCode()) + " " + t.getStartTimeHeader(CONSTANTS.useAmPm()) + " - " + t.getEndTimeHeader(CONSTANTS.useAmPm()), new String[0]));
                allDays |= t.getDayCode();
            }
            entities.put("date", dates);
            entities.put("time", times);
        }
        TreeSet<EventInterface.FilterRpcResponse.Entity> daysOfWeek = new TreeSet<EventInterface.FilterRpcResponse.Entity>();
        for (int i = 0; i < Constants.DAY_CODES.length; ++i) {
            if ((allDays & Constants.DAY_CODES[i]) == 0) continue;
            EventInterface.FilterRpcResponse.Entity e = new EventInterface.FilterRpcResponse.Entity(Long.valueOf(i), Constants.DAY_NAMES_FULL[i], CONSTANTS.longDays()[i], "translated-value", CONSTANTS.longDays()[i]);
            e.setProperty("order", String.valueOf((7 + i - firstDay) % 7));
            daysOfWeek.add(e);
        }
        entities.put("day", daysOfWeek);
        ArrayList<EventInterface.FilterRpcResponse.Entity> flags = new ArrayList<EventInterface.FilterRpcResponse.Entity>();
        flags.add(new EventInterface.FilterRpcResponse.Entity(1L, "Same Room", MESSAGES.suggestionsSameRoom(), "translated-value", MESSAGES.suggestionsSameRoom()));
        flags.add(new EventInterface.FilterRpcResponse.Entity(2L, "Same Time", MESSAGES.suggestionsSameTime(), "translated-value", MESSAGES.suggestionsSameTime()));
        flags.add(new EventInterface.FilterRpcResponse.Entity(3L, "Allow Break Hard", MESSAGES.suggestionsAllowBreakHard(), "translated-value", MESSAGES.suggestionsAllowBreakHard()));
        entities.put("flag", flags);
        ArrayList<EventInterface.FilterRpcResponse.Entity> modes = new ArrayList<EventInterface.FilterRpcResponse.Entity>();
        modes.add(new EventInterface.FilterRpcResponse.Entity(1L, "Suggestions", MESSAGES.suggestionsSuggestions(), "translated-value", MESSAGES.suggestionsSuggestions()));
        modes.add(new EventInterface.FilterRpcResponse.Entity(2L, "Placements", MESSAGES.suggestionsPlacements(), "translated-value", MESSAGES.suggestionsPlacements()));
        entities.put("mode", modes);
        return entities;
    }

    @Override
    public void suggestions(SuggestionsInterface.SuggestionsFilterRpcRequest request, EventInterface.FilterRpcResponse response, SessionContext context) {
    }

    @Override
    public void enumarate(SuggestionsInterface.SuggestionsFilterRpcRequest request, EventInterface.FilterRpcResponse response, SessionContext context) {
    }
}

