/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.solver;

import org.springframework.beans.factory.annotation.Autowired;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.shared.SuggestionsInterface;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.solver.SolverProxy;
import org.unitime.timetable.solver.TimetableSolver;
import org.unitime.timetable.solver.interactive.Hint;
import org.unitime.timetable.solver.service.SolverService;
import org.unitime.timetable.util.Constants;

@GwtRpcImplements(value=SuggestionsInterface.SuggestionPropertiesRequest.class)
public class SuggestionPropertiesBackend
implements GwtRpcImplementation<SuggestionsInterface.SuggestionPropertiesRequest, SuggestionsInterface.SuggestionProperties> {
    @Autowired
    SolverService<SolverProxy> courseTimetablingSolverService;

    @Override
    public SuggestionsInterface.SuggestionProperties execute(SuggestionsInterface.SuggestionPropertiesRequest request, SessionContext context) {
        SuggestionsInterface.SuggestionProperties response = new SuggestionsInterface.SuggestionProperties();
        for (PreferenceLevel pref : PreferenceLevel.getPreferenceLevelList(false)) {
            response.addPreference(new SuggestionsInterface.PreferenceInterface(pref.getUniqueId(), PreferenceLevel.prolog2color(pref.getPrefProlog()), pref.getPrefProlog(), pref.getPrefName(), pref.getAbbreviation(), Constants.preference2preferenceLevel((String)pref.getPrefProlog())));
        }
        response.setSolver(this.courseTimetablingSolverService.getSolver() != null);
        response.setFirstDay(ApplicationProperty.TimePatternFirstDayOfWeek.intValue());
        if (request.getHistoryId() != null) {
            try {
                SolverProxy solver = this.courseTimetablingSolverService.getSolver();
                if (solver != null) {
                    TimetableSolver.AssignmentRecord record = solver.getAssignmentRecords().get((int)request.getHistoryId().longValue());
                    for (TimetableSolver.RecordedAssignment assignment : record.getAssignments()) {
                        if (assignment.getBefore() == null) continue;
                        Hint before = assignment.getBefore();
                        response.addSelectedAssignment(new SuggestionsInterface.SelectedAssignment(before.getClassId(), before.getDays(), before.getStartSlot(), before.getRoomIds(), before.getPatternId(), before.getDatePatternId()));
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return response;
    }
}

