/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.sectioning;

import java.io.IOException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import org.cpsolver.ifs.util.CSVFile;
import org.cpsolver.ifs.util.DataProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.export.CSVPrinter;
import org.unitime.timetable.export.ExportHelper;
import org.unitime.timetable.export.Exporter;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.basic.GenerateSectioningReport;
import org.unitime.timetable.security.Qualifiable;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.service.SolverServerService;
import org.unitime.timetable.solver.service.StudentSectioningSolverService;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.DateUtils;

@Service(value="org.unitime.timetable.export.Exporter:sct-report.csv")
public class SectioningReportsExporter
implements Exporter {
    protected static GwtConstants CONSTANTS = Localization.create(GwtConstants.class);
    @Autowired
    StudentSectioningSolverService studentSectioningSolverService;
    @Autowired
    SolverServerService solverServerService;

    @Override
    public String reference() {
        return "sct-report.csv";
    }

    protected Exporter.Printer getPrinter(ExportHelper helper) throws IOException {
        CSVPrinter out = new CSVPrinter(helper, false);
        helper.setup(out.getContentType(), helper.getParameter("name").toLowerCase().replace('_', '-') + ".csv", false);
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void export(ExportHelper helper) throws IOException {
        DataProperties parameters = new DataProperties();
        parameters.put((Object)"dateformat", (Object)CONSTANTS.timeStampFormat());
        Enumeration<String> e = helper.getParameterNames();
        while (e.hasMoreElements()) {
            String name = e.nextElement();
            parameters.put((Object)name, (Object)helper.getParameter(name));
        }
        parameters.put((Object)"useAmPm", (Object)(CONSTANTS.useAmPm() ? "true" : "false"));
        parameters.setProperty("user", helper.getSessionContext().getUser().getExternalUserId());
        Long sessionId = helper.getAcademicSessionId();
        if (sessionId == null && helper.getSessionContext().isAuthenticated()) {
            sessionId = helper.getSessionContext().getUser().getCurrentAcademicSessionId();
        }
        if (sessionId == null) {
            throw new GwtRpcException("No academic session provided.");
        }
        Session session = (Session)SessionDAO.getInstance().get(sessionId);
        if (session != null) {
            parameters.setProperty("DatePattern.DayOfWeekOffset", String.valueOf(Constants.getDayOfWeek(DateUtils.getDate(1, session.getPatternStartMonth(), session.getSessionStartYear()))));
        }
        CSVFile csv = null;
        String online = helper.getParameter("online");
        SessionContext context = helper.getSessionContext();
        DataProperties config = null;
        if (online == null) {
            if (!context.hasPermission(Right.StudentSectioningSolverReports)) {
                context.checkPermission(Right.StudentSectioningSolver);
            }
            if ((solver = this.studentSectioningSolverService.getSolver("PUBLISHED_" + sessionId, sessionId)) == null) {
                throw new GwtRpcException("No student solver is published.");
            }
            csv = solver.getReport(parameters);
            config = solver.getConfig();
        } else if ("1".equals(online) || "true".equalsIgnoreCase(online) || "on".equalsIgnoreCase(online)) {
            context.checkPermissionAnyAuthority(sessionId, "Session", Right.SchedulingReports, new Qualifiable[0]);
            OnlineSectioningServer server = this.solverServerService.getOnlineStudentSchedulingContainer().getSolver(sessionId.toString());
            if (server == null) {
                throw new GwtRpcException("Online student scheduling is not enabled for session " + sessionId + ".");
            }
            OnlineSectioningLog.Entity user = OnlineSectioningLog.Entity.newBuilder().setExternalId(context.getUser().getExternalUserId()).setName(context.getUser().getName() == null ? context.getUser().getUsername() : context.getUser().getName()).setType(context.hasPermission(Right.StudentSchedulingAdvisor) ? OnlineSectioningLog.Entity.EntityType.MANAGER : OnlineSectioningLog.Entity.EntityType.STUDENT).build();
            csv = server.execute(server.createAction(GenerateSectioningReport.class).withParameters((Properties)parameters), user);
        } else if (!sessionId.equals(context.getUser().getCurrentAcademicSessionId())) {
            context.checkPermissionAnyAuthority(sessionId, "Session", Right.StudentSectioningSolver, new Qualifiable[0]);
            solver = this.studentSectioningSolverService.getSolver(context.getUser().getExternalUserId(), sessionId);
            if (solver == null) {
                throw new GwtRpcException("No student solver is running.");
            }
            csv = solver.getReport(parameters);
        } else {
            if (!context.hasPermissionAnyAuthority(sessionId, "Session", Right.StudentSectioningSolverReports, new Qualifiable[0])) {
                context.checkPermissionAnyAuthority(sessionId, "Session", Right.StudentSectioningSolver, new Qualifiable[0]);
            }
            if ((solver = this.studentSectioningSolverService.getSolver()) == null) {
                throw new GwtRpcException("No student solver is running.");
            }
            csv = solver.getReport(parameters);
        }
        if (csv == null) {
            throw new GwtRpcException("No report was created.");
        }
        Exporter.Printer out = this.getPrinter(helper);
        if (config != null) {
            String term = config.getProperty("Data.Term");
            String year = config.getProperty("Data.Year");
            String initiative = config.getProperty("Data.Initiative");
            Object sessionLabel = "";
            if (term != null && year != null && initiative != null) {
                sessionLabel = term + year + initiative;
            } else if (session != null) {
                sessionLabel = session.getReference();
            }
            SimpleDateFormat df = new SimpleDateFormat(parameters.getProperty("dateformat", "MM/dd/yyyy hh:mmaa"));
            Long startTimeStamp = config.getPropertyLong("General.StartTime", null);
            String started = startTimeStamp == null ? null : df.format(new Date(startTimeStamp));
            Long publishTimeStamp = config.getPropertyLong("StudentSct.Published", null);
            String published = publishTimeStamp == null ? null : df.format(new Date(publishTimeStamp));
            String publishId = config.getProperty("StudentSct.PublishId");
            out.printLine("Id", "Term", "Started", "Published");
            out.printLine(new String[]{publishId, sessionLabel, started, published});
            out.printLine(new String[0]);
        }
        CSVFile cSVFile = csv;
        synchronized (cSVFile) {
            String sort;
            String[] header = new String[csv.getHeader().getFields().size()];
            for (int i = 0; i < csv.getHeader().getFields().size(); ++i) {
                header[i] = csv.getHeader().getField(i).toString();
            }
            if (header.length >= 1 && header[0].startsWith("__")) {
                out.hideColumn(0);
            }
            out.printHeader(header);
            DecimalFormat pf = new DecimalFormat("0.00%");
            ArrayList<Row> rows = new ArrayList<Row>();
            Row prev = null;
            if (csv.getLines() != null) {
                for (CSVFile.CSVLine line : csv.getLines()) {
                    if (line.getFields().isEmpty()) continue;
                    Row data = new Row(line);
                    while (prev != null && data.getNrBlanks() <= prev.getNrBlanks()) {
                        prev = prev.getParent();
                    }
                    if (prev != null) {
                        data.setParent(prev);
                    }
                    rows.add(data);
                    prev = data;
                }
            }
            if ((sort = helper.getParameter("sort")) != null && !"0".equals(sort)) {
                final boolean asc = Integer.parseInt(sort) > 0;
                final int col = Math.abs(Integer.parseInt(sort)) - 1;
                Collections.sort(rows, new Comparator<Row>(){

                    @Override
                    public int compare(Row o1, Row o2) {
                        return asc ? o1.compareTo(o2, col) : o2.compareTo(o1, col);
                    }
                });
            }
            if (!"true".equalsIgnoreCase(helper.getParameter("pritify"))) {
                for (Row row : rows) {
                    String[] line = new String[csv.getHeader().size()];
                    for (int x = 0; x < csv.getHeader().size(); ++x) {
                        line[x] = row.getCell(x);
                    }
                    out.printLine(line);
                }
            } else {
                prev = null;
                for (Row row : rows) {
                    boolean prevHide = true;
                    String[] line = new String[csv.getHeader().size()];
                    for (int x = 0; x < csv.getHeader().size(); ++x) {
                        boolean hide = true;
                        if (prev == null || !prevHide || !prev.getCell(x).equals(row.getCell(x))) {
                            hide = false;
                        }
                        String text = row.getCell(x);
                        boolean number = false;
                        if (csv.getHeader().getField(x).toString().contains("%")) {
                            if (x > 0) {
                                try {
                                    Double.parseDouble(text);
                                    number = true;
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            if (number) {
                                text = pf.format(Double.parseDouble(text));
                            }
                        }
                        line[x] = hide ? "" : text;
                        prevHide = hide;
                    }
                    if (prev != null && !prev.getCell(0).equals(row.getCell(0))) {
                        out.printLine(new String[0]);
                    }
                    out.printLine(line);
                    prev = row;
                }
            }
        }
        out.flush();
        out.close();
    }

    private static class Row {
        CSVFile.CSVLine iLine;
        Row iParent;

        public Row(CSVFile.CSVLine line) {
            this.iLine = line;
        }

        public Row getParent() {
            return this.iParent;
        }

        public void setParent(Row parent) {
            this.iParent = parent;
        }

        public boolean isBlank(int col) {
            return this.iLine.getFields().size() <= col || this.iLine.getField(col).toString().isEmpty();
        }

        public String getCell(int col) {
            if (this.isBlank(col)) {
                if (this.getParent() != null) {
                    return this.getParent().getCell(col);
                }
                return "";
            }
            return this.iLine.getField(col).toString();
        }

        public int getLevel() {
            return this.getParent() == null ? 0 : this.getParent().getLevel() + 1;
        }

        public int getLength() {
            return this.getParent() == null ? this.iLine.getFields().size() : this.getParent().getLength();
        }

        public int getNrBlanks() {
            for (int i = 0; i < this.getLength(); ++i) {
                if (this.isBlank(i)) continue;
                return i;
            }
            return this.getLength();
        }

        public int compareTo(Row b, int col) {
            int cmp;
            Row a;
            block12: {
                int cmp2;
                a = this;
                if (a.getLevel() != b.getLevel()) {
                    Row aP = a;
                    Row bP = b;
                    while (aP.getLevel() > bP.getLevel()) {
                        aP = aP.getParent();
                    }
                    while (bP.getLevel() > aP.getLevel()) {
                        bP = bP.getParent();
                    }
                    cmp = aP.compareTo(bP, col);
                    if (cmp != 0) {
                        return cmp;
                    }
                } else if (a.getParent() != null && (cmp2 = a.getParent().compareTo(b.getParent(), col)) != 0) {
                    return cmp2;
                }
                try {
                    int cmp3 = Double.valueOf(a.getCell(col) == null ? "0" : a.getCell(col)).compareTo(Double.valueOf(b.getCell(col) == null ? "0" : b.getCell(col)));
                    if (cmp3 != 0) {
                        return cmp3;
                    }
                }
                catch (NumberFormatException e) {
                    int cmp4 = (a.getCell(col) == null ? "" : a.getCell(col)).compareTo(b.getCell(col) == null ? "" : b.getCell(col));
                    if (cmp4 == 0) break block12;
                    return cmp4;
                }
            }
            for (int c = 0; c < this.getLength(); ++c) {
                try {
                    int cmp5 = Double.valueOf(a.getCell(c) == null ? "0" : a.getCell(c)).compareTo(Double.valueOf(b.getCell(c) == null ? "0" : b.getCell(c)));
                    if (cmp5 == 0) continue;
                    return cmp5;
                }
                catch (NumberFormatException e) {
                    cmp = (a.getCell(c) == null ? "" : a.getCell(c)).compareTo(b.getCell(c) == null ? "" : b.getCell(c));
                    if (cmp == 0) continue;
                    return cmp;
                }
            }
            return 0;
        }
    }
}

