/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.sectioning;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeSet;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.util.CSVFile;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Offering;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.report.AbstractStudentSectioningReport;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.model.AdvisorCourseRequest;
import org.unitime.timetable.model.CourseDemand;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.onlinesectioning.advisors.AdvisorGetCourseRequests;

public class CourseRequestAltStats
extends AbstractStudentSectioningReport {
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    DecimalFormat df = new DecimalFormat("#,##0.00");
    DecimalFormat df2 = new DecimalFormat("#,##0");
    private Map<String, Course> iCourseCacheNames;
    private Map<Long, Course> iCourseCacheIds;

    public CourseRequestAltStats(StudentSectioningModel model) {
        super(model);
    }

    private String percent(int value, int base) {
        if (base == 0) {
            return "";
        }
        return this.df.format(100.0 * (double)value / (double)base) + " %";
    }

    public CSVFile createTable(Assignment<Request, Enrollment> assignment, DataProperties properties) {
        HashMap<String, Check> counters = new HashMap<String, Check>();
        Check total = new Check();
        for (Student student : this.getModel().getStudents()) {
            Check counter;
            Object area = null;
            if (student.getPrimaryMajor() != null) {
                area = student.getPrimaryMajor().getArea();
            }
            if (area == null) {
                area = "Unkown";
            }
            if (!this.matches(student)) continue;
            Check check = new Check();
            HashSet<String> assignedCourses = new HashSet<String>();
            for (Request r : student.getRequests()) {
                Enrollment e = (Enrollment)assignment.getValue((Variable)r);
                if (!(r instanceof CourseRequest)) continue;
                if (e != null) {
                    assignedCourses.add(e.getCourse().getName());
                }
                if (!this.matches(r, e)) continue;
                CourseRequest cr = (CourseRequest)r;
                if (cr.isAlternative()) {
                    check.set("subst");
                    if (e != null) {
                        check.set("subst-assigned");
                    }
                    if (e == null) continue;
                    check.set("req-assigned", cr.getRequestPriority());
                    continue;
                }
                check.set("req", cr.getRequestPriority());
                if (e != null) {
                    check.set("req-assigned", cr.getRequestPriority());
                }
                if (!cr.isWaitlist()) {
                    check.set("subst-allow");
                }
                if (cr.getCourses().size() > 1) {
                    check.set("alt", cr.getRequestPriority());
                    if (e == null) continue;
                    check.set("alt-assigned", cr.getRequestPriority());
                    if (!((Course)cr.getCourses().get(0)).equals((Object)e.getCourse())) continue;
                    check.set("alt-assigned-1st", cr.getRequestPriority());
                    continue;
                }
                check.set("no-alt", cr.getRequestPriority());
                if (e == null) continue;
                check.set("no-alt-assigned", cr.getRequestPriority());
            }
            if (!check.is("req")) continue;
            org.unitime.timetable.model.Student dbStudent = (org.unitime.timetable.model.Student)StudentDAO.getInstance().get(student.getId());
            if (dbStudent == null && student.getExternalId() != null) {
                dbStudent = org.unitime.timetable.model.Student.findByExternalId(ApplicationProperties.getSessionId(), student.getExternalId());
            }
            if (dbStudent != null && !dbStudent.getAdvisorCourseRequests().isEmpty()) {
                CourseRequestInterface acr = new CourseRequestInterface();
                ArrayList<AdvisorCourseRequest> recommendations = new ArrayList<AdvisorCourseRequest>(dbStudent.getAdvisorCourseRequests());
                Collections.sort(recommendations);
                AdvisorGetCourseRequests.fillCourseRequests(acr, recommendations);
                check.set("advised");
                for (CourseRequestInterface.Request r : acr.getCourses()) {
                    if (!this.matches(student, r) || !r.hasRequestedCourse()) continue;
                    CourseDemand.Critical critical = CourseDemand.Critical.NORMAL;
                    if (r.hasCritical()) {
                        critical = CourseDemand.Critical.values()[r.getCritical()];
                    }
                    Request.RequestPriority rp = critical.toRequestPriority();
                    int index = 0;
                    for (CourseRequestInterface.RequestedCourse rc : r.getRequestedCourse()) {
                        if (rc.hasCourseName() && index == 0 && rc.hasCourseId()) {
                            check.set("adv-req", rp);
                            if (r.countRequestedCourses() == 1) {
                                check.set("adv-no-alt", rp);
                            } else {
                                check.set("adv-alt", rp);
                            }
                            if (!r.isNoSub()) {
                                check.set("adv-subst-allow");
                            }
                        }
                        if (rc.hasCourseName() && assignedCourses.contains(rc.getCourseName()) && rc.hasCourseId()) {
                            check.set("adv-req-assigned", rp);
                            if (r.countRequestedCourses() == 1) {
                                check.set("adv-no-alt-assigned", rp);
                            } else {
                                check.set("adv-alt-assigned", rp);
                                if (index == 0) {
                                    check.set("adv-alt-assigned-1st", rp);
                                }
                            }
                        }
                        ++index;
                    }
                }
                for (CourseRequestInterface.Request r : acr.getAlternatives()) {
                    if (!this.matches(student, r) || !r.hasRequestedCourse()) continue;
                    int index = 0;
                    for (CourseRequestInterface.RequestedCourse rc : r.getRequestedCourse()) {
                        if (rc.hasCourseName() && index == 0 && rc.hasCourseId()) {
                            check.set("adv-subst");
                        }
                        if (rc.hasCourseName() && assignedCourses.contains(rc.getCourseName()) && rc.hasCourseId()) {
                            check.set("adv-subst-assigned");
                            check.set("adv-req-assigned", Request.RequestPriority.Normal);
                        }
                        ++index;
                    }
                }
            }
            if ((counter = (Check)counters.get(area)) == null) {
                counter = new Check();
                counters.put((String)area, counter);
            }
            counter.inc("students");
            if (check.is("subst") && check.is("subst-allow")) {
                counter.inc("subst");
                if (check.is("subst-assigned")) {
                    counter.inc("subst-assigned");
                }
            }
            counter.inc("req", check);
            counter.inc("req-assigned", check);
            counter.inc("alt", check);
            counter.inc("alt-assigned", check);
            counter.inc("alt-assigned-1st", check);
            counter.inc("no-alt", check);
            counter.inc("no-alt-assigned", check);
            total.inc("students");
            if (check.is("subst") && check.is("subst-allow")) {
                total.inc("subst");
                if (check.is("subst-assigned")) {
                    total.inc("subst-assigned");
                }
            }
            total.inc("req", check);
            total.inc("req-assigned", check);
            total.inc("alt", check);
            total.inc("alt-assigned", check);
            total.inc("alt-assigned-1st", check);
            total.inc("no-alt", check);
            total.inc("no-alt-assigned", check);
            if (!check.is("advised")) continue;
            counter.inc("advised");
            if (check.is("adv-subst") && check.is("adv-subst-allow")) {
                counter.inc("adv-subst");
                if (check.is("adv-subst-assigned")) {
                    counter.inc("adv-subst-assigned");
                }
            }
            counter.inc("adv-req", check);
            counter.inc("adv-req-assigned", check);
            counter.inc("adv-alt", check);
            counter.inc("adv-alt-assigned", check);
            counter.inc("adv-alt-assigned-1st", check);
            counter.inc("adv-no-alt", check);
            counter.inc("adv-no-alt-assigned", check);
            total.inc("advised");
            if (check.is("adv-subst") && check.is("adv-subst-allow")) {
                total.inc("adv-subst");
                if (check.is("adv-subst-assigned")) {
                    total.inc("adv-subst-assigned");
                }
            }
            total.inc("adv-req", check);
            total.inc("adv-req-assigned", check);
            total.inc("adv-alt", check);
            total.inc("adv-alt-assigned", check);
            total.inc("adv-alt-assigned-1st", check);
            total.inc("adv-no-alt", check);
            total.inc("adv-no-alt-assigned", check);
        }
        CSVFile csv = new CSVFile();
        csv.setHeader(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)MSG.colArea()), new CSVFile.CSVField((Object)"Students"), new CSVFile.CSVField((Object)"Course\nRequests"), new CSVFile.CSVField((Object)"Assigned\nCourses"), new CSVFile.CSVField((Object)"Assigned\nCourses [%]"), new CSVFile.CSVField((Object)"Requests\nNo Alternatives"), new CSVFile.CSVField((Object)"No Alts\nof Courses [%]"), new CSVFile.CSVField((Object)"Assigned\nNo Alts"), new CSVFile.CSVField((Object)"Assigned\nNo Alts [%]"), new CSVFile.CSVField((Object)"Requests\nw/Alternatives"), new CSVFile.CSVField((Object)"With Alts\nof Courses [%]"), new CSVFile.CSVField((Object)"Assigned\nw/Alternatives"), new CSVFile.CSVField((Object)"Assigned\nw/Alternatives [%]"), new CSVFile.CSVField((Object)"Assigned\n1st Choice"), new CSVFile.CSVField((Object)"Assigned\n1st Choice [%]"), new CSVFile.CSVField((Object)"Students\nw/Substitutes"), new CSVFile.CSVField((Object)"Students\nw/Substitutes [%]"), new CSVFile.CSVField((Object)"Assigned\nSubstitute"), new CSVFile.CSVField((Object)"Assigned\nSubstitute [%]"), new CSVFile.CSVField((Object)"Advised\nStudents"), new CSVFile.CSVField((Object)"Advised\nStudents [%]"), new CSVFile.CSVField((Object)"Course\nRecommendations"), new CSVFile.CSVField((Object)"Assigned\nRecommendations"), new CSVFile.CSVField((Object)"Assigned\nRecommendations [%]"), new CSVFile.CSVField((Object)"Recommendations\nNo Alternatives"), new CSVFile.CSVField((Object)"No Alts\nof Recommendations [%]"), new CSVFile.CSVField((Object)"Assigned\nNo Alts"), new CSVFile.CSVField((Object)"Assigned\nNo Alts [%]"), new CSVFile.CSVField((Object)"Recommendations\nw/Alternatives"), new CSVFile.CSVField((Object)"With Alts\nof Recommendations [%]"), new CSVFile.CSVField((Object)"Assigned\nw/Alternatives"), new CSVFile.CSVField((Object)"Assigned\nw/Alternatives [%]"), new CSVFile.CSVField((Object)"Assigned\n1st Choice"), new CSVFile.CSVField((Object)"Assigned\n1st Choice [%]"), new CSVFile.CSVField((Object)"Recommended\nw/Substitutes"), new CSVFile.CSVField((Object)"Recommended\nw/Substitutes [%]"), new CSVFile.CSVField((Object)"Assigned\nSubstitute"), new CSVFile.CSVField((Object)"Assigned\nSubstitute [%]"), new CSVFile.CSVField((Object)"Vital\nCourse\nRequests"), new CSVFile.CSVField((Object)"Assigned\nVital\nCourses"), new CSVFile.CSVField((Object)"Assigned\nVital\nCourses [%]"), new CSVFile.CSVField((Object)"Requests\nVital\nNo Alternatives"), new CSVFile.CSVField((Object)"Vital\nNo Alts\nof Courses [%]"), new CSVFile.CSVField((Object)"Assigned\nVital\nNo Alts"), new CSVFile.CSVField((Object)"Assigned\nVital\nNo Alts [%]"), new CSVFile.CSVField((Object)"Vital\nRequests\nw/Alternatives"), new CSVFile.CSVField((Object)"Vital\nWith Alts\nof Courses [%]"), new CSVFile.CSVField((Object)"Assigned\nVital\nw/Alternatives"), new CSVFile.CSVField((Object)"Assigned\nVital\nw/Alternatives [%]"), new CSVFile.CSVField((Object)"Assigned\nVital\n1st Choice"), new CSVFile.CSVField((Object)"Assigned\nVital\n1st Choice [%]"), new CSVFile.CSVField((Object)"Vital\nCourse\nRecommendations"), new CSVFile.CSVField((Object)"Assigned\nVital\nRecommendations"), new CSVFile.CSVField((Object)"Assigned\nVital\nRecommendations [%]"), new CSVFile.CSVField((Object)"Vital\nRecommendations\nNo Alternatives"), new CSVFile.CSVField((Object)"Vital\nNo Alts\nof Recommendations [%]"), new CSVFile.CSVField((Object)"Assigned\nVital\nNo Alts"), new CSVFile.CSVField((Object)"Assigned\nVital\nNo Alts [%]"), new CSVFile.CSVField((Object)"Vital\nRecommendations\nw/Alternatives"), new CSVFile.CSVField((Object)"Vital\nWith Alts\nof Recommendations [%]"), new CSVFile.CSVField((Object)"Assigned\nVital\nw/Alternatives"), new CSVFile.CSVField((Object)"Assigned\nVital\nw/Alternatives [%]"), new CSVFile.CSVField((Object)"Assigned\nVital\n1st Choice"), new CSVFile.CSVField((Object)"Assigned\nVital\n1st Choice [%]")});
        TreeSet areas = new TreeSet(counters.keySet());
        for (String area : areas) {
            Check counter = (Check)counters.get(area);
            csv.addLine(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)area), new CSVFile.CSVField((Object)this.df2.format(counter.get("students"))), new CSVFile.CSVField((Object)this.df2.format(counter.get("req"))), new CSVFile.CSVField((Object)this.df2.format(counter.get("req-assigned"))), new CSVFile.CSVField((Object)this.percent(counter.get("req-assigned"), counter.get("req"))), new CSVFile.CSVField((Object)this.df2.format(counter.get("no-alt"))), new CSVFile.CSVField((Object)this.percent(counter.get("no-alt"), counter.get("req"))), new CSVFile.CSVField((Object)this.df2.format(counter.get("no-alt-assigned"))), new CSVFile.CSVField((Object)this.percent(counter.get("no-alt-assigned"), counter.get("no-alt"))), new CSVFile.CSVField((Object)this.df2.format(counter.get("alt"))), new CSVFile.CSVField((Object)this.percent(counter.get("alt"), counter.get("req"))), new CSVFile.CSVField((Object)this.df2.format(counter.get("alt-assigned"))), new CSVFile.CSVField((Object)this.percent(counter.get("alt-assigned"), counter.get("alt"))), new CSVFile.CSVField((Object)this.df2.format(counter.get("alt-assigned-1st"))), new CSVFile.CSVField((Object)this.percent(counter.get("alt-assigned-1st"), counter.get("alt-assigned"))), new CSVFile.CSVField((Object)this.df2.format(counter.get("subst"))), new CSVFile.CSVField((Object)this.percent(counter.get("subst"), counter.get("students"))), new CSVFile.CSVField((Object)this.df2.format(counter.get("subst-assigned"))), new CSVFile.CSVField((Object)this.percent(counter.get("subst-assigned"), counter.get("subst"))), new CSVFile.CSVField((Object)this.df2.format(counter.get("advised"))), new CSVFile.CSVField((Object)this.percent(counter.get("advised"), counter.get("students"))), new CSVFile.CSVField((Object)this.df2.format(counter.get("adv-req"))), new CSVFile.CSVField((Object)this.df2.format(counter.get("adv-req-assigned"))), new CSVFile.CSVField((Object)this.percent(counter.get("adv-req-assigned"), counter.get("adv-req"))), new CSVFile.CSVField((Object)this.df2.format(counter.get("adv-no-alt"))), new CSVFile.CSVField((Object)this.percent(counter.get("adv-no-alt"), counter.get("adv-req"))), new CSVFile.CSVField((Object)this.df2.format(counter.get("adv-no-alt-assigned"))), new CSVFile.CSVField((Object)this.percent(counter.get("adv-no-alt-assigned"), counter.get("adv-no-alt"))), new CSVFile.CSVField((Object)this.df2.format(counter.get("adv-alt"))), new CSVFile.CSVField((Object)this.percent(counter.get("adv-alt"), counter.get("adv-req"))), new CSVFile.CSVField((Object)this.df2.format(counter.get("adv-alt-assigned"))), new CSVFile.CSVField((Object)this.percent(counter.get("adv-alt-assigned"), counter.get("adv-alt"))), new CSVFile.CSVField((Object)this.df2.format(counter.get("adv-alt-assigned-1st"))), new CSVFile.CSVField((Object)this.percent(counter.get("adv-alt-assigned-1st"), counter.get("adv-alt-assigned"))), new CSVFile.CSVField((Object)this.df2.format(counter.get("adv-subst"))), new CSVFile.CSVField((Object)this.percent(counter.get("adv-subst"), counter.get("advised"))), new CSVFile.CSVField((Object)this.df2.format(counter.get("adv-subst-assigned"))), new CSVFile.CSVField((Object)this.percent(counter.get("adv-subst-assigned"), counter.get("adv-subst"))), new CSVFile.CSVField((Object)this.df2.format(counter.get("req", Request.RequestPriority.Vital))), new CSVFile.CSVField((Object)this.df2.format(counter.get("req-assigned", Request.RequestPriority.Vital))), new CSVFile.CSVField((Object)this.percent(counter.get("req-assigned", Request.RequestPriority.Vital), counter.get("req", Request.RequestPriority.Vital))), new CSVFile.CSVField((Object)this.df2.format(counter.get("no-alt", Request.RequestPriority.Vital))), new CSVFile.CSVField((Object)this.percent(counter.get("no-alt", Request.RequestPriority.Vital), counter.get("req", Request.RequestPriority.Vital))), new CSVFile.CSVField((Object)this.df2.format(counter.get("no-alt-assigned", Request.RequestPriority.Vital))), new CSVFile.CSVField((Object)this.percent(counter.get("no-alt-assigned", Request.RequestPriority.Vital), counter.get("no-alt", Request.RequestPriority.Vital))), new CSVFile.CSVField((Object)this.df2.format(counter.get("alt", Request.RequestPriority.Vital))), new CSVFile.CSVField((Object)this.percent(counter.get("alt", Request.RequestPriority.Vital), counter.get("req", Request.RequestPriority.Vital))), new CSVFile.CSVField((Object)this.df2.format(counter.get("alt-assigned", Request.RequestPriority.Vital))), new CSVFile.CSVField((Object)this.percent(counter.get("alt-assigned", Request.RequestPriority.Vital), counter.get("alt", Request.RequestPriority.Vital))), new CSVFile.CSVField((Object)this.df2.format(counter.get("alt-assigned-1st", Request.RequestPriority.Vital))), new CSVFile.CSVField((Object)this.percent(counter.get("alt-assigned-1st", Request.RequestPriority.Vital), counter.get("alt-assigned", Request.RequestPriority.Vital))), new CSVFile.CSVField((Object)this.df2.format(counter.get("adv-req", Request.RequestPriority.Vital))), new CSVFile.CSVField((Object)this.df2.format(counter.get("adv-req-assigned", Request.RequestPriority.Vital))), new CSVFile.CSVField((Object)this.percent(counter.get("adv-req-assigned", Request.RequestPriority.Vital), counter.get("adv-req", Request.RequestPriority.Vital))), new CSVFile.CSVField((Object)this.df2.format(counter.get("adv-no-alt", Request.RequestPriority.Vital))), new CSVFile.CSVField((Object)this.percent(counter.get("adv-no-alt", Request.RequestPriority.Vital), counter.get("adv-req", Request.RequestPriority.Vital))), new CSVFile.CSVField((Object)this.df2.format(counter.get("adv-no-alt-assigned", Request.RequestPriority.Vital))), new CSVFile.CSVField((Object)this.percent(counter.get("adv-no-alt-assigned", Request.RequestPriority.Vital), counter.get("adv-no-alt", Request.RequestPriority.Vital))), new CSVFile.CSVField((Object)this.df2.format(counter.get("adv-alt", Request.RequestPriority.Vital))), new CSVFile.CSVField((Object)this.percent(counter.get("adv-alt", Request.RequestPriority.Vital), counter.get("adv-req", Request.RequestPriority.Vital))), new CSVFile.CSVField((Object)this.df2.format(counter.get("adv-alt-assigned", Request.RequestPriority.Vital))), new CSVFile.CSVField((Object)this.percent(counter.get("adv-alt-assigned", Request.RequestPriority.Vital), counter.get("adv-alt", Request.RequestPriority.Vital))), new CSVFile.CSVField((Object)this.df2.format(counter.get("adv-alt-assigned-1st", Request.RequestPriority.Vital))), new CSVFile.CSVField((Object)this.percent(counter.get("adv-alt-assigned-1st", Request.RequestPriority.Vital), counter.get("adv-alt-assigned", Request.RequestPriority.Vital)))});
        }
        Check counter = total;
        csv.addLine(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)"Total"), new CSVFile.CSVField((Object)this.df2.format(counter.get("students"))), new CSVFile.CSVField((Object)this.df2.format(counter.get("req"))), new CSVFile.CSVField((Object)this.df2.format(counter.get("req-assigned"))), new CSVFile.CSVField((Object)this.percent(counter.get("req-assigned"), counter.get("req"))), new CSVFile.CSVField((Object)this.df2.format(counter.get("no-alt"))), new CSVFile.CSVField((Object)this.percent(counter.get("no-alt"), counter.get("req"))), new CSVFile.CSVField((Object)this.df2.format(counter.get("no-alt-assigned"))), new CSVFile.CSVField((Object)this.percent(counter.get("no-alt-assigned"), counter.get("no-alt"))), new CSVFile.CSVField((Object)this.df2.format(counter.get("alt"))), new CSVFile.CSVField((Object)this.percent(counter.get("alt"), counter.get("req"))), new CSVFile.CSVField((Object)this.df2.format(counter.get("alt-assigned"))), new CSVFile.CSVField((Object)this.percent(counter.get("alt-assigned"), counter.get("alt"))), new CSVFile.CSVField((Object)this.df2.format(counter.get("alt-assigned-1st"))), new CSVFile.CSVField((Object)this.percent(counter.get("alt-assigned-1st"), counter.get("alt-assigned"))), new CSVFile.CSVField((Object)this.df2.format(counter.get("subst"))), new CSVFile.CSVField((Object)this.percent(counter.get("subst"), counter.get("students"))), new CSVFile.CSVField((Object)this.df2.format(counter.get("subst-assigned"))), new CSVFile.CSVField((Object)(counter.get("subst") == 0 ? "" : this.percent(counter.get("subst-assigned"), counter.get("subst")))), new CSVFile.CSVField((Object)this.df2.format(counter.get("advised"))), new CSVFile.CSVField((Object)this.percent(counter.get("advised"), counter.get("students"))), new CSVFile.CSVField((Object)this.df2.format(counter.get("adv-req"))), new CSVFile.CSVField((Object)this.df2.format(counter.get("adv-req-assigned"))), new CSVFile.CSVField((Object)this.percent(counter.get("adv-req-assigned"), counter.get("adv-req"))), new CSVFile.CSVField((Object)this.df2.format(counter.get("adv-no-alt"))), new CSVFile.CSVField((Object)this.percent(counter.get("adv-no-alt"), counter.get("adv-req"))), new CSVFile.CSVField((Object)this.df2.format(counter.get("adv-no-alt-assigned"))), new CSVFile.CSVField((Object)this.percent(counter.get("adv-no-alt-assigned"), counter.get("adv-no-alt"))), new CSVFile.CSVField((Object)this.df2.format(counter.get("adv-alt"))), new CSVFile.CSVField((Object)this.percent(counter.get("adv-alt"), counter.get("adv-req"))), new CSVFile.CSVField((Object)this.df2.format(counter.get("adv-alt-assigned"))), new CSVFile.CSVField((Object)this.percent(counter.get("adv-alt-assigned"), counter.get("adv-alt"))), new CSVFile.CSVField((Object)this.df2.format(counter.get("adv-alt-assigned-1st"))), new CSVFile.CSVField((Object)this.percent(counter.get("adv-alt-assigned-1st"), counter.get("adv-alt-assigned"))), new CSVFile.CSVField((Object)this.df2.format(counter.get("adv-subst"))), new CSVFile.CSVField((Object)this.percent(counter.get("adv-subst"), counter.get("advised"))), new CSVFile.CSVField((Object)this.df2.format(counter.get("adv-subst-assigned"))), new CSVFile.CSVField((Object)(counter.get("adv-subst") == 0 ? "" : this.percent(counter.get("adv-subst-assigned"), counter.get("adv-subst")))), new CSVFile.CSVField((Object)this.df2.format(counter.get("req", Request.RequestPriority.Vital))), new CSVFile.CSVField((Object)this.df2.format(counter.get("req-assigned", Request.RequestPriority.Vital))), new CSVFile.CSVField((Object)this.percent(counter.get("req-assigned", Request.RequestPriority.Vital), counter.get("req", Request.RequestPriority.Vital))), new CSVFile.CSVField((Object)this.df2.format(counter.get("no-alt", Request.RequestPriority.Vital))), new CSVFile.CSVField((Object)this.percent(counter.get("no-alt", Request.RequestPriority.Vital), counter.get("req", Request.RequestPriority.Vital))), new CSVFile.CSVField((Object)this.df2.format(counter.get("no-alt-assigned", Request.RequestPriority.Vital))), new CSVFile.CSVField((Object)this.percent(counter.get("no-alt-assigned", Request.RequestPriority.Vital), counter.get("no-alt", Request.RequestPriority.Vital))), new CSVFile.CSVField((Object)this.df2.format(counter.get("alt", Request.RequestPriority.Vital))), new CSVFile.CSVField((Object)this.percent(counter.get("alt", Request.RequestPriority.Vital), counter.get("req", Request.RequestPriority.Vital))), new CSVFile.CSVField((Object)this.df2.format(counter.get("alt-assigned", Request.RequestPriority.Vital))), new CSVFile.CSVField((Object)this.percent(counter.get("alt-assigned", Request.RequestPriority.Vital), counter.get("alt", Request.RequestPriority.Vital))), new CSVFile.CSVField((Object)this.df2.format(counter.get("alt-assigned-1st", Request.RequestPriority.Vital))), new CSVFile.CSVField((Object)this.percent(counter.get("alt-assigned-1st", Request.RequestPriority.Vital), counter.get("alt-assigned", Request.RequestPriority.Vital))), new CSVFile.CSVField((Object)this.df2.format(counter.get("adv-req", Request.RequestPriority.Vital))), new CSVFile.CSVField((Object)this.df2.format(counter.get("adv-req-assigned", Request.RequestPriority.Vital))), new CSVFile.CSVField((Object)this.percent(counter.get("adv-req-assigned", Request.RequestPriority.Vital), counter.get("adv-req", Request.RequestPriority.Vital))), new CSVFile.CSVField((Object)this.df2.format(counter.get("adv-no-alt", Request.RequestPriority.Vital))), new CSVFile.CSVField((Object)this.percent(counter.get("adv-no-alt", Request.RequestPriority.Vital), counter.get("adv-req", Request.RequestPriority.Vital))), new CSVFile.CSVField((Object)this.df2.format(counter.get("adv-no-alt-assigned", Request.RequestPriority.Vital))), new CSVFile.CSVField((Object)this.percent(counter.get("adv-no-alt-assigned", Request.RequestPriority.Vital), counter.get("adv-no-alt", Request.RequestPriority.Vital))), new CSVFile.CSVField((Object)this.df2.format(counter.get("adv-alt", Request.RequestPriority.Vital))), new CSVFile.CSVField((Object)this.percent(counter.get("adv-alt", Request.RequestPriority.Vital), counter.get("adv-req", Request.RequestPriority.Vital))), new CSVFile.CSVField((Object)this.df2.format(counter.get("adv-alt-assigned", Request.RequestPriority.Vital))), new CSVFile.CSVField((Object)this.percent(counter.get("adv-alt-assigned", Request.RequestPriority.Vital), counter.get("adv-alt", Request.RequestPriority.Vital))), new CSVFile.CSVField((Object)this.df2.format(counter.get("adv-alt-assigned-1st", Request.RequestPriority.Vital))), new CSVFile.CSVField((Object)this.percent(counter.get("adv-alt-assigned-1st", Request.RequestPriority.Vital), counter.get("adv-alt-assigned", Request.RequestPriority.Vital)))});
        return csv;
    }

    protected Course findCourse(CourseRequestInterface.RequestedCourse rc) {
        if (this.iCourseCacheIds == null) {
            this.iCourseCacheIds = new HashMap<Long, Course>();
            this.iCourseCacheNames = new HashMap<String, Course>();
            for (Offering o : this.getModel().getOfferings()) {
                for (Course c : o.getCourses()) {
                    this.iCourseCacheIds.put(c.getId(), c);
                    this.iCourseCacheNames.put(c.getName(), c);
                }
            }
        }
        Course ret = null;
        if (rc.hasCourseId()) {
            ret = this.iCourseCacheIds.get(rc.getCourseId());
        }
        if (ret == null && rc.hasCourseName()) {
            ret = this.iCourseCacheNames.get(rc.getCourseName());
        }
        return ret;
    }

    public boolean matches(Student s, CourseRequestInterface.Request r) {
        if (r.hasRequestedCourse()) {
            for (CourseRequestInterface.RequestedCourse rc : r.getRequestedCourse()) {
                Course c = this.findCourse(rc);
                if (c == null || !super.matches(c)) continue;
                return true;
            }
        }
        return false;
    }

    private static class Check {
        Map<String, Map<Request.RequestPriority, Boolean>> iCheck = new HashMap<String, Map<Request.RequestPriority, Boolean>>();
        Map<String, Map<Request.RequestPriority, Integer>> iCounts = new HashMap<String, Map<Request.RequestPriority, Integer>>();

        private Check() {
        }

        public boolean is(String check) {
            Map<Request.RequestPriority, Boolean> ch = this.iCheck.get(check);
            if (ch == null) {
                return false;
            }
            for (Boolean b : ch.values()) {
                if (!b.booleanValue()) continue;
                return true;
            }
            return false;
        }

        public int get(String check, Request.RequestPriority rp) {
            Map<Request.RequestPriority, Integer> cnt = this.iCounts.get(check);
            if (cnt == null) {
                return 0;
            }
            Integer c = cnt.get(rp);
            return c == null ? 0 : c;
        }

        public int get(String check) {
            Map<Request.RequestPriority, Integer> cnt = this.iCounts.get(check);
            if (cnt == null) {
                return 0;
            }
            int total = 0;
            for (Integer c : cnt.values()) {
                total += c.intValue();
            }
            return total;
        }

        public void set(String check, Request.RequestPriority rp, Boolean value, int inc) {
            Map<Request.RequestPriority, Boolean> ch = this.iCheck.get(check);
            if (ch == null) {
                ch = new HashMap<Request.RequestPriority, Boolean>();
                this.iCheck.put(check, ch);
            }
            if (value != null) {
                ch.put(rp, value);
            } else {
                ch.remove(rp);
            }
            Map<Request.RequestPriority, Integer> cnt = this.iCounts.get(check);
            if (cnt == null) {
                cnt = new HashMap<Request.RequestPriority, Integer>();
                this.iCounts.put(check, cnt);
            }
            Integer old = cnt.get(rp);
            if (Boolean.TRUE.equals(value)) {
                cnt.put(rp, inc + (old == null ? 0 : old));
            }
        }

        public void set(String check, Request.RequestPriority rp) {
            this.set(check, rp, true, 1);
        }

        public void set(String check) {
            this.set(check, Request.RequestPriority.Normal, true, 1);
        }

        public void inc(String check) {
            this.set(check, Request.RequestPriority.Normal, true, 1);
        }

        public void inc(String check, Check other) {
            Request.RequestPriority[] requestPriorityArray = Request.RequestPriority.values();
            int n = requestPriorityArray.length;
            for (int i = 0; i < n; ++i) {
                Request.RequestPriority rp;
                int cnt = other.get(check, rp = requestPriorityArray[i]);
                this.set(check, rp, cnt > 0, cnt);
            }
        }
    }
}

