/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.pointintimedata;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseNull;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.PointInTimeDataReportsInterface;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.webutil.BackTracker;
import org.unitime.timetable.webutil.Navigation;

@GwtRpcImplements(value=PointInTimeDataReportsInterface.PITDSetBackRpcRequest.class)
public class PITDSetBackBackend
implements GwtRpcImplementation<PointInTimeDataReportsInterface.PITDSetBackRpcRequest, GwtRpcResponseNull> {
    protected static GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    @Autowired
    private SessionContext sessionContext;

    @Override
    @PreAuthorize(value="checkPermission('PointInTimeDataReports')")
    public GwtRpcResponseNull execute(PointInTimeDataReportsInterface.PITDSetBackRpcRequest request, SessionContext context) {
        String title = MESSAGES.pagePointInTimeDataReports();
        BackTracker.markForBack(this.sessionContext, "pointInTimeDataReports#" + request.getHistory(), title, true, true);
        if ("__Class".equals(request.getType())) {
            Navigation.set(this.sessionContext, Navigation.sClassLevel, request.getIds());
        } else if ("__Offering".equals(request.getType())) {
            Navigation.set(this.sessionContext, Navigation.sInstructionalOfferingLevel, request.getIds());
        } else if ("__Subpart".equals(request.getType())) {
            Navigation.set(this.sessionContext, Navigation.sSchedulingSubpartLevel, request.getIds());
        } else if ("__Room".equals(request.getType())) {
            Navigation.set(this.sessionContext, Navigation.sInstructionalOfferingLevel, request.getIds());
        } else if ("__Instructor".equals(request.getType())) {
            Navigation.set(this.sessionContext, Navigation.sInstructionalOfferingLevel, request.getIds());
        } else if ("__Exam".equals(request.getType())) {
            Navigation.set(this.sessionContext, Navigation.sInstructionalOfferingLevel, request.getIds());
        } else if ("__Event".equals(request.getType())) {
            Navigation.set(this.sessionContext, Navigation.sInstructionalOfferingLevel, request.getIds());
        }
        return null;
    }
}

