/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.instructor.survey;

import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.gwt.client.instructor.survey.InstructorSurveyInterface;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.InstructorCourseRequirement;
import org.unitime.timetable.model.InstructorCourseRequirementNote;
import org.unitime.timetable.model.InstructorCourseRequirementType;
import org.unitime.timetable.model.InstructorSurvey;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.TimePatternModel;
import org.unitime.timetable.model.TimePref;
import org.unitime.timetable.model.dao.InstructionalOfferingDAO;
import org.unitime.timetable.model.dao.InstructorCourseRequirementTypeDAO;
import org.unitime.timetable.model.dao.InstructorSurveyDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.webutil.RequiredTimeTable;

@GwtRpcImplements(value=InstructorSurveyInterface.InstructorRequirementsRequest.class)
public class InstructorRequirementsBackend
implements GwtRpcImplementation<InstructorSurveyInterface.InstructorRequirementsRequest, InstructorSurveyInterface.InstructorRequirementData> {
    @Override
    public InstructorSurveyInterface.InstructorRequirementData execute(InstructorSurveyInterface.InstructorRequirementsRequest request, SessionContext context) {
        context.checkPermission(request.getOfferingId(), "InstructionalOffering", Right.InstructionalOfferingDetail);
        InstructionalOffering io = (InstructionalOffering)InstructionalOfferingDAO.getInstance().get(request.getOfferingId());
        InstructorSurveyInterface.InstructorRequirementData response = new InstructorSurveyInterface.InstructorRequirementData();
        response.setCrossList(io.getCourseOfferings().size() > 1);
        response.setAdmin(context.hasPermission(io.getDepartment(), Right.InstructorSurveyAdmin));
        List types = InstructorCourseRequirementTypeDAO.getInstance().getSession().createQuery("from InstructorCourseRequirementType order by sortOrder", InstructorCourseRequirementType.class).list();
        HashMap<Long, InstructorSurveyInterface.CustomField> customFields = new HashMap<Long, InstructorSurveyInterface.CustomField>();
        for (InstructorCourseRequirementType type : types) {
            InstructorSurveyInterface.CustomField cf = new InstructorSurveyInterface.CustomField(type.getUniqueId(), type.getReference(), type.getLength());
            customFields.put(type.getUniqueId(), cf);
            response.addCustomField(cf);
        }
        String instructorNameFormat = context.getUser().getProperty(UserProperty.NameFormat);
        boolean timeVertical = false;
        boolean gridAsText = false;
        List<InstructorCourseRequirement> requirements = InstructorCourseRequirement.getRequirementsForOffering(io);
        if (!requirements.isEmpty()) {
            for (InstructorCourseRequirement req : new TreeSet<InstructorCourseRequirement>(requirements)) {
                DepartmentalInstructor di = req.getInstructorSurvey().getInstructor(io);
                InstructorSurveyInterface.CourseRequirement line = new InstructorSurveyInterface.CourseRequirement();
                line.setExternalId(req.getInstructorSurvey().getExternalUniqueId());
                if (di != null) {
                    line.setInstructorId(di.getUniqueId());
                }
                line.setInstructorName(req.getInstructorSurvey().getExternalUniqueId());
                if (di != null) {
                    line.setInstructorName(di.getName(instructorNameFormat));
                }
                line.setCourseName(req.getCourseOffering() == null ? req.getCourse() : req.getCourseOffering().getCourseName());
                line.setId(req.getCourseOffering() != null ? req.getCourseOffering().getUniqueId() : null);
                line.setCourseTitle(req.getCourseOffering() != null ? req.getCourseOffering().getTitle() : null);
                for (InstructorCourseRequirementNote note : req.getNotes()) {
                    line.setCustomField(note.getType().getUniqueId(), note.getNote());
                }
                line.setNote(req.getInstructorSurvey().getNote());
                for (Preference p : req.getInstructorSurvey().getPreferences()) {
                    if (p instanceof TimePref) {
                        TimePref tp = (TimePref)p;
                        RequiredTimeTable rtt = tp.getRequiredTimeTable();
                        if (gridAsText) {
                            line.setTimeHtml(rtt.getModel().toString().replaceAll(", ", "\n"));
                            continue;
                        }
                        ((TimePatternModel)rtt.getModel()).setMode("|" + this.propertyValue(io.getDepartment(), ApplicationProperty.InstructorSurveyTimePreferencesDept, ApplicationProperty.InstructorSurveyTimePreferences));
                        line.setTimeHtml("<img border='0' onmouseover=\"showGwtInstructorAvailabilityHint(this, 'IS#" + req.getInstructorSurvey().getUniqueId() + "#" + io.getDepartment().getDeptCode() + "');\" onmouseout=\"hideGwtInstructorAvailabilityHint();\" src='pattern?v=" + (timeVertical ? 1 : 0) + "&d=" + io.getDepartment().getUniqueId() + "&p=" + rtt.getModel().getPreferences() + "' title='" + rtt.getModel().toString() + "' >&nbsp;");
                        continue;
                    }
                    if (p instanceof DistributionPref) {
                        if (!((DistributionPref)p).getDistributionType().effectiveSurvey()) continue;
                        line.addDist(p.preferenceText(instructorNameFormat));
                        line.addDistHtml(p.preferenceHtml(instructorNameFormat));
                        continue;
                    }
                    line.addRoom(p.preferenceText(instructorNameFormat));
                    line.addRoomHtml(p.preferenceHtml(instructorNameFormat));
                }
                response.addInstructorRequirement(line);
            }
        }
        List surveys = InstructorSurveyDAO.getInstance().getSession().createQuery("select s from InstructorSurvey s where s.submitted is not null and s.externalUniqueId in (select ci.instructor.externalUniqueId from ClassInstructor ci where ci.classInstructing.schedulingSubpart.instrOfferingConfig.instructionalOffering.uniqueId = :offeringId and ci.instructor.externalUniqueId is not null) and s.session.uniqueId = :sessionId and (s.preferences is not empty or length(s.note) > 0)", InstructorSurvey.class).setParameter("sessionId", (Object)io.getSessionId()).setParameter("offeringId", (Object)io.getUniqueId()).setCacheable(true).list();
        block4: for (InstructorSurvey survey : surveys) {
            InstructorSurveyInterface.CourseRequirement line2;
            if (response.hasInstructorRequirements()) {
                for (InstructorSurveyInterface.CourseRequirement line2 : response.getInstructorRequirements()) {
                    if (!survey.getExternalUniqueId().equals(line2.getExternalId())) continue;
                    continue block4;
                }
            }
            DepartmentalInstructor di = survey.getInstructor(io);
            line2 = new InstructorSurveyInterface.CourseRequirement();
            line2.setExternalId(survey.getExternalUniqueId());
            if (di != null) {
                line2.setInstructorId(di.getUniqueId());
            }
            line2.setInstructorName(survey.getExternalUniqueId());
            if (di != null) {
                line2.setInstructorName(di.getName(instructorNameFormat));
            }
            line2.setCourseName(io.getControllingCourseOffering().getCourseName());
            line2.setId(io.getControllingCourseOffering().getUniqueId());
            line2.setCourseTitle(io.getControllingCourseOffering().getTitle());
            line2.setNote(survey.getNote());
            for (Preference p : survey.getPreferences()) {
                if (p instanceof TimePref) {
                    TimePref tp = (TimePref)p;
                    RequiredTimeTable rtt = tp.getRequiredTimeTable();
                    if (gridAsText) {
                        line2.setTimeHtml(rtt.getModel().toString().replaceAll(", ", "\n"));
                        continue;
                    }
                    ((TimePatternModel)rtt.getModel()).setMode("|" + this.propertyValue(io.getDepartment(), ApplicationProperty.InstructorSurveyTimePreferencesDept, ApplicationProperty.InstructorSurveyTimePreferences));
                    line2.setTimeHtml("<img border='0' onmouseover=\"showGwtInstructorAvailabilityHint(this, 'IS#" + survey.getUniqueId() + "#" + io.getDepartment().getDeptCode() + "');\" onmouseout=\"hideGwtInstructorAvailabilityHint();\" src='pattern?v=" + (timeVertical ? 1 : 0) + "&d=" + io.getDepartment().getUniqueId() + "&p=" + rtt.getModel().getPreferences() + "' title='" + rtt.getModel().toString() + "' >&nbsp;");
                    continue;
                }
                if (p instanceof DistributionPref) {
                    if (!((DistributionPref)p).getDistributionType().effectiveSurvey()) continue;
                    line2.addDist(p.preferenceText(instructorNameFormat));
                    line2.addDistHtml(p.preferenceHtml(instructorNameFormat));
                    continue;
                }
                line2.addRoom(p.preferenceText(instructorNameFormat));
                line2.addRoomHtml(p.preferenceHtml(instructorNameFormat));
            }
            response.addInstructorRequirement(line2);
        }
        return response;
    }

    protected String propertyValue(Department dept, ApplicationProperty departmentalProperty, ApplicationProperty globalProperty) {
        String value;
        if (dept != null && (value = departmentalProperty.value(dept.getDeptCode())) != null) {
            return value;
        }
        return globalProperty.value();
    }
}

