/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.instructor;

import java.util.HashSet;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.query.Query;
import org.unitime.commons.Debug;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.shared.InstructorInterface;
import org.unitime.timetable.interfaces.ExternalClassEditAction;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.InstructorAttribute;
import org.unitime.timetable.model.PositionType;
import org.unitime.timetable.model.base.BaseDepartment;
import org.unitime.timetable.model.dao.DepartmentDAO;
import org.unitime.timetable.model.dao.DepartmentalInstructorDAO;
import org.unitime.timetable.model.dao.PositionTypeDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.webutil.BackTracker;
import org.unitime.timetable.webutil.JavascriptFunctions;

@GwtRpcImplements(value=InstructorInterface.InstructorEditRequest.class)
public class InstructorEditBackend
implements GwtRpcImplementation<InstructorInterface.InstructorEditRequest, InstructorInterface.InstructorEditResponse> {
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);

    @Override
    public InstructorInterface.InstructorEditResponse execute(InstructorInterface.InstructorEditRequest request, SessionContext context) {
        String dept;
        context.hasPermission(request.getInstructorId(), "Instructor", Right.InstructorEdit);
        Long instructorId = request.getInstructorId();
        Long deptId = request.getDepartmentId();
        if (request.getData() != null) {
            instructorId = request.getData().getInstructorId();
            deptId = request.getData().getDepartmentId();
        }
        if (deptId == null && (dept = (String)context.getAttribute(SessionAttribute.DepartmentId)) != null) {
            try {
                deptId = Long.valueOf(dept);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (request.getOperation() != null) {
            switch (request.getOperation()) {
                case SAVE: {
                    this.saveInstructor(request.getData(), context);
                    return request.getData();
                }
                case PREVIOUS: {
                    this.saveInstructor(request.getData(), context);
                    instructorId = request.getData().getPreviousId();
                    break;
                }
                case NEXT: {
                    this.saveInstructor(request.getData(), context);
                    instructorId = request.getData().getNextId();
                    break;
                }
                case DELETE: {
                    this.deleteInstructor(instructorId, context);
                    return null;
                }
            }
        }
        return this.loadInstructor(instructorId, deptId, context);
    }

    protected void saveInstructor(InstructorInterface.InstructorEditResponse data, SessionContext context) {
        context.hasPermission(data.getInstructorId(), Right.InstructorEdit);
        Session hibSession = DepartmentalInstructorDAO.getInstance().getSession();
        Transaction tx = null;
        try {
            tx = hibSession.beginTransaction();
            Query q = hibSession.createQuery("from DepartmentalInstructor where externalUniqueId=:puid and department.uniqueId=:deptId" + (data.getInstructorId() == null ? "" : " and uniqueId!=:uniqueId"), DepartmentalInstructor.class);
            q.setParameter("puid", (Object)data.getExternalId());
            q.setParameter("deptId", (Object)data.getDepartmentId());
            if (data.getInstructorId() != null) {
                q.setParameter("uniqueId", (Object)data.getInstructorId());
            }
            if (!q.list().isEmpty()) {
                throw new GwtRpcException(MSG.errorInstructorIdAlreadyExistsInList());
            }
            DepartmentalInstructor inst = null;
            if (data.getInstructorId() != null) {
                inst = (DepartmentalInstructor)DepartmentalInstructorDAO.getInstance().get(data.getInstructorId(), hibSession);
            } else {
                inst = new DepartmentalInstructor();
                inst.setAttributes(new HashSet<InstructorAttribute>());
                inst.setDepartment((Department)DepartmentDAO.getInstance().get(data.getDepartmentId(), hibSession));
                inst.getDepartment().getInstructors().add(inst);
            }
            inst.setFirstName(data.getFirstName());
            inst.setMiddleName(data.getMiddleName());
            inst.setLastName(data.getLastName());
            inst.setAcademicTitle(data.getAcademicTitle());
            inst.setExternalUniqueId(data.getExternalId());
            inst.setEmail(data.getEmail());
            inst.setPositionType(data.getPositionId() == null ? null : (PositionType)PositionTypeDAO.getInstance().get(data.getPositionId(), hibSession));
            if (data.getNote() != null && data.getNote().length() > 2048) {
                data.setNote(data.getNote().substring(0, 2048));
            }
            inst.setNote(data.getNote());
            inst.setIgnoreToFar(data.isIgnoreTooFar());
            inst.setCareerAcct(data.getCareerAcct());
            if (inst.getUniqueId() == null) {
                hibSession.persist((Object)inst);
            } else {
                hibSession.merge((Object)inst);
            }
            ChangeLog.addChange(hibSession, context, inst, ChangeLog.Source.INSTRUCTOR_EDIT, data.getInstructorId() == null ? ChangeLog.Operation.CREATE : ChangeLog.Operation.UPDATE, null, inst.getDepartment());
            tx.commit();
            if (data.getInstructorId() == null) {
                data.setInstructorId(inst.getUniqueId());
            }
        }
        catch (Exception e) {
            Debug.error(e);
            try {
                if (tx != null && tx.isActive()) {
                    tx.rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new GwtRpcException(e.getMessage(), e);
        }
    }

    protected void deleteInstructor(Long instructorId, SessionContext context) {
        context.hasPermission(instructorId, "DepartmentalInstructor", Right.InstructorDelete);
        Session hibSession = DepartmentalInstructorDAO.getInstance().getSession();
        Transaction tx = null;
        try {
            tx = hibSession.beginTransaction();
            DepartmentalInstructor inst = (DepartmentalInstructor)DepartmentalInstructorDAO.getInstance().get(instructorId, hibSession);
            ChangeLog.addChange(hibSession, context, inst, ChangeLog.Source.INSTRUCTOR_EDIT, ChangeLog.Operation.DELETE, null, inst.getDepartment());
            HashSet<Class_> updatedClasses = new HashSet<Class_>();
            for (ClassInstructor ci : inst.getClasses()) {
                Class_ c = ci.getClassInstructing();
                updatedClasses.add(c);
                c.getClassInstructors().remove(ci);
                hibSession.remove((Object)ci);
            }
            for (Exam exam : inst.getExams()) {
                exam.getInstructors().remove(inst);
                hibSession.merge((Object)exam);
            }
            for (Assignment a : inst.getAssignments()) {
                a.getInstructors().remove(inst);
                hibSession.merge((Object)a);
            }
            BaseDepartment d = null;
            if (inst.getDepartment() != null) {
                d = inst.getDepartment();
            }
            d.getInstructors().remove(inst);
            hibSession.remove((Object)inst);
            tx.commit();
            String className = ApplicationProperty.ExternalActionClassEdit.value();
            if (className != null && className.trim().length() > 0) {
                ExternalClassEditAction editAction = (ExternalClassEditAction)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                for (Class_ c : updatedClasses) {
                    editAction.performExternalClassEditAction(c, hibSession);
                }
            }
            hibSession.clear();
        }
        catch (Exception e) {
            Debug.error(e);
            try {
                if (tx != null && tx.isActive()) {
                    tx.rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new GwtRpcException(e.getMessage(), e);
        }
    }

    protected InstructorInterface.InstructorEditResponse loadInstructor(Long instructorId, Long departmentId, SessionContext context) {
        DepartmentalInstructor instructor;
        InstructorInterface.InstructorEditResponse data = new InstructorInterface.InstructorEditResponse();
        DepartmentalInstructor departmentalInstructor = instructor = instructorId == null ? null : (DepartmentalInstructor)DepartmentalInstructorDAO.getInstance().get(instructorId);
        if (instructor != null) {
            context.hasPermission(instructor, Right.InstructorEdit);
            data.setInstructorId(instructor.getUniqueId());
            data.setDepartmentId(instructor.getDepartment().getUniqueId());
            data.setExternalId(instructor.getExternalUniqueId());
            data.setFirstName(instructor.getFirstName());
            data.setMiddleName(instructor.getMiddleName());
            data.setLastName(instructor.getLastName());
            data.setAcademicTitle(instructor.getAcademicTitle());
            data.setDepartment(instructor.getDepartment().toString());
            data.setEmail(instructor.getEmail());
            data.setIgnoteTooFar(instructor.getIgnoreToFar());
            data.setPositionId(instructor.getPositionType() == null ? null : instructor.getPositionType().getUniqueId());
            data.setCareerAcct(instructor.getCareerAcct());
            data.setNote(instructor.getNote());
            DepartmentalInstructor next = instructor.getNextDepartmentalInstructor(context, Right.InstructorEdit);
            data.setNextId(next == null ? null : next.getUniqueId());
            DepartmentalInstructor previous = instructor.getPreviousDepartmentalInstructor(context, Right.InstructorEdit);
            data.setPreviousId(previous == null ? null : previous.getUniqueId());
            data.setCanDelete(context.hasPermission(instructor, Right.InstructorDelete));
            String nameFormat = UserProperty.NameFormat.get(context.getUser());
            BackTracker.markForBack(context, "instructor?id=" + instructor.getUniqueId(), MSG.backInstructor(instructor.getName(nameFormat)), true, false);
        } else if (departmentId != null) {
            data.setDepartmentId(departmentId);
            Department dept = (Department)DepartmentDAO.getInstance().get(departmentId);
            data.setDepartment(dept.toString());
            context.hasPermission(dept, Right.InstructorAdd);
        } else {
            throw new GwtRpcException(MSG.errorDoesNotExists(MSG.columnInstructor()));
        }
        for (PositionType type : PositionType.findAll()) {
            data.addPosition(type.getUniqueId(), type.getLabel());
        }
        data.setConfirms(JavascriptFunctions.isJsConfirm(context));
        data.setCanEditExternalId(ApplicationProperty.InstructorAllowEditExternalId.isTrue());
        return data;
    }
}

