/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.instructor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.gwt.client.tables.TableInterface;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.FilterInterface;
import org.unitime.timetable.gwt.shared.InstructorInterface;
import org.unitime.timetable.interfaces.ExternalUidLookup;
import org.unitime.timetable.interfaces.RoomAvailabilityInterface;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.Event;
import org.unitime.timetable.model.InstructorAttribute;
import org.unitime.timetable.model.InstructorSurvey;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Meeting;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.TimePref;
import org.unitime.timetable.model.comparators.ClassComparator;
import org.unitime.timetable.model.comparators.ClassInstructorComparator;
import org.unitime.timetable.model.dao.DepartmentalInstructorDAO;
import org.unitime.timetable.model.dao.SchedulingSubpartDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.courses.ExaminationsTableBuilder;
import org.unitime.timetable.server.courses.SubpartDetailBackend;
import org.unitime.timetable.solver.ClassAssignmentProxy;
import org.unitime.timetable.solver.SolverProxy;
import org.unitime.timetable.solver.exam.ExamSolverProxy;
import org.unitime.timetable.solver.interactive.ClassAssignmentDetails;
import org.unitime.timetable.solver.service.AssignmentService;
import org.unitime.timetable.solver.service.SolverService;
import org.unitime.timetable.util.DefaultRoomAvailabilityService;
import org.unitime.timetable.util.Formats;
import org.unitime.timetable.util.RoomAvailability;
import org.unitime.timetable.webutil.BackTracker;
import org.unitime.timetable.webutil.JavascriptFunctions;
import org.unitime.timetable.webutil.Navigation;

@GwtRpcImplements(value=InstructorInterface.InstructorDetailRequest.class)
public class InstructorDetailBackend
implements GwtRpcImplementation<InstructorInterface.InstructorDetailRequest, InstructorInterface.InstructorDetailResponse> {
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    protected static final GwtMessages GWT = Localization.create(GwtMessages.class);
    protected static final GwtConstants CONST = Localization.create(GwtConstants.class);
    @Autowired
    AssignmentService<ClassAssignmentProxy> classAssignmentService;
    @Autowired
    SolverService<ExamSolverProxy> examinationSolverService;
    @Autowired
    SolverService<SolverProxy> courseTimetablingSolverService;

    @Override
    public InstructorInterface.InstructorDetailResponse execute(InstructorInterface.InstructorDetailRequest request, SessionContext context) {
        BackTracker.BackItem back;
        TableInterface.LineInterface line;
        Session hibSession = SchedulingSubpartDAO.getInstance().getSession();
        DepartmentalInstructor instructor = (DepartmentalInstructor)DepartmentalInstructorDAO.getInstance().get(request.getInstructorId(), hibSession);
        context.checkPermission(instructor, Right.InstructorDetail);
        String nameFormat = UserProperty.NameFormat.get(context.getUser());
        if (request.getAction() == null) {
            BackTracker.markForBack(context, "instructor?id=" + request.getInstructorId(), MSG.backInstructor(instructor.getName(nameFormat)), true, false);
        } else {
            switch (request.getAction()) {
                // Empty switch
            }
        }
        InstructorInterface.InstructorDetailResponse response = new InstructorInterface.InstructorDetailResponse();
        response.setConfirms(JavascriptFunctions.isJsConfirm(context));
        response.setInstructorId(instructor.getUniqueId());
        response.setInstructorName(instructor.getName(nameFormat));
        response.setDepartmentId(instructor.getDepartment().getUniqueId());
        response.setExternalId(instructor.getExternalUniqueId());
        DepartmentalInstructor next = instructor.getNextDepartmentalInstructor(context, Right.InstructorDetail);
        response.setNextId(next == null ? null : next.getUniqueId());
        DepartmentalInstructor previous = instructor.getPreviousDepartmentalInstructor(context, Right.InstructorDetail);
        response.setPreviousId(previous == null ? null : previous.getUniqueId());
        List<DepartmentalInstructor> other = DepartmentalInstructor.getAllForInstructor(instructor);
        if (other == null || other.size() == 1) {
            response.addProperty(MSG.propertyDepartment()).add(instructor.getDepartment().getDeptCode() + " - " + instructor.getDepartment().getName());
        } else {
            FilterInterface.FilterParameterInterface depts = new FilterInterface.FilterParameterInterface();
            depts.setName("instructorId");
            depts.setLabel(MSG.propertyDepartment());
            depts.setType("list");
            depts.setCollapsible(false);
            depts.setDefaultValue(instructor.getUniqueId().toString());
            for (DepartmentalInstructor i : other) {
                if (!context.hasPermission(i, Right.InstructorDetail)) continue;
                depts.addOption(i.getUniqueId().toString(), i.getDepartment().getDeptCode() + " - " + i.getDepartment().getName());
            }
            if (!depts.hasOptions() || depts.getOptions().size() <= 1) {
                response.addProperty(MSG.propertyDepartment()).add(instructor.getDepartment().getDeptCode() + " - " + instructor.getDepartment().getName());
            } else {
                response.setDepartmentFilter(depts);
            }
        }
        if (instructor.getCareerAcct() != null) {
            response.addProperty(MSG.propertyAccountName()).add(instructor.getCareerAcct());
        } else if (DepartmentalInstructor.canLookupInstructor() && instructor.getExternalUniqueId() != null && !instructor.getExternalUniqueId().isEmpty()) {
            try {
                ExternalUidLookup.UserInfo user = DepartmentalInstructor.lookupInstructor(instructor.getExternalUniqueId());
                if (user != null && user.getUserName() != null) {
                    response.addProperty(MSG.propertyAccountName()).add(user.getUserName());
                }
            }
            catch (Exception user) {
                // empty catch block
            }
        }
        if (instructor.getEmail() != null && !instructor.getEmail().isEmpty()) {
            response.addProperty(MSG.propertyEmail()).add(instructor.getEmail());
        }
        if (instructor.getPositionType() != null) {
            response.addProperty(MSG.propertyInstructorPosition()).add(instructor.getPositionType().getLabel());
        }
        if (instructor.getNote() != null && !instructor.getNote().isEmpty()) {
            response.addProperty(MSG.propertyNote()).add(instructor.getNote(), true).addStyle("white-space: pre-wrap;");
        }
        if (instructor.isIgnoreToFar().booleanValue()) {
            TableInterface.CellInterface c = response.addProperty(MSG.propertyIgnoreTooFar());
            c.add(MSG.enabled()).setColor("red");
            c.add(" -- ").addStyle("padding-left:10px;");
            c.add(MSG.descriptionInstructorIgnoreTooFar()).addStyle("font-style: italic;");
        }
        if (instructor.getTeachingPreference() != null) {
            response.addProperty(MSG.propertyTeachingPreference()).add(instructor.getTeachingPreference().getPrefName()).setColor(PreferenceLevel.prolog2color(instructor.getTeachingPreference().getPrefProlog()));
        }
        if (instructor.getMaxLoad() != null) {
            response.addProperty(MSG.propertyMaxLoad()).add(Formats.getNumberFormat("0.##").format(instructor.getMaxLoad()));
        }
        HashMap<String, TreeSet<String>> attrs = new HashMap<String, TreeSet<String>>();
        for (InstructorAttribute a : instructor.getAttributes()) {
            String key = a.getType() == null ? "" : a.getType().getLabel();
            TreeSet<String> names = (TreeSet<String>)attrs.get(key);
            if (names == null) {
                names = new TreeSet<String>();
                attrs.put(key, names);
            }
            names.add(a.getName());
        }
        for (String name : new TreeSet(attrs.keySet())) {
            TableInterface.CellInterface c = response.addProperty((name.isEmpty() ? MSG.sectionAttributes() : name) + ":");
            for (Object a : (TreeSet)attrs.get(name)) {
                c.add((String)a).addStyle("unitime-InstructorAttribute").setInline(false);
            }
        }
        InstructorSurvey is = InstructorSurvey.getInstructorSurvey(instructor);
        if (is != null) {
            response.addOperation("has-survey");
        }
        TreeSet<ClassInstructor> classes = new TreeSet<ClassInstructor>(new ClassInstructorComparator(new ClassComparator(2)));
        for (DepartmentalInstructor di : DepartmentalInstructor.getAllForInstructor(instructor)) {
            classes.addAll(di.getClasses());
        }
        if (!classes.isEmpty()) {
            boolean hasTimetable = context.hasPermission(Right.ClassAssignments);
            boolean hasResponsibility = false;
            for (ClassInstructor ci : classes) {
                if (ci.getResponsibility() == null) continue;
                hasResponsibility = true;
            }
            TableInterface classTable = new TableInterface();
            classTable.setName(MSG.sectionTitleClassAssignments());
            classTable.setId("InstructorClassAssignments");
            TableInterface.LineInterface header = classTable.addHeader();
            header.addCell(MSG.columnClass()).setSortable(true);
            header.addCell(MSG.columnInstructorCheckConflicts()).setSortable(true).setTextAlignment(TableInterface.CellInterface.Alignment.CENTER);
            header.addCell(MSG.columnInstructorShare()).setSortable(true).setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT);
            if (hasResponsibility) {
                header.addCell(MSG.columnTeachingResponsibility()).setSortable(true);
            }
            header.addCell(MSG.columnLimit()).setSortable(true).setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT);
            header.addCell(MSG.columnEnrollment()).setSortable(true).setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT);
            header.addCell(MSG.columnManager()).setSortable(true);
            if (hasTimetable) {
                header.addCell(MSG.columnAssignedTime()).setSortable(true);
                header.addCell(MSG.columnAssignedDatePattern()).setSortable(true);
                header.addCell(MSG.columnAssignedRoom()).setSortable(true);
            }
            for (TableInterface.CellInterface cell : header.getCells()) {
                cell.setClassName("WebTableHeader");
                cell.setText(cell.getText().replace("<br>", "\n"));
            }
            ArrayList<Long> classIds = new ArrayList<Long>();
            boolean showSuffix = ApplicationProperty.InstructorShowClassSufix.isTrue();
            for (ClassInstructor ci : classes) {
                Class_ c = ci.getClassInstructing();
                classIds.add(c.getUniqueId());
                line = classTable.addLine();
                line.addCell(ci.getClassInstructing().getClassLabel(showSuffix));
                if (ci.isLead().booleanValue()) {
                    line.addCell().setComparable(Integer.valueOf(1)).setTextAlignment(TableInterface.CellInterface.Alignment.CENTER).setImage().setSource("images/accept.png").setAlt(MSG.altYes());
                } else {
                    line.addCell().setComparable(Integer.valueOf(0));
                }
                line.addCell(ci.getPercentShare() + "%").setComparable(ci.getPercentShare()).setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT);
                if (hasResponsibility) {
                    line.addCell(ci.getResponsibility() == null ? "" : ci.getResponsibility().getLabel());
                }
                if (c.getSchedulingSubpart().getInstrOfferingConfig().isUnlimitedEnrollment().booleanValue()) {
                    line.addCell("\u221e").setComparable(Integer.valueOf(Integer.MAX_VALUE));
                } else if (c.getExpectedCapacity() != null) {
                    if (c.getMaxExpectedCapacity() != null && !c.getMaxExpectedCapacity().equals(c.getExpectedCapacity())) {
                        line.addCell(c.getExpectedCapacity() + " - " + c.getMaxExpectedCapacity()).setComparable(c.getExpectedCapacity()).setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT);
                    } else {
                        line.addCell(c.getExpectedCapacity().toString()).setComparable(c.getExpectedCapacity()).setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT);
                    }
                } else if (c.getMaxExpectedCapacity() != null && c.getMaxExpectedCapacity() != 0) {
                    line.addCell("0 - " + c.getMaxExpectedCapacity()).setComparable(Integer.valueOf(0)).setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT);
                } else {
                    line.addCell("0").setComparable(Integer.valueOf(0)).setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT);
                }
                line.addCell(c.getEnrollment() == null ? "0" : c.getEnrollment().toString()).setTextAlignment(TableInterface.CellInterface.Alignment.RIGHT);
                line.addCell(c.getManagingDept().getShortLabel()).setTitle(c.getManagingDept().toString());
                if (hasTimetable) {
                    TableInterface.CellInterface assignedTime = line.addCell();
                    TableInterface.CellInterface assignedDate = line.addCell();
                    TableInterface.CellInterface assignedRoom = line.addCell();
                    ClassAssignmentDetails ca = ClassAssignmentDetails.createClassAssignmentDetails(context, this.courseTimetablingSolverService.getSolver(), c.getUniqueId(), false);
                    if (ca == null) {
                        try {
                            ClassAssignmentDetails.RoomInfo[] a = this.classAssignmentService.getAssignment().getAssignment(c);
                            if (a.getUniqueId() != null) {
                                ca = ClassAssignmentDetails.createClassAssignmentDetailsFromAssignment(context, a.getUniqueId(), false);
                            }
                        }
                        catch (Exception a) {
                            // empty catch block
                        }
                    }
                    if (ca != null) {
                        if (ca.getAssignedTime() != null) {
                            assignedTime.addItem(ca.getAssignedTime().toCell());
                            assignedDate.add(ca.getAssignedTime().getDatePatternName()).setColor(PreferenceLevel.int2color(ca.getAssignedTime().getDatePatternPreference()));
                        }
                        if (ca.getAssignedRoom() != null) {
                            for (ClassAssignmentDetails.RoomInfo room : ca.getAssignedRoom()) {
                                if (assignedRoom.hasItems()) {
                                    assignedRoom.add(", ");
                                }
                                assignedRoom.addItem(room.toCell());
                            }
                        }
                    }
                }
                if (!c.isCancelled().booleanValue() && ci.isLead().booleanValue()) {
                    Set<ClassAssignmentProxy.AssignmentInfo> conflicts = null;
                    try {
                        conflicts = this.classAssignmentService.getAssignment().getConflicts(c.getUniqueId());
                    }
                    catch (Exception assignedDate) {
                        // empty catch block
                    }
                    if (conflicts != null && !conflicts.isEmpty()) {
                        line.setBgColor("#fff0f0");
                        Object s = "";
                        for (ClassAssignmentProxy.AssignmentInfo x : conflicts) {
                            if (!((String)s).isEmpty()) {
                                s = (String)s + ", ";
                            }
                            s = (String)s + (x.getClassName() + " " + x.getPlacement().getName(CONST.useAmPm())).trim();
                        }
                        line.setWarning(MSG.classIsConflicting(c.getClassLabel(), (String)s));
                    } else {
                        Set<RoomAvailabilityInterface.TimeBlock> ec = null;
                        try {
                            ec = this.classAssignmentService.getAssignment().getConflictingTimeBlocks(c.getUniqueId());
                        }
                        catch (Exception assignedRoom) {
                            // empty catch block
                        }
                        if (ec != null && !ec.isEmpty()) {
                            Object s = "";
                            String lastName = null;
                            String lastType = null;
                            for (RoomAvailabilityInterface.TimeBlock t : ec) {
                                if (lastName != null && lastName.equals(t.getEventName()) && lastType.equals(t.getEventType())) continue;
                                lastName = t.getEventName();
                                lastType = t.getEventType();
                                if (!((String)s).isEmpty()) {
                                    s = (String)s + ", ";
                                }
                                s = (String)s + lastName + " (" + lastType + ")";
                            }
                            line.setBgColor("#fff0f0");
                            line.setWarning(MSG.classIsConflicting(c.getClassLabel(), (String)s));
                        }
                    }
                }
                if (context.hasPermission(c, Right.ClassDetail)) {
                    line.setURL("clazz?id=" + c.getUniqueId());
                }
                if ("PreferenceGroup".equals(request.getBackType()) && c.getUniqueId().toString().equals(request.getBackId())) {
                    line.getCells().get(0).addAnchor("back");
                }
                if (!c.isCancelled().booleanValue()) continue;
                line.setStyle("color: gray; font-style: italic;");
                line.setTitle(MSG.classNoteCancelled(c.getClassLabel()));
            }
            Navigation.set(context, Navigation.sClassLevel, classIds);
            response.setClasses(classTable);
        }
        if (ApplicationProperty.RoomAvailabilityIncludeInstructors.isTrue() && instructor.getExternalUniqueId() != null && !instructor.getExternalUniqueId().isEmpty() && RoomAvailability.getInstance() != null && RoomAvailability.getInstance() instanceof DefaultRoomAvailabilityService) {
            TableInterface eventTable = new TableInterface();
            eventTable.setName(MSG.sectionInstructorUnavailability());
            eventTable.setId("InstructorEventUnavailability");
            TableInterface.LineInterface header = eventTable.addHeader();
            header.addCell(MSG.columnEventName()).setSortable(true);
            header.addCell(MSG.columnEventType()).setSortable(true);
            header.addCell(MSG.columnEventDate()).setSortable(true);
            header.addCell(MSG.columnEventTime()).setSortable(true);
            header.addCell(MSG.columnEventRoom()).setSortable(true);
            for (TableInterface.CellInterface cell : header.getCells()) {
                cell.setClassName("WebTableHeader");
                cell.setText(cell.getText().replace("<br>", "\n"));
            }
            Formats.Format<Date> dfShort = Formats.getDateFormat(Formats.Pattern.DATE_EVENT_SHORT);
            Formats.Format<Date> dfLong = Formats.getDateFormat(Formats.Pattern.DATE_EVENT_LONG);
            HashMap<Event, HashSet<Meeting>> unavailabilities = new HashMap<Event, HashSet<Meeting>>();
            for (Meeting meeting : hibSession.createQuery("select distinct m from Event e inner join e.meetings m left outer join e.additionalContacts c, Session s where type(e) in (CourseEvent, SpecialEvent, UnavailableEvent) and m.meetingDate >= s.eventBeginDate and m.meetingDate <= s.eventEndDate and s.uniqueId = :sessionId and (e.mainContact.externalUniqueId = :user or c.externalUniqueId = :user) and m.approvalStatus = 1", Meeting.class).setParameter("sessionId", (Object)context.getUser().getCurrentAcademicSessionId()).setParameter("user", (Object)instructor.getExternalUniqueId()).setCacheable(true).list()) {
                HashSet<Meeting> meetings = (HashSet<Meeting>)unavailabilities.get(meeting.getEvent());
                if (meetings == null) {
                    meetings = new HashSet<Meeting>();
                    unavailabilities.put(meeting.getEvent(), meetings);
                }
                meetings.add(meeting);
            }
            for (Event event : new TreeSet(unavailabilities.keySet())) {
                for (Event.MultiMeeting m : Event.getMultiMeetings((Collection)unavailabilities.get(event))) {
                    line = eventTable.addLine();
                    line.addCell(event.getEventName());
                    line.addCell(event.getEventTypeAbbv());
                    line.addCell(m.getDays() + " " + (String)(m.getMeetings().size() == 1 ? dfLong.format(m.getMeetings().first().getMeetingDate()) : dfShort.format(m.getMeetings().first().getMeetingDate()) + " - " + dfLong.format(m.getMeetings().last().getMeetingDate())));
                    line.addCell(m.getMeetings().first().startTime() + " - " + m.getMeetings().first().stopTime());
                    if (m.getMeetings().first().getLocation() == null) {
                        line.addCell();
                        continue;
                    }
                    Location location = m.getMeetings().first().getLocation();
                    line.addCell(location.getLabel()).setMouseOver("$wnd.showGwtRoomHint($wnd.lastMouseOverElement, '" + location.getUniqueId() + "');").setMouseOut("$wnd.hideGwtRoomHint();");
                }
                response.setEvents(eventTable);
            }
        }
        ExaminationsTableBuilder examBuilder = new ExaminationsTableBuilder(context, null, null);
        response.setExaminations(examBuilder.createExamsTable("DepartmentalInstructor", instructor.getUniqueId(), this.examinationSolverService.getSolver()));
        if (CommonValues.Yes.eq(context.getUser().getProperty(UserProperty.DispInstructorPrefs))) {
            response.setPreferences(InstructorDetailBackend.getPreferenceTable(context, instructor, Preference.Type.ROOM_GROUP, Preference.Type.ROOM, Preference.Type.BUILDING, Preference.Type.ROOM_FEATURE, Preference.Type.COURSE, Preference.Type.DISTRIBUTION));
        }
        if (context.hasPermission(Right.InstructorScheduling) && context.hasPermission(instructor.getDepartment(), Right.InstructorAssignmentPreferences)) {
            response.addOperation("teaching-assignments");
        }
        if (CommonValues.Yes.eq(context.getUser().getProperty(UserProperty.DisplayLastChanges))) {
            response.setLastChanges(this.getLastChanges(instructor));
        }
        if (context.hasPermission(Right.InstructorScheduling) && context.hasPermission(instructor.getDepartment(), Right.InstructorAssignmentPreferences)) {
            response.addOperation("teaching-assignments");
        }
        if (context.hasPermission(instructor, Right.InstructorEdit)) {
            response.addOperation("edit");
        }
        if (context.hasPermission(instructor.getDepartment(), Right.InstructorAssignmentPreferences)) {
            response.addOperation("assignment");
        }
        if (context.hasPermission(instructor, Right.InstructorPreferences)) {
            response.addOperation("preferences");
        }
        if (context.hasPermission(instructor, Right.InstructorEdit)) {
            response.addOperation("edit");
        }
        if (instructor.getExternalUniqueId() != null && !instructor.getExternalUniqueId().isEmpty()) {
            if (context.hasPermission(instructor.getDepartment(), Right.InstructorSurveyAdmin)) {
                response.addOperation("survey");
            } else if (context.getUser().getExternalUserId().equals(instructor.getExternalUniqueId()) && context.hasPermission(instructor.getDepartment(), Right.InstructorSurvey)) {
                response.addOperation("survey");
            }
        }
        if (response.getPreviousId() != null && context.hasPermission(response.getPreviousId(), "DepartmentalInstructor", Right.InstructorDetail)) {
            response.addOperation("previous");
        }
        if (response.getNextId() != null && context.hasPermission(response.getNextId(), "DepartmentalInstructor", Right.InstructorDetail)) {
            response.addOperation("next");
        }
        if ((back = BackTracker.getBackItem(context, 2)) != null) {
            response.addOperation("back");
            response.setBackTitle(back.getTitle());
            response.setBackUrl(back.getUrl() + (back.getUrl().indexOf(63) >= 0 ? "&" : "?") + "backId=" + instructor.getUniqueId() + "&backType=PreferenceGroup");
        }
        return response;
    }

    public static TableInterface getPreferenceTable(SessionContext context, DepartmentalInstructor instructor, Preference.Type ... types) {
        TableInterface preferences = SubpartDetailBackend.getPreferenceTable(context, instructor, types);
        for (Preference pref : instructor.getPreferences()) {
            if (!(pref instanceof TimePref)) continue;
            TableInterface.CellInterface c = null;
            if (preferences == null) {
                preferences = new TableInterface();
                c = preferences.addProperty(MSG.propertyTime());
                preferences.addProperty(SubpartDetailBackend.getLegend(false));
            } else {
                c = new TableInterface.CellInterface();
                TableInterface.PropertyInterface av = new TableInterface.PropertyInterface().setName(MSG.propertyTime()).setCell(c);
                preferences.getProperties().add(0, av);
            }
            c.addWidget().setId("UniTimeGWT:InstructorAvailability").setContent(((TimePref)pref).getPreference());
            break;
        }
        if (instructor.hasUnavailabilities()) {
            TableInterface.CellInterface c = null;
            if (preferences == null) {
                preferences = new TableInterface();
                c = preferences.addProperty(MSG.propertyUnavailableDates());
            } else {
                c = new TableInterface.CellInterface();
                preferences.getProperties().add(preferences.getProperties().size() - 1, new TableInterface.PropertyInterface().setName(MSG.propertyUnavailableDates()).setCell(c));
            }
            c.addWidget().setId("UniTimeGWT:InstructorUnavailability").setContent(instructor.getUnavailablePattern());
        }
        return preferences;
    }

    protected int printLastChangeTableRow(TableInterface table, ChangeLog lastChange) {
        if (lastChange == null) {
            return 0;
        }
        TableInterface.LineInterface line = table.addLine();
        line.addCell(lastChange.getSourceTitle());
        line.addCell(lastChange.getObjectTitle());
        line.addCell(lastChange.getOperationTitle());
        line.addCell(lastChange.getManager().getShortName());
        line.addCell(ChangeLog.sDF.format(lastChange.getTimeStamp()));
        return 1;
    }

    protected ChangeLog combine(ChangeLog c1, ChangeLog c2) {
        if (c1 == null) {
            return c2;
        }
        if (c2 == null) {
            return c1;
        }
        return c1.compareTo(c2) < 0 ? c2 : c1;
    }

    public TableInterface getLastChanges(DepartmentalInstructor inst) {
        if (inst == null) {
            return null;
        }
        TableInterface table = new TableInterface();
        int nrChanges = 0;
        table.setName(MSG.columnLastChanges());
        TableInterface.LineInterface header = table.addHeader();
        header.addCell(MSG.columnPage());
        header.addCell(MSG.columnObject());
        header.addCell(MSG.columnOperation());
        header.addCell(MSG.columnManager());
        header.addCell(MSG.columnDate());
        for (TableInterface.CellInterface cell : header.getCells()) {
            cell.setClassName("WebTableHeader");
            cell.setText(cell.getText().replace("<br>", "\n"));
        }
        nrChanges += this.printLastChangeTableRow(table, this.combine(ChangeLog.findLastChange(inst, ChangeLog.Source.INSTRUCTOR_EDIT), ChangeLog.findLastChange(inst, ChangeLog.Source.INSTRUCTOR_MANAGE)));
        nrChanges += this.printLastChangeTableRow(table, ChangeLog.findLastChange(inst, ChangeLog.Source.INSTRUCTOR_PREF_EDIT));
        if ((nrChanges += this.printLastChangeTableRow(table, ChangeLog.findLastChange(inst, ChangeLog.Source.INSTRUCTOR_ASSIGNMENT_PREF_EDIT))) > 0) {
            return table;
        }
        return null;
    }
}

