/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.courses;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.hibernate.query.Query;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.client.tables.TableInterface;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.DistributionObject;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.ExamOwner;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.PreferenceGroup;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.comparators.ClassComparator;
import org.unitime.timetable.model.comparators.ClassInstructorComparator;
import org.unitime.timetable.model.dao.DistributionPrefDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.courses.TableBuilder;

public class DistributionsTableBuilder
extends TableBuilder {
    public DistributionsTableBuilder(SessionContext context, String backType, String backId) {
        super(context, backType, backId);
    }

    public TableInterface getDistPrefsTableForInstructionalOffering(InstructionalOffering instructionalOffering) {
        HashSet<DepartmentalInstructor> leadInstructors = new HashSet<DepartmentalInstructor>();
        TreeSet<DistributionPref> prefs = new TreeSet<DistributionPref>();
        for (InstrOfferingConfig config : instructionalOffering.getInstrOfferingConfigs()) {
            for (SchedulingSubpart subpart : config.getSchedulingSubparts()) {
                prefs.addAll(subpart.getDistributionPreferences());
                for (Class_ clazz : subpart.getClasses()) {
                    prefs.addAll(clazz.getDistributionPreferences());
                    leadInstructors.addAll(clazz.getLeadInstructors());
                }
            }
        }
        for (DepartmentalInstructor instructor : leadInstructors) {
            prefs.addAll(instructor.getDistributionPreferences());
        }
        return this.createTableForDistributions(prefs);
    }

    public TableInterface getDistPrefsTableForSchedulingSupart(SchedulingSubpart subpart) {
        HashSet<DepartmentalInstructor> leadInstructors = new HashSet<DepartmentalInstructor>();
        TreeSet<DistributionPref> prefs = new TreeSet<DistributionPref>();
        prefs.addAll(subpart.getDistributionPreferences());
        for (Class_ clazz : subpart.getClasses()) {
            prefs.addAll(clazz.getDistributionPreferences());
            leadInstructors.addAll(clazz.getLeadInstructors());
        }
        for (DepartmentalInstructor instructor : leadInstructors) {
            prefs.addAll(instructor.getDistributionPreferences());
        }
        return this.createTableForDistributions(prefs);
    }

    public TableInterface getDistPrefsTableForClass(Class_ clazz) {
        HashSet<DepartmentalInstructor> leadInstructors = new HashSet<DepartmentalInstructor>();
        TreeSet<DistributionPref> prefs = new TreeSet<DistributionPref>();
        prefs.addAll(clazz.getSchedulingSubpart().getDistributionPreferences());
        prefs.addAll(clazz.getDistributionPreferences());
        leadInstructors.addAll(clazz.getLeadInstructors());
        for (DepartmentalInstructor instructor : leadInstructors) {
            prefs.addAll(instructor.getDistributionPreferences());
        }
        return this.createTableForDistributions(prefs);
    }

    public TableInterface getDistPrefsTableForExam(Exam exam) {
        return this.createTableForExamDistributions(new TreeSet<DistributionPref>(exam.effectivePreferences(DistributionPref.class)));
    }

    public TableInterface getDistPrefsTableForFilter(TableInterface.FilterInterface filter, Long subjAreaId) {
        TreeSet<DistributionPref> prefs = new TreeSet<DistributionPref>();
        String courseNbr = filter.getParameterValue("courseNbr");
        for (Department d : Department.getUserDepartments(this.getSessionContext().getUser())) {
            prefs.addAll(DistributionPref.getPreferences(this.getSessionContext().getUser().getCurrentAcademicSessionId(), d.getUniqueId(), true, null, subjAreaId, courseNbr == null || courseNbr.length() == 0 ? null : courseNbr));
            prefs.addAll(DistributionPref.getInstructorPreferences(this.getSessionContext().getUser().getCurrentAcademicSessionId(), d.getUniqueId(), subjAreaId, courseNbr == null || courseNbr.length() == 0 ? null : courseNbr));
        }
        String prefLevel = filter.getParameterValue("prefLevel");
        String distType = filter.getParameterValue("distType");
        String structure = filter.getParameterValue("structure");
        Iterator i = prefs.iterator();
        while (i.hasNext()) {
            boolean match;
            DistributionPref dp = (DistributionPref)i.next();
            if (prefLevel != null && !prefLevel.isEmpty()) {
                match = false;
                for (String prefId : prefLevel.split(",")) {
                    if (!dp.getPrefLevel().getUniqueId().toString().equals(prefId)) continue;
                    match = true;
                    break;
                }
                if (!match) {
                    i.remove();
                    continue;
                }
            }
            if (distType != null && !distType.isEmpty()) {
                match = false;
                for (String typeId : distType.split(",")) {
                    if (!dp.getDistributionType().getUniqueId().toString().equals(typeId)) continue;
                    match = true;
                    break;
                }
                if (!match) {
                    i.remove();
                    continue;
                }
            }
            if (structure == null || structure.isEmpty()) continue;
            match = false;
            for (String structureName : structure.split(",")) {
                if ("instructor".equals(structureName) && dp.getStructure() == null) {
                    match = true;
                    break;
                }
                if (dp.getStructure() == null || !dp.getStructure().name().equals(structureName)) continue;
                match = true;
                break;
            }
            if (match) continue;
            i.remove();
        }
        return this.createTableForDistributions(prefs);
    }

    public TableInterface createTableForDistributions(Collection<DistributionPref> distPrefs) {
        TableInterface table = new TableInterface();
        table.setId("Distributions");
        table.setName(MSG.sectionTitleDistributionPreferences());
        TableInterface.LineInterface header = table.addHeader();
        if (this.isSimple()) {
            header.addCell(MSG.columnDistrPrefLevel()).setSortable(true);
        }
        header.addCell(MSG.columnDistrPrefType()).setSortable(true);
        header.addCell(MSG.columnDistrPrefStructure()).setSortable(true);
        header.addCell(MSG.columnDistrPrefOwner()).setSortable(true);
        header.addCell(MSG.columnDistrPrefClass()).setSortable(true);
        for (TableInterface.CellInterface cell : header.getCells()) {
            cell.setClassName("WebTableHeader");
            cell.setText(cell.getText().replace("<br>", "\n"));
            cell.addStyle("white-space: pre-wrap;");
        }
        int nrPrefs = 0;
        boolean suffix = ApplicationProperty.DistributionsShowClassSufix.isTrue();
        for (DistributionPref dp : distPrefs) {
            if (!this.getSessionContext().hasPermission(dp, Right.DistributionPreferenceDetail)) continue;
            ++nrPrefs;
            TableInterface.CellInterface obj = new TableInterface.CellInterface().setNoWrap(true);
            TableInterface.CellInterface ownerType = new TableInterface.CellInterface().setText(MSG.ownerUnknown());
            PreferenceGroup pg = dp.getOwner();
            if (pg instanceof Department) {
                Department d = (Department)pg;
                ownerType.setText(d.getShortLabel()).setTitle(d.getHtmlTitle());
            }
            for (DistributionObject dO : dp.getOrderedSetOfDistributionObjects()) {
                obj.add(dO.preferenceText(suffix)).setInline(false);
            }
            Object groupingText = dp.getStructureName();
            if (pg instanceof DepartmentalInstructor) {
                DepartmentalInstructor instructor = (DepartmentalInstructor)pg;
                TreeSet<Department> owners = new TreeSet<Department>();
                TreeSet<ClassInstructor> classes = new TreeSet<ClassInstructor>(new ClassInstructorComparator(new ClassComparator(5)));
                classes.addAll(instructor.getClasses());
                for (ClassInstructor clazz : classes) {
                    if (!clazz.isLead().booleanValue()) continue;
                    obj.add(clazz.getClassInstructing().getClassLabel(suffix)).setInline(false).setNoWrap(true);
                    Department dept = clazz.getClassInstructing().getManagingDept();
                    if (!dept.isInheritInstructorPreferences().booleanValue()) continue;
                    owners.add(dept);
                }
                ownerType.setText((String)null);
                for (Department owner : owners) {
                    ownerType.add(owner.getShortLabel()).setTitle(owner.getHtmlTitle()).setInline(false).setNoWrap(true);
                }
                groupingText = MSG.columnInstructor() + " " + instructor.getName(this.getInstructorNameFormat());
                if (owners.isEmpty()) continue;
            }
            String distType = dp.getDistributionType().getLabel();
            String prefLevel = dp.getPrefLevel().getPrefName();
            String prefColor = dp.getPrefLevel().prefcolor();
            if (PreferenceLevel.sNeutral.equals(dp.getPrefLevel().getPrefProlog())) {
                prefColor = "#808080";
            }
            TableInterface.LineInterface line = table.addLine();
            if (pg instanceof DepartmentalInstructor) {
                if (this.getSessionContext().hasPermission(pg, Right.InstructorDetail)) {
                    line.setURL("instructorDetail.action?instructorId=" + dp.getOwner().getUniqueId() + "&op=Show%20Instructor%20Preferences");
                }
            } else if (this.getSessionContext().hasPermission(dp, Right.DistributionPreferenceEdit)) {
                if (ApplicationProperty.LegacyDistributions.isTrue()) {
                    line.setURL("distributionPrefs.action?dp=" + dp.getUniqueId() + "&op=view");
                } else {
                    line.setURL("distributionEdit?id=" + dp.getUniqueId());
                }
            }
            if (this.isSimple()) {
                line.addCell(prefLevel).setColor(prefColor).setNoWrap(true);
            }
            line.addCell(distType).setColor(prefColor).setTitle(prefLevel + " " + distType).setAria((String)(this.isSimple() ? distType : prefLevel + " " + distType)).setNoWrap(true).setComparable((Comparable<?>)((Object)distType));
            line.addCell((String)groupingText).setNoWrap(true);
            line.addCell(ownerType);
            line.addCell(obj);
            if ("DistributionPref".equals(this.getBackType()) && dp.getUniqueId().toString().equals(this.getBackId())) {
                line.getCells().get(0).addAnchor("back");
                continue;
            }
            if (!"PreferenceGroup".equals(this.getBackType()) || !dp.getOwner().getUniqueId().toString().equals(this.getBackId())) continue;
            line.getCells().get(0).addAnchor("back");
        }
        if (nrPrefs == 0) {
            table.addLine().addCell(MSG.noPreferencesFound()).setColSpan(4);
        }
        return table;
    }

    public TableInterface getExamDistPrefsTableForFilter(TableInterface.FilterInterface filter, ExamType examType) {
        Object[] subjectAreas = filter.getParameterValue("subjectArea").split(",");
        String courseNbr = filter.getParameterValue("courseNbr");
        Object query = "select distinct dp from DistributionPref dp inner join dp.distributionObjects do, Exam x inner join x.owners o where dp.distributionType.examPref = true and x.session.uniqueId = :sessionId and do.prefGroup = x and x.examType.uniqueId = :examTypeId";
        boolean hasCourseNbr = false;
        if (courseNbr != null && !courseNbr.trim().isEmpty()) {
            query = (String)query + " and o.course.courseNbr like :courseNbr";
            hasCourseNbr = true;
        }
        boolean hasSubjectAreas = false;
        if (subjectAreas.length > 0 && !"-1".equals(subjectAreas[0])) {
            hasSubjectAreas = true;
            query = (String)query + " and cast(o.course.subjectArea.uniqueId as string) in :subjectAreas";
        }
        Query q = DistributionPrefDAO.getInstance().getSession().createQuery((String)query, DistributionPref.class).setParameter("sessionId", (Object)this.getSessionContext().getUser().getCurrentAcademicSessionId()).setParameter("examTypeId", (Object)examType.getUniqueId());
        if (hasCourseNbr) {
            q.setParameter("courseNbr", (Object)courseNbr.replace("*", "%"));
        }
        if (hasSubjectAreas) {
            q.setParameterList("subjectAreas", subjectAreas);
        }
        List prefs = q.setCacheable(true).list();
        String prefLevel = filter.getParameterValue("prefLevel");
        String distType = filter.getParameterValue("distType");
        Iterator i = prefs.iterator();
        while (i.hasNext()) {
            boolean match;
            DistributionPref dp = (DistributionPref)i.next();
            if (prefLevel != null && !prefLevel.isEmpty()) {
                match = false;
                for (String prefId : prefLevel.split(",")) {
                    if (!dp.getPrefLevel().getUniqueId().toString().equals(prefId)) continue;
                    match = true;
                    break;
                }
                if (!match) {
                    i.remove();
                    continue;
                }
            }
            if (distType == null || distType.isEmpty()) continue;
            match = false;
            for (String typeId : distType.split(",")) {
                if (!dp.getDistributionType().getUniqueId().toString().equals(typeId)) continue;
                match = true;
                break;
            }
            if (match) continue;
            i.remove();
        }
        return this.createTableForExamDistributions(prefs);
    }

    public TableInterface createTableForExamDistributions(Collection<DistributionPref> distPrefs) {
        TableInterface table = new TableInterface();
        table.setId("ExamDistributions");
        table.setName(MSG.sectionTitleDistributionPreferences());
        TableInterface.LineInterface header = table.addHeader();
        if (this.isSimple()) {
            header.addCell(MSG.columnDistrPrefLevel());
        }
        header.addCell(MSG.columnDistrPrefType()).setSortable(true);
        header.addCell(MSG.columnExam()).setSortable(true);
        header.addCell(MSG.columnExamClassesCourses()).setSortable(true);
        for (TableInterface.CellInterface cell : header.getCells()) {
            cell.setClassName("WebTableHeader");
            cell.setText(cell.getText().replace("<br>", "\n"));
            cell.addStyle("white-space: pre-wrap;");
        }
        int nrPrefs = 0;
        for (DistributionPref dp : distPrefs) {
            if (!this.getSessionContext().hasPermission(dp, Right.ExaminationDistributionPreferenceDetail)) continue;
            ++nrPrefs;
            TableInterface.CellInterface examStr = new TableInterface.CellInterface().setNoWrap(true);
            TableInterface.CellInterface objectStr = new TableInterface.CellInterface().setNoWrap(true);
            for (DistributionObject dO : dp.getOrderedSetOfDistributionObjects()) {
                Exam exam = (Exam)dO.getPrefGroup();
                examStr.add(exam.getLabel()).setInline(false);
                boolean first = true;
                for (ExamOwner owner : exam.getOwners()) {
                    objectStr.add(owner.getLabel()).setInline(false);
                    if (first) {
                        first = false;
                        continue;
                    }
                    examStr.add("\u00a0").setInline(false);
                }
            }
            String distType = dp.getDistributionType().getLabel();
            String prefLevel = dp.getPrefLevel().getPrefName();
            String prefColor = dp.getPrefLevel().prefcolor();
            if (PreferenceLevel.sNeutral.equals(dp.getPrefLevel().getPrefProlog())) {
                prefColor = "#808080";
            }
            TableInterface.LineInterface line = table.addLine();
            if (this.getSessionContext().hasPermission(dp, Right.ExaminationDistributionPreferenceEdit)) {
                line.setURL(ApplicationProperty.LegacyExamDistributions.isTrue() ? "examDistributionPrefs.action?dp=" + dp.getUniqueId() + "&op=view" : "examDistributionEdit?id=" + dp.getUniqueId());
            }
            if (this.isSimple()) {
                line.addCell(prefLevel).setColor(prefColor).setNoWrap(true);
            }
            line.addCell(distType).setColor(prefColor).setTitle(prefLevel + " " + distType).setAria((String)(this.isSimple() ? distType : prefLevel + " " + distType)).setNoWrap(true).setComparable((Comparable<?>)((Object)distType));
            line.addCell(examStr);
            line.addCell(objectStr);
            if ("DistributionPref".equals(this.getBackType()) && dp.getUniqueId().toString().equals(this.getBackId())) {
                line.getCells().get(0).addAnchor("back");
                continue;
            }
            if (!"PreferenceGroup".equals(this.getBackType()) || !dp.getOwner().getUniqueId().toString().equals(this.getBackId())) continue;
            line.getCells().get(0).addAnchor("back");
        }
        if (nrPrefs == 0) {
            table.addLine().addCell(MSG.noPreferencesFound()).setColSpan(4);
        }
        return table;
    }
}

