/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.courses;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.unitime.commons.Debug;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.ConstantsMessages;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.client.offerings.PrefGroupEditInterface;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.command.server.GwtRpcLogging;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DistributionObject;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.DistributionType;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.PreferenceGroup;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.StudentSectioningQueue;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.base.BaseDepartment;
import org.unitime.timetable.model.base.BasePreferenceGroup;
import org.unitime.timetable.model.comparators.ClassComparator;
import org.unitime.timetable.model.comparators.SchedulingSubpartComparator;
import org.unitime.timetable.model.dao.Class_DAO;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.model.dao.DistributionPrefDAO;
import org.unitime.timetable.model.dao.DistributionTypeDAO;
import org.unitime.timetable.model.dao.PreferenceLevelDAO;
import org.unitime.timetable.model.dao.SchedulingSubpartDAO;
import org.unitime.timetable.security.Qualifiable;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.permissions.Permission;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.spring.SpringApplicationContextHolder;
import org.unitime.timetable.webutil.BackTracker;
import org.unitime.timetable.webutil.JavascriptFunctions;

@GwtRpcImplements(value=PrefGroupEditInterface.DistributionEditRequest.class)
public class DistributionEditBackend
implements GwtRpcImplementation<PrefGroupEditInterface.DistributionEditRequest, PrefGroupEditInterface.DistributionEditResponse> {
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    protected static final ConstantsMessages CMSG = Localization.create(ConstantsMessages.class);

    @Override
    public PrefGroupEditInterface.DistributionEditResponse execute(PrefGroupEditInterface.DistributionEditRequest request, SessionContext context) {
        BackTracker.BackItem back;
        SchedulingSubpart ss;
        Class_ clazz;
        CourseOffering co;
        DistributionPref dp;
        if (request.getPreferenceId() == null) {
            context.checkPermission(Right.DistributionPreferenceAdd);
        } else {
            context.checkPermission(request.getPreferenceId(), "DistributionPref", Right.DistributionPreferenceEdit);
        }
        if (request.getOperation() == PrefGroupEditInterface.DistributionEditRequest.Operation.DELETE) {
            this.deleteDistPref(request.getPreferenceId(), context);
            return null;
        }
        if (request.getOperation() == PrefGroupEditInterface.DistributionEditRequest.Operation.SAVE) {
            PrefGroupEditInterface.DistributionEditResponse response = request.getData();
            this.updateDistPref(response, context);
            BackTracker.BackItem back2 = BackTracker.getBackItem(context, 1);
            if (back2 != null) {
                response.setBackTitle(back2.getTitle());
                response.setBackUrl(back2.getUrl() + (String)(request.getPreferenceId() == null ? "" : (back2.getUrl().indexOf(63) >= 0 ? "&" : "?") + "backId=" + request.getPreferenceId() + "&backType=DistributionPref"));
            }
            return response;
        }
        PrefGroupEditInterface.DistributionEditResponse response = new PrefGroupEditInterface.DistributionEditResponse();
        for (PreferenceLevel pref : PreferenceLevel.getPreferenceLevelList(false)) {
            response.addPrefLevel(pref.getUniqueId(), pref.getPrefName(), PreferenceLevel.prolog2char(pref.getPrefProlog()));
        }
        for (DistributionType dt : DistributionType.findAll(false, false, true)) {
            response.addDistType(dt.getUniqueId(), dt.getLabel(), dt.getDescr(), dt.getAllowedPref());
        }
        for (Iterator<Serializable> iterator : DistributionPref.Structure.values()) {
            response.addStructure(((Enum)((Object)iterator)).ordinal(), ((DistributionPref.Structure)((Object)iterator)).getName(), ((DistributionPref.Structure)((Object)iterator)).getDescription());
        }
        for (SubjectArea subject : SubjectArea.getUserSubjectAreas(context.getUser(), true)) {
            response.addSubject(subject.getUniqueId(), subject.getSubjectAreaAbbreviation(), subject.getLabel());
        }
        DistributionPref distributionPref = dp = request.getPreferenceId() == null ? null : (DistributionPref)DistributionPrefDAO.getInstance().get(request.getPreferenceId());
        if (dp != null) {
            response.setPreferenceId(dp.getUniqueId());
            response.setDistTypeId(dp.getDistributionType().getUniqueId());
            if (response.getDistType(dp.getDistributionType().getUniqueId()) == null) {
                response.addDistType(dp.getDistributionType().getUniqueId(), dp.getDistributionType().getLabel(), dp.getDistributionType().getDescr(), dp.getDistributionType().getAllowedPref());
            }
            response.setPrefLevelId(dp.getPrefLevel().getUniqueId());
            response.setStructureId(dp.getStructure() == null ? null : Long.valueOf(dp.getStructure().ordinal()));
            response.setCanDelete(context.hasPermission(dp, Right.DistributionPreferenceDelete));
            for (DistributionObject distObj : dp.getOrderedSetOfDistributionObjects()) {
                PrefGroupEditInterface.DistributionObjectInterface distributionObjectInterface = new PrefGroupEditInterface.DistributionObjectInterface();
                if (distObj.getPrefGroup() instanceof SchedulingSubpart) {
                    SchedulingSubpart ss2 = (SchedulingSubpart)distObj.getPrefGroup();
                    co = ss2.getControllingCourseOffering();
                    distributionObjectInterface.setSubpartId(ss2.getUniqueId());
                    distributionObjectInterface.setSubpart(DistributionEditBackend.getSubpartLabel(ss2));
                    distributionObjectInterface.setClassId(-1L);
                    distributionObjectInterface.setClazz(MSG.dropDistrPrefAll());
                } else {
                    if (!(distObj.getPrefGroup() instanceof Class_)) continue;
                    Class_ clazz2 = (Class_)distObj.getPrefGroup();
                    SchedulingSubpart ss3 = clazz2.getSchedulingSubpart();
                    co = ss3.getControllingCourseOffering();
                    distributionObjectInterface.setSubpartId(ss3.getUniqueId());
                    distributionObjectInterface.setSubpart(DistributionEditBackend.getSubpartLabel(ss3));
                    distributionObjectInterface.setClassId(clazz2.getUniqueId());
                    distributionObjectInterface.setClazz(DistributionEditBackend.getClassLabel(clazz2));
                }
                distributionObjectInterface.setSubjectId(co.getSubjectArea().getUniqueId());
                distributionObjectInterface.setSubject(co.getSubjectAreaAbbv());
                distributionObjectInterface.setCourseId(co.getUniqueId());
                distributionObjectInterface.setCourse(co.getCourseNumberWithTitle());
                response.addDistributionObject(distributionObjectInterface);
            }
        } else {
            response.setCanDelete(false);
        }
        if (request.getClassId() != null && (clazz = (Class_)Class_DAO.getInstance().get(request.getClassId())) != null) {
            PrefGroupEditInterface.DistributionObjectInterface doi = new PrefGroupEditInterface.DistributionObjectInterface();
            SchedulingSubpart schedulingSubpart = clazz.getSchedulingSubpart();
            co = schedulingSubpart.getControllingCourseOffering();
            doi.setSubpartId(schedulingSubpart.getUniqueId());
            doi.setSubpart(DistributionEditBackend.getSubpartLabel(schedulingSubpart));
            doi.setClassId(clazz.getUniqueId());
            doi.setClazz(DistributionEditBackend.getClassLabel(clazz));
            doi.setSubjectId(co.getSubjectArea().getUniqueId());
            doi.setSubject(co.getSubjectAreaAbbv());
            doi.setCourseId(co.getUniqueId());
            doi.setCourse(co.getCourseNumberWithTitle());
            response.addDistributionObject(doi);
        }
        if (request.getSubpartId() != null && (ss = (SchedulingSubpart)SchedulingSubpartDAO.getInstance().get(request.getSubpartId())) != null) {
            PrefGroupEditInterface.DistributionObjectInterface doi = new PrefGroupEditInterface.DistributionObjectInterface();
            CourseOffering courseOffering = ss.getControllingCourseOffering();
            doi.setSubpartId(ss.getUniqueId());
            doi.setSubpart(DistributionEditBackend.getSubpartLabel(ss));
            doi.setClassId(-1L);
            doi.setClazz(MSG.dropDistrPrefAll());
            doi.setSubjectId(courseOffering.getSubjectArea().getUniqueId());
            doi.setSubject(courseOffering.getSubjectAreaAbbv());
            doi.setCourseId(courseOffering.getUniqueId());
            doi.setCourse(courseOffering.getCourseNumberWithTitle());
            response.addDistributionObject(doi);
        }
        if ((back = BackTracker.getBackItem(context, 1)) != null) {
            response.setBackTitle(back.getTitle());
            response.setBackUrl(back.getUrl() + (String)(request.getPreferenceId() == null ? "" : (back.getUrl().indexOf(63) >= 0 ? "&" : "?") + "backId=" + request.getPreferenceId() + "&backType=DistributionPref"));
        }
        response.setConfirms(JavascriptFunctions.isJsConfirm(context));
        return response;
    }

    protected static String getSubpartLabel(SchedulingSubpart ss) {
        Object subpart = ss.getItypeDesc().trim();
        String suffix = ss.getSchedulingSubpartSuffix();
        if (suffix != null && !suffix.isEmpty()) {
            subpart = (String)subpart + " (" + suffix + ")";
        }
        if (ss.getInstrOfferingConfig().getInstructionalOffering().getInstrOfferingConfigs().size() > 1) {
            subpart = (String)subpart + " [" + ss.getInstrOfferingConfig().getName() + "]";
        }
        while (ss.getParentSubpart() != null) {
            subpart = "\u00a0\u00a0" + (String)subpart;
            ss = ss.getParentSubpart();
        }
        return subpart;
    }

    protected static String getClassLabel(Class_ c) {
        if (ApplicationProperty.DistributionsShowClassSufix.isTrue()) {
            String extId = c.getClassSuffix(c.getSchedulingSubpart().getControllingCourseOffering());
            return c.getSectionNumberString() + (String)(extId == null || extId.isEmpty() || extId.equalsIgnoreCase(c.getSectionNumberString()) ? "" : " - " + extId);
        }
        return c.getSectionNumberString();
    }

    protected void deleteDistPref(Long distPrefId, SessionContext context) {
        block7: {
            Transaction tx = null;
            try {
                DistributionPrefDAO dpDao = DistributionPrefDAO.getInstance();
                Session hibSession = dpDao.getSession();
                tx = hibSession.getTransaction();
                if (tx == null || !tx.isActive()) {
                    tx = hibSession.beginTransaction();
                }
                HashSet<InstructionalOffering> relatedInstructionalOfferings = new HashSet<InstructionalOffering>();
                DistributionPref dp = (DistributionPref)dpDao.get(Long.valueOf(distPrefId));
                context.checkPermission(dp, Right.DistributionPreferenceDelete);
                Department dept = (Department)dp.getOwner();
                dept.getPreferences().remove(dp);
                for (DistributionObject dObj : dp.getDistributionObjects()) {
                    PreferenceGroup pg = dObj.getPrefGroup();
                    relatedInstructionalOfferings.add((pg instanceof Class_ ? ((Class_)pg).getSchedulingSubpart() : (SchedulingSubpart)pg).getInstrOfferingConfig().getInstructionalOffering());
                    pg.getDistributionObjects().remove(dObj);
                    hibSession.merge((Object)pg);
                }
                hibSession.remove((Object)dp);
                hibSession.merge((Object)dept);
                Permission permissionOfferingLockNeeded = this.getPermission("permissionOfferingLockNeeded");
                ArrayList<Long> changedOfferingIds = new ArrayList<Long>();
                for (InstructionalOffering io : relatedInstructionalOfferings) {
                    ChangeLog.addChange(hibSession, context, io, ChangeLog.Source.DIST_PREF_EDIT, ChangeLog.Operation.DELETE, io.getControllingCourseOffering().getSubjectArea(), null);
                    if (!permissionOfferingLockNeeded.check(context.getUser(), io)) continue;
                    changedOfferingIds.add(io.getUniqueId());
                }
                if (!changedOfferingIds.isEmpty()) {
                    StudentSectioningQueue.offeringChanged(hibSession, context.getUser(), context.getUser().getCurrentAcademicSessionId(), changedOfferingIds);
                }
                if (tx != null && tx.isActive()) {
                    tx.commit();
                }
                hibSession.flush();
                hibSession.refresh((Object)dept);
            }
            catch (Exception e) {
                Debug.error(e);
                if (tx == null || !tx.isActive()) break block7;
                tx.rollback();
            }
        }
    }

    protected void updateDistPref(PrefGroupEditInterface.DistributionEditResponse data, SessionContext context) {
        DistributionPref dp = null;
        Department oldOwner = null;
        DistributionPrefDAO dpDao = DistributionPrefDAO.getInstance();
        Transaction tx = null;
        Session hibSession = dpDao.getSession();
        HashSet<InstructionalOffering> relatedInstructionalOfferings = new HashSet<InstructionalOffering>();
        try {
            tx = hibSession.beginTransaction();
            if (data.getPreferenceId() != null) {
                dp = (DistributionPref)DistributionPrefDAO.getInstance().get(data.getPreferenceId(), hibSession);
                Set<DistributionObject> s = dp.getDistributionObjects();
                for (DistributionObject dObj : s) {
                    PreferenceGroup pg = dObj.getPrefGroup();
                    relatedInstructionalOfferings.add((pg instanceof Class_ ? ((Class_)pg).getSchedulingSubpart() : (SchedulingSubpart)pg).getInstrOfferingConfig().getInstructionalOffering());
                    pg.getDistributionObjects().remove(dObj);
                    hibSession.remove((Object)dObj);
                }
                s.clear();
                dp.setDistributionObjects(s);
                oldOwner = (Department)dp.getOwner();
            } else {
                dp = new DistributionPref();
            }
            dp.setDistributionType((DistributionType)DistributionTypeDAO.getInstance().get(data.getDistTypeId(), hibSession));
            dp.setStructure(DistributionPref.Structure.values()[data.getStructureId().intValue()]);
            dp.setPrefLevel((PreferenceLevel)PreferenceLevelDAO.getInstance().get(data.getPrefLevelId(), hibSession));
            BasePreferenceGroup owningDept = null;
            ArrayList<DistributionObject> distributionObjects = new ArrayList<DistributionObject>();
            for (int i = 0; i < data.getDistributionObjects().size(); ++i) {
                PrefGroupEditInterface.DistributionObjectInterface doi = data.getDistributionObjects().get(i);
                DistributionObject dObj = new DistributionObject();
                if (doi.getClassId() == null || doi.getClassId() < 0L) {
                    SchedulingSubpart subpart = (SchedulingSubpart)SchedulingSubpartDAO.getInstance().get(doi.getSubpartId(), hibSession);
                    if (owningDept == null) {
                        owningDept = subpart.getManagingDept();
                    } else if (!owningDept.getUniqueId().equals(subpart.getManagingDept().getUniqueId())) {
                        if (((BaseDepartment)owningDept).getDistributionPrefPriority() < subpart.getManagingDept().getDistributionPrefPriority()) {
                            owningDept = subpart.getManagingDept();
                        } else if (((BaseDepartment)owningDept).getDistributionPrefPriority().intValue() == subpart.getManagingDept().getDistributionPrefPriority().intValue() && !context.getUser().getCurrentAuthority().hasQualifier((Qualifiable)((Object)owningDept)) && context.getUser().getCurrentAuthority().hasQualifier(subpart.getManagingDept())) {
                            owningDept = subpart.getManagingDept();
                        }
                    }
                    dObj.setPrefGroup(subpart);
                    relatedInstructionalOfferings.add(subpart.getInstrOfferingConfig().getInstructionalOffering());
                } else {
                    Class_ clazz = (Class_)new Class_DAO().get(doi.getClassId(), hibSession);
                    if (owningDept == null) {
                        owningDept = clazz.getManagingDept();
                    } else if (!((BaseDepartment)owningDept).equals(clazz.getManagingDept())) {
                        if (((BaseDepartment)owningDept).getDistributionPrefPriority() < clazz.getManagingDept().getDistributionPrefPriority()) {
                            owningDept = clazz.getManagingDept();
                        } else if (((BaseDepartment)owningDept).getDistributionPrefPriority().intValue() == clazz.getManagingDept().getDistributionPrefPriority().intValue() && !context.getUser().getCurrentAuthority().hasQualifier((Qualifiable)((Object)owningDept)) && context.getUser().getCurrentAuthority().hasQualifier(clazz.getManagingDept())) {
                            owningDept = clazz.getManagingDept();
                        }
                    }
                    relatedInstructionalOfferings.add(clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering());
                    dObj.setPrefGroup(clazz);
                }
                dObj.setSequenceNumber(i + 1);
                distributionObjects.add(dObj);
            }
            dp.setOwner((PreferenceGroup)owningDept);
            if (dp.getUniqueId() == null) {
                hibSession.persist((Object)dp);
            }
            for (DistributionObject dObj : distributionObjects) {
                dObj.setDistributionPref(dp);
                dp.addToDistributionObjects(dObj);
                hibSession.persist((Object)dObj);
                dObj.getPrefGroup().addToDistributionObjects(dObj);
            }
            context.checkPermission(dp, Right.DistributionPreferenceEdit);
            hibSession.merge((Object)dp);
            Permission permissionOfferingLockNeeded = this.getPermission("permissionOfferingLockNeeded");
            ArrayList<Long> changedOfferingIds = new ArrayList<Long>();
            for (InstructionalOffering io : relatedInstructionalOfferings) {
                ChangeLog.addChange(hibSession, context, io, ChangeLog.Source.DIST_PREF_EDIT, data.getPreferenceId() != null ? ChangeLog.Operation.UPDATE : ChangeLog.Operation.CREATE, io.getControllingCourseOffering().getSubjectArea(), null);
                if (!permissionOfferingLockNeeded.check(context.getUser(), io)) continue;
                changedOfferingIds.add(io.getUniqueId());
            }
            if (!changedOfferingIds.isEmpty()) {
                StudentSectioningQueue.offeringChanged(hibSession, context.getUser(), context.getUser().getCurrentAcademicSessionId(), changedOfferingIds);
            }
            tx.commit();
            hibSession.flush();
            hibSession.refresh((Object)dp.getOwner());
            if (oldOwner != null && !oldOwner.equals(dp.getOwner())) {
                hibSession.refresh((Object)oldOwner);
            }
            data.setPreferenceId(dp.getUniqueId());
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            hibSession.clear();
            throw e;
        }
    }

    protected <X> Permission<X> getPermission(String name) {
        return (Permission)SpringApplicationContextHolder.getBean(name);
    }

    @GwtRpcImplements(value=PrefGroupEditInterface.DistributionsLookupClasses.class)
    @GwtRpcLogging(value=GwtRpcLogging.Level.DISABLED)
    public static class LookupClassesBackend
    implements GwtRpcImplementation<PrefGroupEditInterface.DistributionsLookupClasses, GwtRpcResponseList<PrefGroupEditInterface.IdLabel>> {
        @Override
        public GwtRpcResponseList<PrefGroupEditInterface.IdLabel> execute(PrefGroupEditInterface.DistributionsLookupClasses request, SessionContext context) {
            GwtRpcResponseList<PrefGroupEditInterface.IdLabel> ret = new GwtRpcResponseList<PrefGroupEditInterface.IdLabel>();
            TreeSet<Class_> classes = new TreeSet<Class_>(new ClassComparator(5));
            classes.addAll(new Class_DAO().getSession().createQuery("select distinct c from Class_ c where c.schedulingSubpart.uniqueId=:schedulingSubpartId", Class_.class).setFetchSize(200).setCacheable(true).setParameter("schedulingSubpartId", (Object)request.getSubpartId()).list());
            ret.add(new PrefGroupEditInterface.IdLabel(-1L, MSG.dropDistrPrefAll(), null));
            for (Class_ c : classes) {
                ret.add(new PrefGroupEditInterface.IdLabel(c.getUniqueId(), DistributionEditBackend.getClassLabel(c), null));
            }
            return ret;
        }
    }

    @GwtRpcImplements(value=PrefGroupEditInterface.DistributionsLookupSubparts.class)
    @GwtRpcLogging(value=GwtRpcLogging.Level.DISABLED)
    public static class LookupSubpartsBackend
    implements GwtRpcImplementation<PrefGroupEditInterface.DistributionsLookupSubparts, GwtRpcResponseList<PrefGroupEditInterface.IdLabel>> {
        @Override
        public GwtRpcResponseList<PrefGroupEditInterface.IdLabel> execute(PrefGroupEditInterface.DistributionsLookupSubparts request, SessionContext context) {
            GwtRpcResponseList<PrefGroupEditInterface.IdLabel> ret = new GwtRpcResponseList<PrefGroupEditInterface.IdLabel>();
            TreeSet subparts = new TreeSet(new SchedulingSubpartComparator(null));
            subparts.addAll(SchedulingSubpartDAO.getInstance().getSession().createQuery("select distinct s from SchedulingSubpart s inner join s.instrOfferingConfig.instructionalOffering.courseOfferings co where co.uniqueId = :courseOfferingId", SchedulingSubpart.class).setFetchSize(200).setCacheable(true).setParameter("courseOfferingId", (Object)request.getCourseId()).list());
            for (SchedulingSubpart s : subparts) {
                ret.add(new PrefGroupEditInterface.IdLabel(s.getUniqueId(), DistributionEditBackend.getSubpartLabel(s), null));
            }
            return ret;
        }
    }

    @GwtRpcImplements(value=PrefGroupEditInterface.DistributionsLookupCourses.class)
    @GwtRpcLogging(value=GwtRpcLogging.Level.DISABLED)
    public static class LookupCoursesBackend
    implements GwtRpcImplementation<PrefGroupEditInterface.DistributionsLookupCourses, GwtRpcResponseList<PrefGroupEditInterface.IdLabel>> {
        @Override
        public GwtRpcResponseList<PrefGroupEditInterface.IdLabel> execute(PrefGroupEditInterface.DistributionsLookupCourses request, SessionContext context) {
            GwtRpcResponseList<PrefGroupEditInterface.IdLabel> ret = new GwtRpcResponseList<PrefGroupEditInterface.IdLabel>();
            List courseNumbers = CourseOfferingDAO.getInstance().getSession().createQuery("select co.uniqueId, co.courseNbr, co.title from CourseOffering co where co.subjectArea.uniqueId = :subjectAreaId and co.instructionalOffering.notOffered = false and co.isControl = true order by co.courseNbr ", Object[].class).setFetchSize(200).setCacheable(true).setParameter("subjectAreaId", (Object)request.getSubjectId()).list();
            for (Object[] o : courseNumbers) {
                ret.add(new PrefGroupEditInterface.IdLabel((Long)o[0], o[1].toString() + (String)(o[2] == null || o[2].toString().isEmpty() ? "" : " - " + String.valueOf(o[2])), null));
            }
            return ret;
        }
    }
}

