/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.courses;

import java.net.URL;
import java.net.URLEncoder;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.client.offerings.CourseCatalogPage;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.custom.CourseDetailsProvider;
import org.unitime.timetable.onlinesectioning.custom.CourseUrlProvider;
import org.unitime.timetable.onlinesectioning.custom.Customization;
import org.unitime.timetable.security.Qualifiable;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;

@GwtRpcImplements(value=CourseCatalogPage.CatalogRequest.class)
public class CourseCatalogBackend
implements GwtRpcImplementation<CourseCatalogPage.CatalogRequest, CourseCatalogPage.CatalogResponse>,
CourseUrlProvider {
    private static final long serialVersionUID = 2754144696775723663L;
    protected static GwtMessages MSG = Localization.create(GwtMessages.class);

    @Override
    public CourseCatalogPage.CatalogResponse execute(CourseCatalogPage.CatalogRequest request, SessionContext context) {
        Session session = null;
        if (request.getTerm() != null && !request.getTerm().isEmpty()) {
            session = (Session)SessionDAO.getInstance().getSession().createQuery("from Session s where (s.academicTerm || s.academicYear) = :term or (s.academicTerm || s.academicYear || s.academicInitiative) = :term or cast(s.uniqueId as string) = :term", Session.class).setParameter("term", (Object)request.getTerm()).setMaxResults(1).uniqueResult();
            if (session == null) {
                throw new GwtRpcException(MSG.errorSessionNotFound(request.getTerm()));
            }
        } else if (context.getUser() != null) {
            session = (Session)SessionDAO.getInstance().get(context.getUser().getCurrentAcademicSessionId());
        }
        if (session == null) {
            throw new GwtRpcException(MSG.authenticationNoSession());
        }
        context.checkPermissionAnyAuthority((Object)session, Right.CourseCatalog, new Qualifiable[0]);
        CourseDetailsProvider provider = (CourseDetailsProvider)Customization.CourseDetailsProvider.getProvider();
        if (provider == null) {
            throw new GwtRpcException("Course details provider not configured.");
        }
        CourseCatalogPage.CatalogResponse response = new CourseCatalogPage.CatalogResponse();
        response.setContent(provider.getDetails(new AcademicSessionInfo(session), request.getSubject(), request.getCourseNbr()));
        return response;
    }

    @Override
    public URL getCourseUrl(AcademicSessionInfo session, String subject, String courseNbr) throws SectioningException {
        try {
            return new URL(ApplicationProperty.UniTimeUrl.value() + "/catalog?term=" + URLEncoder.encode(session.toCompactString(), "utf-8") + "&subjectCode=" + URLEncoder.encode(subject, "utf-8") + "&courseNumber=" + URLEncoder.encode(courseNbr, "utf-8"));
        }
        catch (Exception e) {
            throw new SectioningException("Failed to get course URL: " + e.getMessage(), e);
        }
    }
}

