/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.admin;

import org.cpsolver.ifs.util.ToolBox;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.SimpleEditInterface;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Program;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.ProgramDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.admin.AdminTable;

@Service(value="gwtAdminTable[type=program]")
public class Programs
implements AdminTable {
    protected static final GwtMessages MESSAGES = Localization.create(GwtMessages.class);

    @Override
    public SimpleEditInterface.PageName name() {
        return new SimpleEditInterface.PageName(MESSAGES.pageProgram(), MESSAGES.pagePrograms());
    }

    @Override
    @PreAuthorize(value="checkPermission('Programs')")
    public SimpleEditInterface load(SessionContext context, org.hibernate.Session hibSession) {
        SimpleEditInterface data = new SimpleEditInterface(new SimpleEditInterface.Field(MESSAGES.fieldExternalId(), SimpleEditInterface.FieldType.text, 240, 40, SimpleEditInterface.Flag.READ_ONLY), new SimpleEditInterface.Field(MESSAGES.fieldCode(), SimpleEditInterface.FieldType.text, 120, 20, SimpleEditInterface.Flag.NOT_EMPTY, SimpleEditInterface.Flag.UNIQUE), new SimpleEditInterface.Field(MESSAGES.fieldName(), SimpleEditInterface.FieldType.text, 360, 60, SimpleEditInterface.Flag.NOT_EMPTY));
        data.setSortBy(1, 2);
        for (Program program : Program.findBySession(hibSession, context.getUser().getCurrentAcademicSessionId())) {
            SimpleEditInterface.Record r = data.addRecord(program.getUniqueId());
            r.setField(0, program.getExternalUniqueId());
            r.setField(1, program.getReference());
            r.setField(2, program.getLabel());
            r.setDeletable(program.getExternalUniqueId() == null);
        }
        data.setEditable(context.hasPermission(Right.ProgramEdit));
        return data;
    }

    @Override
    @PreAuthorize(value="checkPermission('ProgramEdit')")
    public void save(SimpleEditInterface data, SessionContext context, org.hibernate.Session hibSession) {
        for (Program program : Program.findBySession(hibSession, context.getUser().getCurrentAcademicSessionId())) {
            SimpleEditInterface.Record r = data.getRecord(program.getUniqueId());
            if (r == null) {
                this.delete(program, context, hibSession);
                continue;
            }
            this.update(program, r, context, hibSession);
        }
        for (SimpleEditInterface.Record r : data.getNewRecords()) {
            this.save(r, context, hibSession);
        }
    }

    @Override
    @PreAuthorize(value="checkPermission('ProgramEdit')")
    public void save(SimpleEditInterface.Record record, SessionContext context, org.hibernate.Session hibSession) {
        Program program = new Program();
        program.setExternalUniqueId(record.getField(0));
        program.setReference(record.getField(1));
        program.setLabel(record.getField(2));
        program.setSession((Session)SessionDAO.getInstance().get(context.getUser().getCurrentAcademicSessionId(), hibSession));
        hibSession.persist((Object)program);
        record.setUniqueId(program.getUniqueId());
        ChangeLog.addChange(hibSession, context, program, program.getReference() + " " + program.getLabel(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.CREATE, null, null);
    }

    protected void update(Program program, SimpleEditInterface.Record record, SessionContext context, org.hibernate.Session hibSession) {
        if (program == null) {
            return;
        }
        if (!(ToolBox.equals((Object)program.getExternalUniqueId(), (Object)record.getField(0)) && ToolBox.equals((Object)program.getReference(), (Object)record.getField(1)) && ToolBox.equals((Object)program.getLabel(), (Object)record.getField(2)))) {
            program.setExternalUniqueId(record.getField(0));
            program.setReference(record.getField(1));
            program.setLabel(record.getField(2));
            hibSession.merge((Object)program);
            ChangeLog.addChange(hibSession, context, program, program.getReference() + " " + program.getLabel(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.UPDATE, null, null);
        }
    }

    @Override
    @PreAuthorize(value="checkPermission('ProgramEdit')")
    public void update(SimpleEditInterface.Record record, SessionContext context, org.hibernate.Session hibSession) {
        this.update((Program)ProgramDAO.getInstance().get(record.getUniqueId(), hibSession), record, context, hibSession);
    }

    protected void delete(Program program, SessionContext context, org.hibernate.Session hibSession) {
        if (program == null) {
            return;
        }
        ChangeLog.addChange(hibSession, context, program, program.getReference() + " " + program.getLabel(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.DELETE, null, null);
        hibSession.remove((Object)program);
    }

    @Override
    @PreAuthorize(value="checkPermission('ProgramEdit')")
    public void delete(SimpleEditInterface.Record record, SessionContext context, org.hibernate.Session hibSession) {
        this.delete((Program)ProgramDAO.getInstance().get(record.getUniqueId(), hibSession), context, hibSession);
    }
}

