/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.admin;

import org.cpsolver.ifs.util.ToolBox;
import org.hibernate.Session;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.SimpleEditInterface;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.OfferingConsentType;
import org.unitime.timetable.model.dao.OfferingConsentTypeDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.admin.AdminTable;

@Service(value="gwtAdminTable[type=consent]")
public class OfferingConsentTypes
implements AdminTable {
    protected static final GwtMessages MESSAGES = Localization.create(GwtMessages.class);

    @Override
    public SimpleEditInterface.PageName name() {
        return new SimpleEditInterface.PageName(MESSAGES.pageOfferingConsentType(), MESSAGES.pageOfferingConsentTypes());
    }

    @Override
    @PreAuthorize(value="checkPermission('OfferingConsentTypes')")
    public SimpleEditInterface load(SessionContext context, Session hibSession) {
        SimpleEditInterface data = new SimpleEditInterface(new SimpleEditInterface.Field(MESSAGES.fieldReference(), SimpleEditInterface.FieldType.text, 160, 20, SimpleEditInterface.Flag.UNIQUE), new SimpleEditInterface.Field(MESSAGES.fieldName(), SimpleEditInterface.FieldType.text, 300, 60, SimpleEditInterface.Flag.UNIQUE), new SimpleEditInterface.Field(MESSAGES.fieldAbbreviation(), SimpleEditInterface.FieldType.text, 160, 20, SimpleEditInterface.Flag.UNIQUE));
        data.setSortBy(0, 1);
        data.setAddable(false);
        for (OfferingConsentType consent : OfferingConsentTypeDAO.getInstance().findAll()) {
            SimpleEditInterface.Record r = data.addRecord(consent.getUniqueId(), false);
            r.setField(0, consent.getReference(), false);
            r.setField(1, consent.getLabel(), true);
            r.setField(2, consent.getAbbv(), true);
        }
        data.setEditable(context.hasPermission(Right.OfferingConsentTypeEdit));
        return data;
    }

    @Override
    @PreAuthorize(value="checkPermission('OfferingConsentTypeEdit')")
    public void save(SimpleEditInterface data, SessionContext context, Session hibSession) {
        for (OfferingConsentType consent : OfferingConsentTypeDAO.getInstance().findAll()) {
            SimpleEditInterface.Record r = data.getRecord(consent.getUniqueId());
            if (r == null) {
                this.delete(consent, context, hibSession);
                continue;
            }
            this.update(consent, r, context, hibSession);
        }
        for (SimpleEditInterface.Record r : data.getNewRecords()) {
            this.save(r, context, hibSession);
        }
    }

    @Override
    @PreAuthorize(value="checkPermission('OfferingConsentTypeEdit')")
    public void save(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        OfferingConsentType consent = new OfferingConsentType();
        consent.setReference(record.getField(0));
        consent.setLabel(record.getField(1));
        consent.setAbbv(record.getField(2));
        hibSession.persist((Object)consent);
        record.setUniqueId(consent.getUniqueId());
        ChangeLog.addChange(hibSession, context, consent, consent.getReference() + " " + consent.getLabel(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.CREATE, null, null);
    }

    protected void update(OfferingConsentType consent, SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        if (consent == null) {
            return;
        }
        if (ToolBox.equals((Object)consent.getReference(), (Object)record.getField(0)) && ToolBox.equals((Object)consent.getLabel(), (Object)record.getField(1)) && ToolBox.equals((Object)consent.getAbbv(), (Object)record.getField(2))) {
            return;
        }
        consent.setReference(record.getField(0));
        consent.setLabel(record.getField(1));
        consent.setAbbv(record.getField(2));
        hibSession.merge((Object)consent);
        ChangeLog.addChange(hibSession, context, consent, consent.getReference() + " " + consent.getLabel(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.UPDATE, null, null);
    }

    @Override
    @PreAuthorize(value="checkPermission('OfferingConsentTypeEdit')")
    public void update(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        this.update((OfferingConsentType)OfferingConsentTypeDAO.getInstance().get(record.getUniqueId(), hibSession), record, context, hibSession);
    }

    protected void delete(OfferingConsentType consent, SessionContext context, Session hibSession) {
        if (consent == null) {
            return;
        }
        ChangeLog.addChange(hibSession, context, consent, consent.getReference() + " " + consent.getLabel(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.DELETE, null, null);
        hibSession.remove((Object)consent);
    }

    @Override
    @PreAuthorize(value="checkPermission('OfferingConsentTypeEdit')")
    public void delete(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        this.delete((OfferingConsentType)OfferingConsentTypeDAO.getInstance().get(record.getUniqueId(), hibSession), context, hibSession);
    }
}

