/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.admin;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.cpsolver.ifs.util.ToolBox;
import org.hibernate.Session;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.SimpleEditInterface;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.InstructorCourseRequirementType;
import org.unitime.timetable.model.dao.InstructorCourseRequirementTypeDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.admin.AdminTable;

@Service(value="gwtAdminTable[type=instrSurveyNoteTypes]")
public class InstructorSurveyNoteTypes
implements AdminTable {
    protected static final GwtMessages MESSAGES = Localization.create(GwtMessages.class);

    @Override
    public SimpleEditInterface.PageName name() {
        return new SimpleEditInterface.PageName(MESSAGES.pageInstructorSurveyNoteType(), MESSAGES.pageInstructorSurveyNoteTypes());
    }

    protected List<InstructorCourseRequirementType> getInstructorCourseRequirementTypes() {
        return InstructorCourseRequirementTypeDAO.getInstance().getSession().createQuery("from InstructorCourseRequirementType order by sortOrder", InstructorCourseRequirementType.class).list();
    }

    @Override
    @PreAuthorize(value="checkPermission('InstructorSurveyNoteTypes')")
    public SimpleEditInterface load(SessionContext context, Session hibSession) {
        SimpleEditInterface data = new SimpleEditInterface(new SimpleEditInterface.Field(MESSAGES.fieldName(), SimpleEditInterface.FieldType.textarea, 10, 2, 20, SimpleEditInterface.Flag.UNIQUE, SimpleEditInterface.Flag.NOT_EMPTY), new SimpleEditInterface.Field(MESSAGES.fieldDescription(), SimpleEditInterface.FieldType.textarea, 30, 2, 60, SimpleEditInterface.Flag.UNIQUE, SimpleEditInterface.Flag.NOT_EMPTY), new SimpleEditInterface.Field(MESSAGES.fieldColumnWidth(), SimpleEditInterface.FieldType.number, 40, 10, SimpleEditInterface.Flag.NOT_EMPTY));
        data.setSaveOrder(false);
        data.setCanMoveUpAndDown(true);
        data.setAllowSort(false);
        for (InstructorCourseRequirementType type : this.getInstructorCourseRequirementTypes()) {
            SimpleEditInterface.Record r = data.addRecord(type.getUniqueId());
            r.setField(0, type.getReference());
            r.setField(1, type.getLabel());
            r.setField(2, type.getLength().toString());
            r.setOrder(type.getSortOrder());
        }
        data.setEditable(context.hasPermission(Right.InstructorSurveyNoteTypeEdit));
        return data;
    }

    protected int nextOrd(Set<Integer> ords) {
        for (int i = 0; i < ords.size() + 1; ++i) {
            if (ords.contains(i)) continue;
            ords.add(i);
            return i;
        }
        return ords.size();
    }

    protected int nextOrd() {
        List types = InstructorCourseRequirementTypeDAO.getInstance().findAll();
        int idx = 0;
        block0: while (true) {
            for (InstructorCourseRequirementType t : types) {
                if (idx != t.getSortOrder()) continue;
                ++idx;
                continue block0;
            }
            break;
        }
        return idx;
    }

    @Override
    @PreAuthorize(value="checkPermission('InstructorSurveyNoteTypeEdit')")
    public void save(SimpleEditInterface data, SessionContext context, Session hibSession) {
        HashSet<Integer> ords = new HashSet<Integer>();
        for (SimpleEditInterface.Record r : data.getRecords()) {
            if (r.isEmpty(data)) continue;
            r.setOrder(this.nextOrd(ords));
        }
        for (InstructorCourseRequirementType type : InstructorCourseRequirementTypeDAO.getInstance().findAll()) {
            SimpleEditInterface.Record r = data.getRecord(type.getUniqueId());
            if (r == null) {
                this.delete(type, context, hibSession);
                continue;
            }
            this.update(type, r, context, hibSession);
        }
        for (SimpleEditInterface.Record r : data.getNewRecords()) {
            this.save(r, context, hibSession);
        }
    }

    @Override
    @PreAuthorize(value="checkPermission('InstructorSurveyNoteTypeEdit')")
    public void save(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        InstructorCourseRequirementType type = new InstructorCourseRequirementType();
        if (record.getOrder() == null) {
            record.setOrder(this.nextOrd());
        }
        type.setReference(record.getField(0));
        type.setLabel(record.getField(1));
        type.setLength(Integer.parseInt(record.getField(2)));
        type.setSortOrder(record.getOrder());
        hibSession.persist((Object)type);
        record.setUniqueId(type.getUniqueId());
        ChangeLog.addChange(hibSession, context, type, type.getReference(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.CREATE, null, null);
    }

    protected void update(InstructorCourseRequirementType type, SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        if (type == null) {
            return;
        }
        if (ToolBox.equals((Object)type.getReference(), (Object)record.getField(0)) && ToolBox.equals((Object)type.getLabel(), (Object)record.getField(1)) && ToolBox.equals((Object)type.getLength().toString(), (Object)record.getField(2)) && ToolBox.equals((Object)type.getSortOrder(), (Object)record.getOrder())) {
            return;
        }
        type.setReference(record.getField(0));
        type.setLabel(record.getField(1));
        type.setLength(Integer.parseInt(record.getField(2)));
        type.setSortOrder(record.getOrder());
        hibSession.merge((Object)type);
        ChangeLog.addChange(hibSession, context, type, type.getReference(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.UPDATE, null, null);
    }

    @Override
    @PreAuthorize(value="checkPermission('InstructorSurveyNoteTypeEdit')")
    public void update(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        this.update((InstructorCourseRequirementType)InstructorCourseRequirementTypeDAO.getInstance().get(record.getUniqueId(), hibSession), record, context, hibSession);
    }

    protected void delete(InstructorCourseRequirementType type, SessionContext context, Session hibSession) {
        if (type == null) {
            return;
        }
        ChangeLog.addChange(hibSession, context, type, type.getReference(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.DELETE, null, null);
        hibSession.remove((Object)type);
    }

    @Override
    @PreAuthorize(value="checkPermission('InstructorSurveyNoteTypeEdit')")
    public void delete(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        this.delete((InstructorCourseRequirementType)InstructorCourseRequirementTypeDAO.getInstance().get(record.getUniqueId(), hibSession), context, hibSession);
    }
}

