/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.admin;

import org.cpsolver.ifs.util.ToolBox;
import org.hibernate.Session;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.SimpleEditInterface;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.CourseType;
import org.unitime.timetable.model.dao.CourseTypeDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.admin.AdminTable;

@Service(value="gwtAdminTable[type=courseType]")
public class CourseTypes
implements AdminTable {
    protected static final GwtMessages MESSAGES = Localization.create(GwtMessages.class);

    @Override
    public SimpleEditInterface.PageName name() {
        return new SimpleEditInterface.PageName(MESSAGES.pageCourseType(), MESSAGES.pageCourseTypes());
    }

    @Override
    @PreAuthorize(value="checkPermission('CourseTypes')")
    public SimpleEditInterface load(SessionContext context, Session hibSession) {
        SimpleEditInterface data = new SimpleEditInterface(new SimpleEditInterface.Field(MESSAGES.fieldAbbreviation(), SimpleEditInterface.FieldType.text, 160, 20, SimpleEditInterface.Flag.UNIQUE), new SimpleEditInterface.Field(MESSAGES.fieldName(), SimpleEditInterface.FieldType.text, 300, 60, SimpleEditInterface.Flag.UNIQUE));
        data.setSortBy(1);
        for (CourseType ctype : CourseTypeDAO.getInstance().findAll()) {
            SimpleEditInterface.Record r = data.addRecord(ctype.getUniqueId());
            r.setField(0, ctype.getReference());
            r.setField(1, ctype.getLabel());
            int used = ((Number)hibSession.createQuery("select count(c) from CourseOffering c where c.courseType.uniqueId = :uniqueId", Number.class).setParameter("uniqueId", (Object)ctype.getUniqueId()).uniqueResult()).intValue();
            r.setDeletable(used == 0);
        }
        data.setEditable(context.hasPermission(Right.CourseTypeEdit));
        return data;
    }

    @Override
    @PreAuthorize(value="checkPermission('CourseTypeEdit')")
    public void save(SimpleEditInterface data, SessionContext context, Session hibSession) {
        for (CourseType type : CourseTypeDAO.getInstance().findAll(hibSession)) {
            SimpleEditInterface.Record r = data.getRecord(type.getUniqueId());
            if (r == null) {
                this.delete(type, context, hibSession);
                continue;
            }
            this.update(type, r, context, hibSession);
        }
        for (SimpleEditInterface.Record r : data.getNewRecords()) {
            this.save(r, context, hibSession);
        }
    }

    @Override
    @PreAuthorize(value="checkPermission('CourseTypeEdit')")
    public void save(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        CourseType type = new CourseType();
        type.setReference(record.getField(0));
        type.setLabel(record.getField(1));
        hibSession.persist((Object)type);
        record.setUniqueId(type.getUniqueId());
        ChangeLog.addChange(hibSession, context, type, type.getReference(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.CREATE, null, null);
    }

    protected void update(CourseType type, SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        if (type == null) {
            return;
        }
        if (ToolBox.equals((Object)type.getReference(), (Object)record.getField(0)) && ToolBox.equals((Object)type.getLabel(), (Object)record.getField(1))) {
            return;
        }
        type.setReference(record.getField(0));
        type.setLabel(record.getField(1));
        hibSession.merge((Object)type);
        ChangeLog.addChange(hibSession, context, type, type.getReference(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.UPDATE, null, null);
    }

    @Override
    @PreAuthorize(value="checkPermission('CourseTypeEdit')")
    public void update(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        this.update((CourseType)CourseTypeDAO.getInstance().get(record.getUniqueId(), hibSession), record, context, hibSession);
    }

    protected void delete(CourseType type, SessionContext context, Session hibSession) {
        if (type == null) {
            return;
        }
        ChangeLog.addChange(hibSession, context, type, type.getReference(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.DELETE, null, null);
        hibSession.remove((Object)type);
    }

    @Override
    @PreAuthorize(value="checkPermission('CourseTypeEdit')")
    public void delete(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        this.delete((CourseType)CourseTypeDAO.getInstance().get(record.getUniqueId(), hibSession), context, hibSession);
    }
}

